/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.patch.DiffProject;
import org.eclipse.compare.internal.patch.Hunk;
import org.eclipse.compare.internal.patch.PatchMessages;
import org.eclipse.compare.internal.patch.WorkspacePatcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class Diff
implements IWorkbenchAdapter,
IAdaptable {
    IPath fOldPath;
    IPath fNewPath;
    long fOldDate;
    long fNewDate;
    List fHunks = new ArrayList();
    boolean fMatches = false;
    private boolean fIsEnabled2 = true;
    String fRejected;
    DiffProject fProject;
    boolean fDiffProblem;
    String fErrorMessage;
    int fStrip;
    int fFuzzFactor;
    static ImageDescriptor addId = CompareUIPlugin.getImageDescriptor("ovr16/add_ov.gif");
    static ImageDescriptor delId = CompareUIPlugin.getImageDescriptor("ovr16/del_ov.gif");
    private WorkspacePatcher patcher;
    static /* synthetic */ Class class$0;

    Diff(IPath oldPath, long oldDate, IPath newPath, long newDate) {
        this.fOldPath = oldPath;
        this.fOldDate = oldPath == null ? 0L : oldDate;
        this.fNewPath = newPath;
        this.fNewDate = newPath == null ? 0L : newDate;
    }

    boolean isEnabled() {
        return this.fIsEnabled2;
    }

    void setEnabled(boolean b) {
        this.fIsEnabled2 = b;
    }

    void reverse() {
        IPath tp = this.fOldPath;
        this.fOldPath = this.fNewPath;
        this.fNewPath = tp;
        long t = this.fOldDate;
        this.fOldDate = this.fNewDate;
        this.fNewDate = t;
        Iterator iter = this.fHunks.iterator();
        while (iter.hasNext()) {
            Hunk hunk = (Hunk)iter.next();
            hunk.reverse();
        }
    }

    Hunk[] getHunks() {
        return this.fHunks.toArray(new Hunk[this.fHunks.size()]);
    }

    IPath getPath() {
        if (this.fOldPath != null) {
            return this.fOldPath;
        }
        return this.fNewPath;
    }

    void finish() {
        if (this.fHunks.size() == 1) {
            Hunk h = (Hunk)this.fHunks.get(0);
            if (h.fNewLength == 0) {
                this.fNewDate = 0L;
                this.fNewPath = this.fOldPath;
            }
        }
    }

    void add(Hunk hunk) {
        this.fHunks.add(hunk);
    }

    int getType() {
        if (this.fOldDate == 0L) {
            return 1;
        }
        if (this.fNewDate == 0L) {
            return 2;
        }
        return 3;
    }

    String getDescription(int strip) {
        IPath path = this.getStrippedPath(strip);
        return path.toOSString();
    }

    private IPath getStrippedPath(int strip) {
        IPath path = this.fOldPath;
        if (this.fOldDate == 0L) {
            path = this.fNewPath;
        }
        if (strip > 0 && strip < path.segmentCount()) {
            path = path.removeFirstSegments(strip);
        }
        return path;
    }

    DiffProject getProject() {
        return this.fProject;
    }

    public void setProject(DiffProject diffProject) {
        this.fProject = diffProject;
        this.fProject.addDiff(this);
    }

    ArrayList reset(WorkspacePatcher wspatcher, int strip, int fuzzfactor) {
        this.fMatches = false;
        this.fDiffProblem = false;
        this.fStrip = strip;
        this.fFuzzFactor = fuzzfactor;
        this.patcher = wspatcher;
        ArrayList failedHunks = this.checkForFileExistance();
        ArrayList<Hunk> hunksToCheck = new ArrayList<Hunk>();
        boolean projectExistsInWorkspace = true;
        if (this.fProject != null) {
            projectExistsInWorkspace = this.fProject.getProject().exists();
        }
        Iterator iter = this.fHunks.iterator();
        while (iter.hasNext()) {
            Hunk hunk = (Hunk)iter.next();
            boolean hunkFailed = failedHunks.contains(hunk);
            if (hunkFailed) {
                this.fMatches = false;
            }
            hunk.reset(hunkFailed);
            if (hunkFailed || !projectExistsInWorkspace || this.fDiffProblem) continue;
            hunksToCheck.add(hunk);
        }
        return hunksToCheck;
    }

    private ArrayList checkForFileExistance() {
        IFile file = this.getTargetFile();
        boolean create = false;
        if (this.getType() == 1) {
            if (file == null || !file.exists()) {
                this.fMatches = true;
            } else {
                this.fDiffProblem = true;
                this.fErrorMessage = PatchMessages.PreviewPatchPage_FileExists_error;
            }
            create = true;
        } else if (file != null) {
            this.fMatches = true;
        } else {
            this.fDiffProblem = true;
            this.fErrorMessage = PatchMessages.PreviewPatchPage_FileDoesNotExist_error;
        }
        ArrayList failedHunks = new ArrayList();
        this.patcher.setFuzz(this.fFuzzFactor);
        if (!this.fDiffProblem) {
            this.patcher.apply(this, file, create, failedHunks);
        }
        if (failedHunks.size() > 0) {
            this.fRejected = this.patcher.getRejected(failedHunks);
        }
        return failedHunks;
    }

    public WorkspacePatcher getPatcher() {
        return this.patcher;
    }

    public IFile getTargetFile() {
        if (this.fProject != null) {
            return this.fProject.getFile(this.getStrippedPath(this.fStrip));
        }
        return this.getPatcher().existsInTarget(this.getStrippedPath(this.fStrip));
    }

    public Object[] getChildren(Object o) {
        return this.fHunks.toArray();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        if (object instanceof Diff) {
            Diff diff = (Diff)object;
            switch (diff.getType()) {
                case 1: {
                    return addId;
                }
                case 2: {
                    return delId;
                }
            }
        }
        return null;
    }

    public String getLabel(Object o) {
        String label = this.getDescription(this.fStrip);
        if (this.fDiffProblem) {
            return NLS.bind((String)PatchMessages.Diff_2Args, (Object[])new String[]{label, this.fErrorMessage});
        }
        return label;
    }

    public Object getParent(Object o) {
        return this.fProject;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        return null;
    }

    protected boolean getDiffProblem() {
        return this.fDiffProblem;
    }

    protected boolean containsProblems() {
        if (this.fDiffProblem) {
            return true;
        }
        Iterator iter = this.fHunks.iterator();
        while (iter.hasNext()) {
            Hunk element = (Hunk)iter.next();
            if (!element.getHunkProblem()) continue;
            return true;
        }
        return false;
    }
}

