/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.xml.services;

import java.io.File;
import org.eclipse.epf.dataexchange.util.BaseResourceHandler;
import org.eclipse.epf.dataexchange.util.UrlInfo;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.MethodElement;

public class ImportResourceHandler
extends BaseResourceHandler {
    public ImportResourceHandler(File sourceLibRoot, File targetLibRoot) {
        super(sourceLibRoot, targetLibRoot);
    }

    public UrlInfo resolveFileUrl(Object owner, String srcUrl) throws Exception {
        UrlInfo info = new UrlInfo();
        info.sourceUrl = srcUrl;
        info.sourceFile = new File(this.sourceLibRoot, srcUrl).getCanonicalFile();
        info.targetUrl = srcUrl;
        info.targetFile = null;
        if (info.sourceFile == null || !info.sourceFile.exists()) {
            return info;
        }
        if (owner instanceof MethodElement) {
            info.targetUrl = this.fixUrl(srcUrl);
            String elementPath = ResourceHelper.getElementPath((MethodElement)((MethodElement)owner));
            info.targetFile = new File(new File(this.targetLibRoot, elementPath), info.targetUrl);
        } else {
            info.targetUrl = srcUrl;
            info.sourceFile = new File(this.sourceLibRoot, srcUrl);
        }
        return info;
    }

    private String fixUrl(String url) {
        int indx = (url = url.replace(File.separatorChar, '/')).lastIndexOf("resources/");
        if (indx >= 0) {
            return url.substring(indx);
        }
        return new File("resources", url).toString().replace(File.separatorChar, '/');
    }
}

