<?xml version="1.0" encoding="UTF-8"?>
<!-- 
    Copyright (c) 2005, 2006 IBM Corporation and others.
    All rights reserved. This program and the accompanying materials
    are made available under the terms of the Eclipse Public License v1.0
    which accompanies this distribution, and is available at
    http://www.eclipse.org/legal/epl-v10.html
    Contributors:
    IBM Corporation - initial implementation
-->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	
	<xsl:include href="helper.xsl"/>

	
	<xsl:template name="workProductIllustrationsSection">
		<xsl:variable name="templates" select="referenceList/Element[@Type='Template']"/>
		<xsl:variable name="reports" select="referenceList/Element[@Type='Report']"/>
		<xsl:variable name="examples" select="referenceList/Element[@Type='Example']"/>
		<xsl:variable name="reusableAssets" select="referenceList/Element[@Type='ReusableAsset']"/>	
		<xsl:if test="count($templates) + count($reports) + count($examples) + count($reusableAssets) > 0">
			<div class="sectionHeading"><xsl:value-of select="$illustrationsText"/></div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<xsl:call-template name="addTemplates">
						<xsl:with-param name="templates" select="$templates"/>
					</xsl:call-template>
					<xsl:call-template name="addReports">
						<xsl:with-param name="reports" select="$reports"/>
					</xsl:call-template>
					<xsl:call-template name="addExamples">
						<xsl:with-param name="examples" select="$examples"/>
					</xsl:call-template>
					<xsl:call-template name="addReusableAssets">
						<xsl:with-param name="reusableAssets" select="$reusableAssets"/>
					</xsl:call-template>
				</table>
			</div>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="relationshipsSection">
		<xsl:variable name="containerArtifact" select="reference[@name='containerArtifact']/Element"/>
		<xsl:variable name="containedArtifacts" select="referenceList[@name='containedArtifacts']/Element[@Type='Artifact']"/>
		<xsl:variable name="responsibleRoles" select="referenceList[@name='responsibleRoles']/Element[@Type='Role']"/>
		<xsl:variable name="modifyRoles" select="referenceList[@name='modifyRoles']/Element"/>		
		<xsl:variable name="mandatoryInputToTasks" select="referenceList[@name='mandatoryInputToTasks']/Element[@Type='Task']"/>
		<xsl:variable name="optionalInputToTasks" select="referenceList[@name='optionalInputToTasks']/Element[@Type='Task']"/>
		<xsl:variable name="outputFromTasks" select="referenceList[@name='outputFromTasks']/Element[@Type='Task']"/>
		
		<xsl:if test="count($responsibleRoles) + count($containerArtifact) + count($containedArtifacts) + count($mandatoryInputToTasks) + count($optionalInputToTasks) + count($outputFromTasks) > 0">
			<div class="sectionHeading"><xsl:value-of select="$relationshipsText"/></div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<xsl:if test="count($containerArtifact) > 0">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$containerArtifactText"/></th>
							<td class="sectionTableCell" colspan="2">
								<xsl:for-each select="$containerArtifact">
								<xsl:sort select="@DisplayName"/>
									<li>
										<a>
											<xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute>
											<xsl:value-of select="@DisplayName"/>
										</a>
									</li>
								</xsl:for-each>
							</td>
						</tr>
					</xsl:if>				
					<xsl:if test="count($containedArtifacts) > 0">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$containedArtifactsText"/></th>
							<td class="sectionTableCell" colspan="2">
								<xsl:for-each select="$containedArtifacts">
									<xsl:sort data-type="text" select="@DisplayName" order="ascending" />
									<li>
										<a>
											<xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute>											
											<xsl:value-of select="@DisplayName"/>
										</a>
									</li>
								</xsl:for-each>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="count($responsibleRoles) + count($modifyRoles) > 0">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$rolesText"/></th>
							<td class="sectionTableCell" width="42%">
								<xsl:value-of select="$responsibleText"/>:
								<xsl:if test="count($responsibleRoles) > 0">
								<ul>
									<xsl:for-each select="$responsibleRoles">
									<xsl:sort select="@DisplayName"/>
										<li>
										<!--
											<a><xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute><xsl:value-of select="@DisplayName"/></a>
-->
						<xsl:call-template name="addElementWithLink">
							<xsl:with-param name="element" select="."/>
						</xsl:call-template>

										</li>
									</xsl:for-each>
								</ul>
								</xsl:if>
							</td>
							<td class="sectionTableCell">
								<xsl:value-of select="$modifiedByText"/>:
								<xsl:if test="count($modifyRoles) > 0">									
								<ul>
									<xsl:for-each select="$modifyRoles">
									<xsl:sort select="@DisplayName"/>
										<li>
											<a><xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute><xsl:value-of select="@DisplayName"/></a>
										</li>
									</xsl:for-each>
								</ul>
								</xsl:if>
							</td>							
						</tr>
					</xsl:if>
					<xsl:if test="count($mandatoryInputToTasks) + count($optionalInputToTasks) + count($outputFromTasks) > 0">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$tasksText"/></th>
							<td class="sectionTableCell" width="42%">
								<xsl:value-of select="$inputToText"/>:
								<xsl:if test="count($mandatoryInputToTasks) + count($optionalInputToTasks) > 0">
								    <xsl:if test="count($mandatoryInputToTasks) > 0">
									<ul>
										<xsl:for-each select="$mandatoryInputToTasks">
										<xsl:sort select="@DisplayName"/>
											<li>
												<a><xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute><xsl:value-of select="@DisplayName"/></a>
											</li>
										</xsl:for-each>
									</ul>
									</xsl:if>
									<xsl:if test="count($optionalInputToTasks) > 0">
									  <xsl:if test="count($mandatoryInputToTasks) > 0"><br/></xsl:if>
									<ul>		
										<xsl:for-each select="$optionalInputToTasks">
										<xsl:sort select="@DisplayName"/>
											<li>
												<a><xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute><xsl:value-of select="@DisplayName"/></a>
											</li>
										</xsl:for-each>										
									</ul>
									</xsl:if>
								</xsl:if>
							</td>
							<td class="sectionTableCell">
								<xsl:value-of select="$outputFromText"/>:
								<xsl:if test="count($outputFromTasks) > 0">									
									<ul>
										<xsl:for-each select="$outputFromTasks">
										<xsl:sort select="@DisplayName"/>
											<li>
												<a><xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute><xsl:value-of select="@DisplayName"/></a>
											</li>
										</xsl:for-each>
									</ul>
								</xsl:if>
							</td>							
						</tr>
					</xsl:if>
				</table>
			</div>
		</xsl:if>
	</xsl:template>

	<xsl:template name="moreInfoSection">
		<xsl:variable name="checklists" select="referenceList/Element[@Type='Checklist']"/>
		<xsl:variable name="concepts" select="referenceList/Element[@Type='Concept']"/>
		<xsl:variable name="guidelines" select="referenceList/Element[@Type='Guideline']"/>
		<xsl:variable name="supportingMaterials" select="referenceList/Element[@Type='SupportingMaterial']"/>
		<xsl:variable name="toolMentors" select="referenceList/Element[@Type='ToolMentor']"/>
		<xsl:variable name="whitePapers" select="referenceList/Element[@Type='Whitepaper']"/>
		<xsl:variable name="estimationConsiderations" select="referenceList/Element[@Type='EstimationConsiderations']"/>
		
		<xsl:if test="count($checklists) + count($concepts) + count($guidelines) + count($supportingMaterials) + count($toolMentors) + count($whitePapers) + count($estimationConsiderations) > 0">
			<div class="sectionHeading"><xsl:value-of select="$moreInfoText"/></div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<xsl:call-template name="addChecklists">
						<xsl:with-param name="checklists" select="$checklists"/>
					</xsl:call-template>
					<xsl:call-template name="addConcepts">
						<xsl:with-param name="concepts" select="$concepts"/>
					</xsl:call-template>
					<xsl:call-template name="addGuidelines">
						<xsl:with-param name="guidelines" select="$guidelines"/>
					</xsl:call-template>
					<xsl:call-template name="addSupportingMaterials">
						<xsl:with-param name="supportingMaterials" select="$supportingMaterials"/>
					</xsl:call-template>
					<xsl:call-template name="addToolMentors">
						<xsl:with-param name="toolMentors" select="$toolMentors"/>
					</xsl:call-template>
					<xsl:call-template name="addWhitePapers">
						<xsl:with-param name="whitePapers" select="$whitePapers"/>
					</xsl:call-template>
					<xsl:call-template name="addEstimationConsiderations">
						<xsl:with-param name="estimationConsiderations" select="$estimationConsiderations"/>
					</xsl:call-template>
				</table>
			</div>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>
