/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.serviceability.VersionUtil;
import org.eclipse.epf.export.services.LibraryDocument;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.ConfigSpecsImportManager;
import org.eclipse.epf.importing.services.ConfigurationImportData;
import org.eclipse.epf.importing.services.ElementDiffTree;
import org.eclipse.epf.importing.services.LibraryDiffManager;
import org.eclipse.epf.importing.services.LibraryImportManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.project.MethodLibraryProject;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceUtil;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.osgi.util.NLS;

public class ConfigurationImportService {
    private ConfigurationImportData data;
    LibraryDocument importingLibDoc = null;
    LibraryDiffManager diffMgr = null;
    ConfigSpecsImportManager specsMgr = null;

    public ConfigurationImportService(ConfigurationImportData data) {
        this.data = data;
    }

    public void analyze(IProgressMonitor monitor) {
        block13: {
            try {
                File importingLibPath;
                if (monitor != null) {
                    monitor.setTaskName(ImportResources.ConfigurationImportService_MSG0);
                }
                this.data.getErrorInfo().clear();
                String path = this.data.llData.getParentFolder();
                if (path.indexOf(String.valueOf(File.separator) + "library.xmi") < 0) {
                    path = String.valueOf(path) + File.separator + "library.xmi";
                }
                if (!(importingLibPath = new File(path)).exists()) {
                    importingLibPath = new File(importingLibPath.getParentFile(), "export.xmi");
                }
                if (!importingLibPath.exists()) {
                    this.data.getErrorInfo().addError(NLS.bind((String)ImportResources.ConfigurationImportService_MSG1, (Object)importingLibPath.getParent()));
                    return;
                }
                this.importingLibDoc = new LibraryDocument(importingLibPath);
                String versionError = ConfigurationImportService.versionCheck(importingLibPath.getAbsolutePath(), ImportResources.importConfigWizard_title);
                if (versionError != null) {
                    this.data.getErrorInfo().addError(versionError);
                    return;
                }
                boolean isConfigSpecs = this.importingLibDoc.isConfigSpecsOnly();
                if (isConfigSpecs) {
                    this.specsMgr = new ConfigSpecsImportManager();
                    this.data.specs = this.specsMgr.getConfigSpecs(this.importingLibDoc);
                    break block13;
                }
                this.data.specs = null;
                String libDir = importingLibPath.getParentFile().getAbsolutePath();
                MethodLibraryProject.openProject((String)libDir, (IProgressMonitor)monitor);
                try {
                    MethodLibrary importLibraty = LibraryUtil.loadLibrary((String)importingLibPath.getAbsolutePath());
                    MethodLibrary baseLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
                    String baseLibDir = null;
                    try {
                        File bFile = new File(baseLibrary.eResource().getURI().toFileString()).getParentFile();
                        baseLibDir = bFile.getAbsolutePath();
                    }
                    catch (Throwable throwable) {}
                    if (libDir.equalsIgnoreCase(baseLibDir)) {
                        this.data.getErrorInfo().addError(NLS.bind((String)ImportResources.ConfigurationImportService_MSG2, (Object)importingLibPath.getParent()));
                        return;
                    }
                    ConfigurationImportService.fixImportLibrarySystemPackageGUIDs(baseLibrary, importLibraty);
                    this.diffMgr = new LibraryDiffManager(baseLibrary, importLibraty);
                    this.diffMgr.buildDiffTree();
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                MethodLibraryProject.closeProject((String)libDir, (IProgressMonitor)monitor);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public ConfigurationImportData getImportData() {
        return this.data;
    }

    public boolean isSpecsOnly() {
        return this.data.specs != null;
    }

    public ElementDiffTree getDiffTree() {
        return this.diffMgr.getDiffTree();
    }

    public MethodLibrary getImportingLibrary() {
        return this.diffMgr.getImportingLibrary();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performImport(IProgressMonitor monitor) {
        refresh = RefreshJob.getInstance().isEnabled();
        if (refresh) {
            RefreshJob.getInstance().setEnabled(false);
        }
        try {
            try {
                if (monitor != null) {
                    monitor.setTaskName(ImportResources.ConfigurationImportService_MSG3);
                }
                if (this.isSpecsOnly()) {
                    this.specsMgr.doImport(this.data.specs);
                } else {
                    importingMgr = new LibraryImportManager(this.diffMgr, this.data.importList);
                    importingMgr.doMerge(this.data.replaceExisting, monitor);
                }
                lib = LibraryService.getInstance().getCurrentMethodLibrary();
                ResourceUtil.refreshResources((MethodLibrary)lib, (IProgressMonitor)monitor);
            }
            catch (Exception e) {
                ImportPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
        catch (Throwable var5_5) {
            var4_6 = null;
            if (refresh == false) throw var5_5;
            RefreshJob.getInstance().setEnabled(true);
            throw var5_5;
        }
        {
            var4_7 = null;
            if (!refresh) ** GOTO lbl-1000
        }
        RefreshJob.getInstance().setEnabled(true);
lbl-1000:
        // 2 sources

        {
            LibraryService.getInstance().reopenCurrentMethodLibrary();
            return;
        }
    }

    public static String versionCheck(final String xmlPath, final String title) {
        final String[] ret = new String[]{null};
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                VersionUtil.VersionCheckInfo info = VersionUtil.checkLibraryVersion((File)new File(xmlPath));
                if (info == null) {
                    ret[0] = NLS.bind((String)ImportResources.versionMismatch_oldData_unknown, (Object[])new Object[]{Platform.getProduct().getName()});
                } else if (info.result < 0) {
                    ret[0] = info.toolID.equals(VersionUtil.getPrimaryToolID()) ? NLS.bind((String)ImportResources.versionMismatch_oldData, (Object[])new Object[]{info.toolVersion, Platform.getProduct().getName()}) : NLS.bind((String)ImportResources.versionMismatch_oldData_unknown, (Object[])new Object[]{Platform.getProduct().getName()});
                } else if (info.result > 0) {
                    ret[0] = info.toolID.equals(VersionUtil.getPrimaryToolID()) ? NLS.bind((String)ImportResources.versionMismatch_oldTool, (Object[])new Object[]{info.toolVersion, Platform.getProduct().getName()}) : NLS.bind((String)ImportResources.versionMismatch_oldTool_unknown, (Object[])new Object[]{Platform.getProduct().getName()});
                }
                if (ret[0] != null) {
                    ImportPlugin.getDefault().getMsgDialog().displayError(title, ret[0]);
                }
            }
        });
        return ret[0];
    }

    public static void fixImportLibrarySystemPackageGUIDs(MethodLibrary baseLibrary, MethodLibrary importLibraty) {
        HashMap<String, MethodPlugin> pluginsMap = new HashMap<String, MethodPlugin>();
        List plugins = baseLibrary.getMethodPlugins();
        int i = 0;
        while (i < plugins.size()) {
            MethodPlugin plugin = (MethodPlugin)plugins.get(i);
            pluginsMap.put(plugin.getGuid(), plugin);
            ++i;
        }
        if (pluginsMap.isEmpty()) {
            return;
        }
        ArrayList<MethodPlugin> importPluginsToFix = new ArrayList<MethodPlugin>();
        List importPlugins = importLibraty.getMethodPlugins();
        int i2 = 0;
        while (i2 < importPlugins.size()) {
            MethodPlugin plugin = (MethodPlugin)importPlugins.get(i2);
            if (pluginsMap.containsKey(plugin.getGuid())) {
                importPluginsToFix.add(plugin);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < importPluginsToFix.size()) {
            MethodPlugin importPlugin = (MethodPlugin)importPluginsToFix.get(i2);
            MethodPlugin basePlugin = (MethodPlugin)pluginsMap.get(importPlugin.getGuid());
            if (basePlugin != null) {
                List importPackages = TngUtil.getAllSystemPackages((MethodPlugin)importPlugin);
                HashMap<String, MethodElement> importPackageMap = new HashMap<String, MethodElement>();
                int j = 0;
                while (j < importPackages.size()) {
                    MethodElement importPackage = (MethodElement)importPackages.get(j);
                    importPackageMap.put(importPackage.getName(), importPackage);
                    ++j;
                }
                List basePackages = TngUtil.getAllSystemPackages((MethodPlugin)basePlugin);
                int j2 = 0;
                while (j2 < basePackages.size()) {
                    MethodElement basePackage = (MethodElement)basePackages.get(j2);
                    MethodElement importPackage = (MethodElement)importPackageMap.get(basePackage.getName());
                    if (importPackage != null) {
                        String guid = basePackage.getGuid();
                        if (!importPackage.getGuid().equals(guid)) {
                            importPackage.setGuid(guid);
                        }
                    }
                    ++j2;
                }
            }
            ++i2;
        }
    }
}

