/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.common.serviceability.EPFVersions;
import org.eclipse.epf.common.serviceability.VersionUtil;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class PersistenceUtil {
    public static final String getUMANsURI() {
        Iterator iter = EPackage.Registry.INSTANCE.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (!(entry.getValue() instanceof UmaPackage)) continue;
            return entry.getKey().toString();
        }
        return null;
    }

    public static final String getUMANsURI(String libPath) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(new File(libPath));
            Element root = doc.getDocumentElement();
            String nsURI = root.getAttribute("xmlns:com.ibm.uma");
            if (nsURI == null || nsURI.equals("")) {
                nsURI = root.getAttribute("xmlns:org.eclipse.epf.uma");
            }
            return nsURI;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static final boolean conversionRequired(String libPath) {
        String libNsURI;
        String currentNsURI = PersistenceUtil.getUMANsURI();
        if (currentNsURI.equals(libNsURI = PersistenceUtil.getUMANsURI(libPath))) {
            return false;
        }
        return "http:///com/ibm/uma.ecore".equals(libNsURI);
    }

    public static final IResource getWorkspaceResource(Object obj) {
        Resource resource = null;
        if (obj instanceof ContentElement) {
            ContentElement e = (ContentElement)obj;
            ContentDescription content = e.getPresentation();
            resource = content.eResource();
            if (resource == null) {
                resource = e.eResource();
            }
        } else if (obj instanceof EObject) {
            resource = ((EObject)obj).eResource();
        }
        if (resource != null) {
            return FileManager.getResourceForLocation(resource.getURI().toFileString());
        }
        return null;
    }

    public static final Collection getProxies(EObject obj) {
        ArrayList<EObject> proxies = new ArrayList<EObject>();
        TreeIterator iter = obj.eAllContents();
        while (iter.hasNext()) {
            EObject o = (EObject)iter.next();
            if (!o.eIsProxy()) continue;
            proxies.add(o);
        }
        return proxies;
    }

    public static final int checkToolVersion(Resource resource) {
        String version;
        File file = new File(resource.getURI().toFileString());
        Map fileVersionMap = VersionUtil.readVersionsFromFile((File)file);
        if (fileVersionMap != null && (version = (String)fileVersionMap.get(VersionUtil.getPrimaryToolID())) != null) {
            EPFVersions versions = VersionUtil.getVersions((String)VersionUtil.getPrimaryToolID());
            return versions.getCurrentVersion().compareToolVersionTo(new Version(version));
        }
        return -1;
    }

    public static MethodElement getMethodElement(Resource resource) {
        Iterator iter = resource.getContents().iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof MethodElement)) continue;
            return (MethodElement)element;
        }
        return null;
    }
}

