/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.xml.wizards;

import java.io.File;
import org.eclipse.epf.importing.xml.ImportXMLPlugin;
import org.eclipse.epf.importing.xml.ImportXMLResources;
import org.eclipse.epf.importing.xml.preferences.ImportXMLPreferences;
import org.eclipse.epf.library.ui.wizards.BaseWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectXMLFilePage
extends BaseWizardPage {
    public static final String PAGE_NAME;
    private Text pathText;
    private String path;
    private boolean mergeOption = true;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.importing.xml.wizards.SelectXMLFilePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PAGE_NAME = clazz.getName();
    }

    public SelectXMLFilePage() {
        super(PAGE_NAME);
        this.setTitle(ImportXMLResources.selectXMLFilePage_title);
        this.setDescription(ImportXMLResources.selectXMLFilePage_desc);
        this.setImageDescriptor(ImportXMLPlugin.getDefault().getImageDescriptor("full/wizban/ImportXML.gif"));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        Label fileLabel = new Label(composite, 0);
        fileLabel.setText(ImportXMLResources.fileLabel_text);
        this.pathText = new Text(composite, 2048);
        this.pathText.setLayoutData((Object)new GridData(768));
        this.pathText.setText(ImportXMLPreferences.getXMLFile());
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SelectXMLFilePage.this.isValidPath(SelectXMLFilePage.this.pathText.getText().trim())) {
                    SelectXMLFilePage.this.setPageComplete(true);
                    SelectXMLFilePage.this.setErrorMessage(null);
                } else {
                    SelectXMLFilePage.this.setPageComplete(false);
                    SelectXMLFilePage.this.setErrorMessage(ImportXMLResources.invalidXMLFile_error);
                }
            }
        });
        Button browseButton = new Button(composite, 8);
        browseButton.setLayoutData((Object)new GridData(3));
        browseButton.setText(ImportXMLResources.browseButton_text);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                fd.setFilterExtensions(new String[]{"*.xml", "*.*"});
                String path = fd.open();
                boolean ok = false;
                if (path != null) {
                    SelectXMLFilePage.this.pathText.setText(path);
                    ok = SelectXMLFilePage.this.isValidPath(path);
                }
                SelectXMLFilePage.this.setPageComplete(ok);
            }
        });
        Group optionGroup = new Group(composite, 0);
        optionGroup.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        optionGroup.setLayoutData((Object)gridData);
        optionGroup.setText(ImportXMLResources.optionGroup_text);
        this.mergeOption = ImportXMLPreferences.getMergeOption();
        Button overwriteRadioButton = this.createRadioButton((Composite)optionGroup, ImportXMLResources.overwriteRadioButton_text, 1, !this.mergeOption);
        overwriteRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectXMLFilePage.this.mergeOption = false;
            }
        });
        Button mergeRadioButton = this.createRadioButton((Composite)optionGroup, ImportXMLResources.mergeRadioButton_text, 1, this.mergeOption);
        mergeRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectXMLFilePage.this.mergeOption = true;
            }
        });
        this.setControl((Control)composite);
        this.setPageComplete(this.isValidPath(this.pathText.getText().trim()));
    }

    private boolean isValidPath(String path) {
        File file = new File(path);
        if (file.exists() && file.isFile()) {
            this.path = path;
            return true;
        }
        return false;
    }

    public String getPath() {
        return this.path;
    }

    public boolean getMergeOption() {
        return this.mergeOption;
    }
}

