/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.diagram;

import java.awt.Rectangle;
import java.io.File;
import org.eclipse.epf.library.layout.diagram.HTMLArea;
import org.eclipse.epf.library.layout.diagram.HTMLMap;
import org.eclipse.epf.library.layout.diagram.MethodElementDiagram;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.VariabilityElement;

public class DiagramInfo
extends MethodElementDiagram {
    private int suppressedCount = 0;

    public DiagramInfo(String diagramType, MethodElement element) {
        super(element);
        super.setHTMLMap(new HTMLMap(String.valueOf(diagramType) + "_" + element.getName()));
    }

    public void addArea(MethodElement e, int x, int y, int width, int height, String altTag, boolean suppressed) {
        if (suppressed) {
            ++this.suppressedCount;
            return;
        }
        if (altTag == null) {
            if (e instanceof DescribableElement) {
                altTag = ((DescribableElement)e).getPresentationName();
                if ((altTag.length() < 1 || altTag == "") && e instanceof Activity) {
                    VariabilityElement base = ((Activity)e).getVariabilityBasedOnElement();
                    altTag = ((Activity)base).getPresentationName();
                }
            } else {
                altTag = e != null ? e.getName() : "";
            }
        }
        Rectangle coordinates = new Rectangle(x, y, width, height);
        String href = ResourceHelper.getUrl(e, super.getMethodElement(), ".html");
        HTMLMap map = super.getHTMLMap();
        map.addArea(new HTMLArea(e.getGuid(), href, "rect", coordinates, altTag));
    }

    public void setImageFilePath(String path) {
        super.setImageFileName(String.valueOf(ResourceHelper.getBackPath(super.getMethodElement())) + path.replace(File.separatorChar, '/'));
    }

    public int getAreaCount() {
        return super.getHTMLMap().size();
    }

    public int getSuppressedCount() {
        return this.suppressedCount;
    }

    public boolean isEmpty() {
        return this.getAreaCount() + this.getSuppressedCount() == 0;
    }
}

