/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.diagram;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import org.eclipse.epf.common.utils.I18nUtil;
import org.eclipse.epf.common.utils.ImageUtil;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.diagram.HTMLArea;
import org.eclipse.epf.library.layout.diagram.HTMLMap;
import org.eclipse.epf.library.layout.diagram.MethodElementDiagram;
import org.eclipse.epf.library.layout.elements.RoleLayout;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.swt.SWT;

public class RoleDiagramPublisher {
    private static final String DEFAULT_FONT_NAME = "Arial";
    private static final int DEFAULT_FONT_SIZE = 10;
    private static final int DEFAULT_X_MARGIN = 200;
    private static final int DEFAULT_X_SPACING = 70;
    private static final int DEFAULT_Y_SPACING = 30;
    private int maxImageWidth = 1024;
    private int maxImageHeight = 1024;
    private int borderWidth = 10;
    private int borderHeight = 10;
    private int xMargin = 240;
    private int xSpacing = 45;
    private int ySpacing = 40;
    private int linePadding = 12;
    private Font textFont = null;

    public RoleDiagramPublisher() {
        int fontSize;
        String fontName;
        if (SWT.getPlatform().equals("win32")) {
            fontName = LibraryResources.roleDiagramFont_name_win32;
            fontSize = I18nUtil.getInt((String)LibraryResources.roleDiagramFont_size_win32, (int)10);
        } else {
            fontName = LibraryResources.roleDiagramFont_name;
            fontSize = I18nUtil.getInt((String)LibraryResources.roleDiagramFont_size, (int)10);
        }
        if (fontName.startsWith("[")) {
            fontName = DEFAULT_FONT_NAME;
        }
        this.textFont = new Font(fontName, 0, fontSize);
        this.xMargin = I18nUtil.getInt((String)LibraryResources.roleDiagram_xMargin, (int)200);
        this.xSpacing = I18nUtil.getInt((String)LibraryResources.roleDiagram_xSpacing, (int)70);
        this.ySpacing = I18nUtil.getInt((String)LibraryResources.roleDiagram_ySpacing, (int)30);
    }

    public MethodElementDiagram publish(RoleLayout roleLayout, File path) {
        Role role = (Role)roleLayout.getElement();
        if (role == null) {
            throw new IllegalArgumentException();
        }
        try {
            Point roleStartPoint;
            List workProducts;
            MethodElementDiagram elementDiagram = new MethodElementDiagram((MethodElement)role);
            String publishDir = roleLayout.getLayoutMgr().getPublishDir();
            String mapName = roleLayout.getDisplayName();
            mapName = mapName == null || mapName.length() == 0 ? "Unknown" : mapName.replace(' ', '_');
            HTMLMap htmlMap = new HTMLMap(mapName);
            elementDiagram.setHTMLMap(htmlMap);
            JPanel panel = new JPanel();
            BufferedImage outputImage = new BufferedImage(this.maxImageWidth, this.maxImageHeight, 1);
            Graphics2D g2d = (Graphics2D)outputImage.getGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.fillRect(0, 0, this.maxImageWidth, this.maxImageHeight);
            g2d.setStroke(new BasicStroke(1.25f));
            g2d.setColor(Color.BLACK);
            int xOffset = this.xSpacing / 2;
            List tasks = roleLayout.getPerforms();
            int totalTasks = tasks != null ? tasks.size() : 0;
            Point taskStartPoint = new Point(this.borderWidth + this.xMargin, this.borderHeight);
            Point taskEndPoint = new Point(this.borderWidth + this.xMargin, this.borderHeight);
            int x = taskStartPoint.x;
            int y = taskStartPoint.y;
            int tasksEndX = 0;
            if (totalTasks > 0) {
                int taskNo = 1;
                Iterator i = tasks.iterator();
                while (i.hasNext()) {
                    Task task = (Task)i.next();
                    IElementLayout taskLayout = roleLayout.getLayoutMgr().getLayout((MethodElement)task, true);
                    String taskName = taskLayout.getDisplayName();
                    String imageFile = String.valueOf(publishDir) + taskLayout.getDiagramiconUrl();
                    try {
                        BufferedImage taskImage = ImageUtil.getBufferedImage((String)imageFile, (Component)panel);
                        int taskWidth = taskImage.getWidth();
                        int taskHeight = taskImage.getHeight();
                        if (taskNo == 1) {
                            taskEndPoint.x += taskWidth;
                            taskEndPoint.y += taskHeight;
                            tasksEndX = taskEndPoint.x;
                        }
                        Rectangle taskImageRect = new Rectangle(x, y, taskWidth, taskHeight);
                        TexturePaint taskPaint = new TexturePaint(taskImage, taskImageRect);
                        g2d.setPaint(taskPaint);
                        g2d.fill(taskImageRect);
                        if (taskName != null) {
                            ImageUtil.drawText((Graphics2D)g2d, (String)taskName, (Font)this.textFont, (Color)Color.BLACK, (int)(x - xOffset), (int)taskEndPoint.y, (float)(taskWidth + this.xSpacing));
                        }
                        String href = String.valueOf(taskLayout.getFilePath(roleLayout)) + taskLayout.getFileName(".html");
                        HTMLArea htmlArea = new HTMLArea(task.getGuid(), href, "rect", taskImageRect, taskName);
                        htmlMap.addArea(htmlArea);
                        if (x + taskWidth > tasksEndX) {
                            tasksEndX = x + taskWidth;
                        }
                        if (i.hasNext()) {
                            int xIncrement = taskWidth + this.xSpacing;
                            taskEndPoint.x += xIncrement;
                            if ((x += xIncrement) + xIncrement + xOffset + this.borderWidth > this.maxImageWidth) {
                                x = taskStartPoint.x;
                                int yIncrement = taskHeight + this.ySpacing;
                                y += yIncrement;
                                taskEndPoint.y += yIncrement;
                                taskEndPoint.x = taskStartPoint.x + taskWidth;
                            }
                        }
                    }
                    catch (Exception e) {
                        LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
                    }
                    ++taskNo;
                }
            }
            int totalWorkProducts = (workProducts = roleLayout.getResponsibleFor()) != null ? workProducts.size() : 0;
            Point workProductStartPoint = new Point(taskStartPoint.x, this.borderHeight);
            Point workProductEndPoint = new Point(taskStartPoint.x, this.borderHeight);
            if (totalTasks > 0 && totalWorkProducts > 0) {
                workProductEndPoint.y = workProductStartPoint.y = taskEndPoint.y + this.ySpacing + this.ySpacing / 2;
            } else if (totalTasks > 0) {
                workProductEndPoint.y = taskEndPoint.y + this.borderHeight;
            }
            x = workProductStartPoint.x;
            y = workProductStartPoint.y;
            int workProductsEndX = 0;
            if (totalWorkProducts > 0) {
                int workProductNo = 1;
                Iterator i = workProducts.iterator();
                while (i.hasNext()) {
                    WorkProduct workProduct = (WorkProduct)i.next();
                    IElementLayout wpLayout = roleLayout.getLayoutMgr().getLayout((MethodElement)workProduct, true);
                    String workProductName = wpLayout.getDisplayName();
                    String imageFile = String.valueOf(publishDir) + wpLayout.getDiagramiconUrl();
                    try {
                        BufferedImage workProductImage = ImageUtil.getBufferedImage((String)imageFile, (Component)panel);
                        int workProductWidth = workProductImage.getWidth();
                        int workProductHeight = workProductImage.getHeight();
                        if (workProductNo == 1) {
                            workProductEndPoint.x += workProductWidth;
                            workProductEndPoint.y += workProductHeight;
                            workProductsEndX = workProductEndPoint.x;
                        }
                        Rectangle workProductImageRect = new Rectangle(x, y, workProductWidth, workProductHeight);
                        TexturePaint workProductPaint = new TexturePaint(workProductImage, workProductImageRect);
                        g2d.setPaint(workProductPaint);
                        g2d.fill(workProductImageRect);
                        if (workProductName != null) {
                            ImageUtil.drawText((Graphics2D)g2d, (String)workProductName, (Font)this.textFont, (Color)Color.BLACK, (int)(x - xOffset), (int)workProductEndPoint.y, (float)(workProductWidth + this.xSpacing));
                        }
                        String href = String.valueOf(wpLayout.getFilePath(roleLayout)) + wpLayout.getFileName(".html");
                        HTMLArea htmlArea = new HTMLArea(workProduct.getGuid(), href, "rect", workProductImageRect, workProductName);
                        htmlMap.addArea(htmlArea);
                        if (x + workProductWidth > workProductsEndX) {
                            workProductsEndX = x + workProductWidth;
                        }
                        if (i.hasNext()) {
                            int xIncrement = workProductWidth + this.xSpacing;
                            workProductEndPoint.x += xIncrement;
                            if ((x += xIncrement) + xIncrement + xOffset + this.borderWidth > this.maxImageWidth) {
                                x = workProductStartPoint.x;
                                int yIncrement = workProductHeight + this.ySpacing;
                                y += yIncrement;
                                workProductEndPoint.y += yIncrement;
                                workProductEndPoint.x = workProductStartPoint.x + workProductWidth;
                            }
                        }
                    }
                    catch (Exception e) {
                        LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
                    }
                    ++workProductNo;
                }
            }
            Point roleEndPoint = roleStartPoint = new Point(xOffset - 5, this.borderHeight);
            try {
                Point startPoint;
                String roleName = roleLayout.getDisplayName();
                String imageFile = String.valueOf(publishDir) + roleLayout.getDiagramiconUrl();
                BufferedImage roleImage = ImageUtil.getBufferedImage((String)imageFile, (Component)panel);
                int roleWidth = roleImage.getWidth();
                int roleHeight = roleImage.getHeight();
                x = xOffset - 5;
                y = this.borderHeight;
                roleEndPoint.x += roleWidth;
                roleEndPoint.y += roleHeight;
                if (totalWorkProducts > 0) {
                    y = this.borderHeight + (workProductEndPoint.y - taskStartPoint.y - roleHeight) / 2;
                    startPoint = new Point(x + roleWidth + this.linePadding / 2, y + roleHeight / 2);
                    Point endPoint = new Point(workProductStartPoint.x - this.linePadding, workProductStartPoint.y + (workProductEndPoint.y - workProductStartPoint.y) / 2);
                    this.renderAssociation(g2d, startPoint, endPoint, LibraryResources.roleDiagramResponsibleFor_text, this.textFont, Color.BLACK);
                } else if (totalTasks > 0) {
                    y = this.borderHeight + (taskEndPoint.y - taskStartPoint.y - roleHeight) / 2;
                }
                roleStartPoint.y = y;
                roleEndPoint.y = y + roleHeight;
                if (totalTasks > 0) {
                    startPoint = new Point(x + roleWidth + this.linePadding / 2, y + roleHeight / 2);
                    Point endPoint = new Point(taskStartPoint.x - this.linePadding, this.borderHeight + (taskEndPoint.y - taskStartPoint.y) / 2);
                    this.renderAssociation(g2d, startPoint, endPoint, LibraryResources.roleDiagramPerforms_text, this.textFont, Color.BLACK);
                }
                Rectangle roleImageRect = new Rectangle(x, y, roleWidth, roleHeight);
                TexturePaint rolePaint = new TexturePaint(roleImage, roleImageRect);
                g2d.setPaint(rolePaint);
                g2d.fill(roleImageRect);
                if (roleName != null) {
                    ImageUtil.drawText((Graphics2D)g2d, (String)roleName, (Font)this.textFont, (Color)Color.BLACK, (int)(x - xOffset), (int)(y + roleHeight), (float)(roleWidth + this.xSpacing));
                }
            }
            catch (Exception e) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            }
            int optimalWidth = Math.max(tasksEndX, workProductsEndX) + this.borderWidth;
            optimalWidth = Math.max(optimalWidth, roleEndPoint.x + this.borderWidth);
            optimalWidth = Math.min(optimalWidth, this.maxImageWidth);
            int optimalHeight = workProductEndPoint.y + this.borderHeight;
            optimalHeight = Math.max(optimalHeight, roleEndPoint.y + this.borderHeight);
            optimalHeight += 20;
            optimalHeight = Math.min(optimalHeight, this.maxImageHeight);
            BufferedImage optimalImage = outputImage.getSubimage(0, 0, optimalWidth += xOffset, optimalHeight);
            File jpgFile = new File(path, String.valueOf(roleLayout.getFilePath()) + roleLayout.getFileName(".jpg"));
            File parentFolder = jpgFile.getParentFile();
            if (!parentFolder.exists()) {
                parentFolder.mkdirs();
            }
            ImageIO.write((RenderedImage)optimalImage, "jpg", jpgFile);
            elementDiagram.setImageFileName(jpgFile.getName());
            return elementDiagram;
        }
        catch (Exception e) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            return null;
        }
    }

    protected void renderAssociation(Graphics2D g2d, Point startPoint, Point endPoint, String name, Font font, Color color) {
        g2d.draw(new Line2D.Double(startPoint.x, startPoint.y, endPoint.x, endPoint.y));
        int textX = startPoint.x + (endPoint.x - startPoint.x) / 2 - 40;
        int textY = startPoint.y + (endPoint.y - startPoint.y) / 2 - 5;
        if (startPoint.y != endPoint.y) {
            g2d.setColor(Color.WHITE);
            g2d.fillRect(textX, textY, 80, 10);
        } else {
            textY -= 10;
        }
        ImageUtil.drawText((Graphics2D)g2d, (String)name, (Font)font, (Color)color, (int)textX, (int)textY, (float)80.0f);
    }
}

