/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.uma.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.Diagram;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.DisciplineGrouping;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.MethodUnit;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.RoleSetGrouping;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.WorkOrderType;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductType;
import org.eclipse.epf.uma.util.AssociationHelper;

public class UmaUtil {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;

    public static void replace(MethodElement oldElement, MethodElement newElement) {
        EList features = oldElement.eClass().getEAllStructuralFeatures();
        if (features != null) {
            int size = features.size();
            int i = 0;
            while (i < size) {
                EStructuralFeature feature = (EStructuralFeature)features.get(i);
                if (feature != UmaPackage.eINSTANCE.getMethodElement_Guid()) {
                    Object newValue = newElement.eGet(feature);
                    oldElement.eSet(feature, newValue);
                }
                ++i;
            }
        }
    }

    public static boolean hasDirectResource(EObject e) {
        Resource resource = e.eResource();
        return resource != null && resource.getContents().contains((Object)e);
    }

    public static Object getAdapter(EObject eObj, Class cls) {
        Iterator adapters = eObj.eAdapters().iterator();
        while (adapters.hasNext()) {
            Adapter adapter = (Adapter)adapters.next();
            if (!cls.isInstance(adapter)) continue;
            return adapter;
        }
        return null;
    }

    public static MethodPackage findMethodPackage(List methodPackages, String name) {
        int i = methodPackages.size() - 1;
        while (i > -1) {
            MethodPackage pkg;
            Object obj = methodPackages.get(i);
            if (obj instanceof MethodPackage && name.equals((pkg = (MethodPackage)obj).getName())) {
                return pkg;
            }
            --i;
        }
        return null;
    }

    public static MethodPackage findMethodPackage(MethodPlugin methodPlugin, String[] path) {
        MethodPackage pkg = null;
        List list = methodPlugin.getMethodPackages();
        int i = 0;
        while (i < path.length) {
            pkg = UmaUtil.findMethodPackage(list, path[i]);
            if (pkg == null) {
                return null;
            }
            list = pkg.getChildPackages();
            ++i;
        }
        return pkg;
    }

    public static Activity getParentActivity(BreakdownElement e) {
        return e.getSuperActivities();
    }

    public static Activity getOwningActivity(WorkOrder workOrder) {
        ProcessPackage pkg = (ProcessPackage)workOrder.eContainer();
        Iterator iter = pkg.getProcessElements().iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof Activity)) continue;
            return (Activity)element;
        }
        return null;
    }

    public static WorkBreakdownElement getOwner(WorkOrder workOrder) {
        return AssociationHelper.getSuccessor(workOrder);
    }

    public static ContentPackage findContentPackage(List methodPackages, String name) {
        int i = methodPackages.size() - 1;
        while (i > -1) {
            ContentPackage pkg;
            Object obj = methodPackages.get(i);
            if (obj instanceof ContentPackage && name.equals((pkg = (ContentPackage)obj).getName())) {
                return pkg;
            }
            --i;
        }
        return null;
    }

    public static ContentPackage findContentPackage(MethodPlugin methodPlugin, String[] path) {
        ContentPackage pkg = null;
        List list = methodPlugin.getMethodPackages();
        int i = 0;
        while (i < path.length) {
            pkg = UmaUtil.findContentPackage(list, path[i]);
            if (pkg == null) {
                return null;
            }
            list = pkg.getChildPackages();
            ++i;
        }
        return pkg;
    }

    public static MethodPlugin getMethodPlugin(EObject element) {
        EObject obj = element;
        while (obj != null) {
            if (obj instanceof MethodPlugin) {
                return (MethodPlugin)obj;
            }
            obj = obj.eContainer();
        }
        return null;
    }

    public static MethodLibrary getMethodLibrary(EObject element) {
        EObject obj = element;
        while (obj != null) {
            if (obj instanceof MethodLibrary) {
                return (MethodLibrary)obj;
            }
            obj = obj.eContainer();
        }
        return null;
    }

    public static EObject getTopContainer(EObject element) {
        EObject container = null;
        EObject obj = element.eContainer();
        while (obj != null) {
            container = obj;
            obj = obj.eContainer();
        }
        return container;
    }

    public static ContentPackage getContentPackage(EObject element) {
        EObject obj = element;
        while (obj != null) {
            if (obj instanceof ContentPackage) {
                return (ContentPackage)obj;
            }
            obj = obj.eContainer();
        }
        return null;
    }

    public static ProcessPackage getProcessPackage(EObject element) {
        EObject obj = element;
        while (obj != null) {
            if (obj instanceof ProcessPackage) {
                return (ProcessPackage)obj;
            }
            obj = obj.eContainer();
        }
        return null;
    }

    public static Diagram getDiagram(EObject element) {
        EObject obj = element;
        while (obj != null) {
            if (obj instanceof Diagram) {
                return (Diagram)obj;
            }
            obj = obj.eContainer();
        }
        return null;
    }

    public static boolean isContainedByContentPackage(EObject element, ContentPackage contentPackage) {
        return UmaUtil.isContainedBy(element, contentPackage);
    }

    public static boolean isContainedBy(EObject eObj, Object container) {
        if (eObj == null) {
            return false;
        }
        EObject obj = eObj.eContainer();
        while (obj != null) {
            if (obj == container) {
                return true;
            }
            obj = obj.eContainer();
        }
        return false;
    }

    public static String generateGUID() {
        return EcoreUtil.generateUUID();
    }

    public static String createContentDescriptionName(MethodElement e) {
        return String.valueOf(e.getName()) + ',' + e.getGuid();
    }

    public static void getAllSupers(List supers, VariabilityElement e, VariabilityType type) {
        VariabilityElement base = e.getVariabilityBasedOnElement();
        if (base != null && e.getVariabilityType() == type && !supers.contains(base)) {
            supers.add(base);
            UmaUtil.getAllSupers(supers, base, type);
        }
    }

    public static void getAllSupersBoth(List supers, VariabilityElement e, VariabilityType type1, VariabilityType type2) {
        VariabilityElement base = e.getVariabilityBasedOnElement();
        if (!(base == null || e.getVariabilityType() != type1 && e.getVariabilityType() != type2 || supers.contains(base))) {
            supers.add(base);
            UmaUtil.getAllSupersBoth(supers, base, type1, type2);
        }
    }

    public static Class getClassOfContentElement(ContentElement contentElement) {
        if (contentElement instanceof Role) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.epf.uma.Role");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (contentElement instanceof Task) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.epf.uma.Task");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (contentElement instanceof WorkProduct) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.epf.uma.WorkProduct");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (contentElement instanceof Guidance) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.epf.uma.Guidance");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (contentElement instanceof Domain) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.epf.uma.Domain");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (contentElement instanceof Discipline) {
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("org.eclipse.epf.uma.Discipline");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (contentElement instanceof DisciplineGrouping) {
            Class<?> clazz = class$6;
            if (clazz == null) {
                try {
                    clazz = class$6 = Class.forName("org.eclipse.epf.uma.DisciplineGrouping");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (contentElement instanceof RoleSet) {
            Class<?> clazz = class$7;
            if (clazz == null) {
                try {
                    clazz = class$7 = Class.forName("org.eclipse.epf.uma.RoleSet");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (contentElement instanceof RoleSetGrouping) {
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("org.eclipse.epf.uma.RoleSetGrouping");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (contentElement instanceof WorkProductType) {
            Class<?> clazz = class$9;
            if (clazz == null) {
                try {
                    clazz = class$9 = Class.forName("org.eclipse.epf.uma.WorkProductType");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        Class<?> clazz = class$10;
        if (clazz == null) {
            try {
                clazz = class$10 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public static WorkOrder createDefaultWorkOrder(WorkBreakdownElement succ, WorkBreakdownElement pred) {
        WorkOrder wo = UmaFactory.eINSTANCE.createWorkOrder();
        wo.setPred(pred);
        wo.setLinkType(WorkOrderType.FINISH_TO_FINISH_LITERAL);
        succ.getLinkToPredecessor().add(wo);
        return wo;
    }

    public static WorkOrder findWorkOrder(WorkBreakdownElement e, Object predecessor) {
        Iterator iter = e.getLinkToPredecessor().iterator();
        while (iter.hasNext()) {
            WorkOrder workOrder = (WorkOrder)iter.next();
            if (workOrder.getPred() != predecessor) continue;
            return workOrder;
        }
        return null;
    }

    public static WorkOrder removeWorkOrder(WorkBreakdownElement e, Object predecessor) {
        Iterator iterator = e.getLinkToPredecessor().iterator();
        while (iterator.hasNext()) {
            WorkOrder order = (WorkOrder)iterator.next();
            if (order.getPred() != predecessor) continue;
            iterator.remove();
            return order;
        }
        return null;
    }

    public static ProcessComponent getProcessComponent(MethodElement e) {
        MethodElement container = e;
        while (container != null && !(container instanceof ProcessComponent)) {
            container = container.eContainer();
        }
        if (container != null) {
            return (ProcessComponent)container;
        }
        return null;
    }

    public static MethodUnit getMethodUnit(MethodElement e) {
        MethodElement container = e;
        while (container != null && !(container instanceof MethodUnit)) {
            container = container.eContainer();
        }
        if (container != null) {
            return (MethodUnit)container;
        }
        return null;
    }

    public static boolean hasReference(MethodPlugin plugin, MethodPlugin base) {
        EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)plugin.eCrossReferences().iterator();
        while (featureIterator.hasNext()) {
            EObject ref = (EObject)featureIterator.next();
            EStructuralFeature f = featureIterator.feature();
            if (f == UmaPackage.eINSTANCE.getMethodPlugin_Bases() || UmaUtil.getMethodPlugin(ref) != base) continue;
            return true;
        }
        TreeIterator iter = plugin.eAllContents();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            if (element instanceof ProcessElement) continue;
            Iterator iterator = element.eCrossReferences().iterator();
            while (iterator.hasNext()) {
                EObject ref = (EObject)iterator.next();
                if (UmaUtil.getMethodPlugin(ref) != base) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean removeReferences(MethodPlugin plugin, MethodPlugin base) {
        TreeIterator iter = plugin.eAllContents();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            if (element instanceof ProcessElement) continue;
            EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)element.eCrossReferences().iterator();
            while (featureIterator.hasNext()) {
                EObject ref = (EObject)featureIterator.next();
                if (UmaUtil.getMethodPlugin(ref) != base) continue;
                EStructuralFeature f = featureIterator.feature();
                if (f.isMany()) {
                    ((Collection)element.eGet(f)).remove(ref);
                    continue;
                }
                element.eSet(f, null);
            }
        }
        return false;
    }

    public static String getMessage(IStatus status) {
        String msg = status.getMessage();
        if (status.isMultiStatus()) {
            StringBuffer strBuf = new StringBuffer(msg);
            IStatus[] statuses = status.getChildren();
            int i = 0;
            while (i < statuses.length) {
                strBuf.append('\n').append(statuses[i].getMessage());
                ++i;
            }
            msg = strBuf.toString();
        }
        if (msg != null && msg.trim().length() == 0) {
            msg = null;
        }
        return msg;
    }

    public static final String generateGUID(String baseGUID) {
        return GUID.generate(baseGUID);
    }

    private static class GUID {
        private static MessageDigest md5 = null;
        private static final char[] BASE64_DIGITS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
        static /* synthetic */ Class class$0;

        private GUID() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static MessageDigest getMD5() {
            if (md5 != null) return md5;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.epf.uma.util.UmaUtil$GUID");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            synchronized (clazz) {
                if (md5 != null) return md5;
                try {
                    md5 = MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
                return md5;
            }
        }

        public static final String generate(String baseGUID) {
            MessageDigest md5 = GUID.getMD5();
            md5.update(baseGUID.getBytes());
            byte[] hash = md5.digest();
            char[] buffer = new char[23];
            buffer[0] = 45;
            int i = 0;
            while (i < 5) {
                buffer[4 * i + 1] = BASE64_DIGITS[hash[i * 3] >> 2 & 0x3F];
                buffer[4 * i + 2] = BASE64_DIGITS[hash[i * 3] << 4 & 0x30 | hash[i * 3 + 1] >> 4 & 0xF];
                buffer[4 * i + 3] = BASE64_DIGITS[hash[i * 3 + 1] << 2 & 0x3C | hash[i * 3 + 2] >> 6 & 3];
                buffer[4 * i + 4] = BASE64_DIGITS[hash[i * 3 + 2] & 0x3F];
                ++i;
            }
            buffer[21] = BASE64_DIGITS[hash[15] >> 2 & 0x3F];
            buffer[22] = BASE64_DIGITS[hash[15] << 4 & 0x30];
            return new String(buffer);
        }
    }
}

