/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.xml.XSLTProcessor;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationFilter;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.configuration.GuidanceGroupingItemProvider;
import org.eclipse.epf.library.edit.configuration.GuidanceItemProvider;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.publishing.services.GlossaryList;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.TermDefinition;

public class GlossaryBuilder {
    public static final String GLOSSARY_BACKPATH = "./../";
    private AdapterFactory adapterFactory;
    private static final Class ITreeItemContentProviderClass;
    private static final String GLOSSARY_HTML_FILE = "process/glossary.htm";
    private static final String GLOSSARY_INDEX_HTML_FILE = "process/glossary/index.htm";
    private static final String GLOSSARY_NAVIG_HTML_FILE = "process/glossary/navig.htm";
    private static final String GLOSSARY_XSL_FILE = "xsl/glossary.xsl";
    private static final String GLOSSARY_INDEX_XSL_FILE = "xsl/glossary_index.xsl";
    private static final String GLOSSARY_NAVIG_XSL_FILE = "xsl/glossary_navig.xsl";
    private GlossaryList glossaryItems = new GlossaryList();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeItemContentProviderClass = clazz;
    }

    public void execute(MethodConfiguration config, String pubDir, String title, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        this.glossaryItems.clear();
        ConfigurationFilter configFilter = new ConfigurationFilter(config, null);
        this.adapterFactory = TngAdapterFactory.INSTANCE.getConfigurationView_AdapterFactory((IFilter)configFilter);
        this.iterate(config, monitor);
        this.createGlossary(pubDir, title);
    }

    private void iterate(Object obj, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        ITreeItemContentProvider treeItemContentProvider = (ITreeItemContentProvider)this.adapterFactory.adapt(obj, (Object)ITreeItemContentProviderClass);
        if (treeItemContentProvider != null) {
            Collection items = treeItemContentProvider.getChildren(obj);
            Iterator it = items.iterator();
            while (it.hasNext()) {
                if (monitor.isCanceled()) {
                    return;
                }
                Object itorObj = LibraryUtil.unwrap(it.next());
                if (itorObj instanceof GuidanceGroupingItemProvider) {
                    this.iterate(itorObj, monitor);
                    continue;
                }
                if (itorObj instanceof GuidanceItemProvider) {
                    this.iterate(itorObj, monitor);
                    continue;
                }
                if (!(itorObj instanceof TermDefinition)) continue;
                this.glossaryItems.add((TermDefinition)itorObj);
            }
        }
    }

    private void createGlossary(String pubDir, String title) {
        try {
            URL url = new URL(PublishingPlugin.getDefault().getInstallURL(), GLOSSARY_XSL_FILE);
            if (url == null) {
                System.out.println("Unable to get glossary xsl template xsl/glossary.xsl");
                return;
            }
            String xsl_uri = Platform.resolve((URL)url).getPath();
            StringBuffer xml = this.glossaryItems.getXml();
            File f = new File(pubDir, GLOSSARY_HTML_FILE);
            File parent = f.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            Properties xslParams = PublishingPlugin.getDefault().getProperties("/xsl/resources.properties");
            xslParams.setProperty("title", title);
            StringWriter sw = new StringWriter();
            XSLTProcessor.transform((String)xsl_uri, (String)xml.toString(), (Properties)xslParams, (Writer)sw);
            sw.flush();
            String content = ResourceHelper.decodeUrlsInContent((String)sw.getBuffer().toString());
            FileUtil.writeUTF8File((String)f.getAbsolutePath(), (String)this.fixContent(content));
            sw.close();
            url = new URL(PublishingPlugin.getDefault().getInstallURL(), GLOSSARY_INDEX_XSL_FILE);
            if (url == null) {
                System.out.println("Unable to get glossary xsl template xsl/glossary_index.xsl");
                return;
            }
            xsl_uri = Platform.resolve((URL)url).getPath();
            f = new File(pubDir, GLOSSARY_INDEX_HTML_FILE);
            sw = new StringWriter();
            XSLTProcessor.transform((String)xsl_uri, (String)xml.toString(), (Properties)xslParams, (Writer)sw);
            sw.flush();
            FileUtil.writeUTF8File((String)f.getAbsolutePath(), (String)sw.toString());
            sw.close();
            url = new URL(PublishingPlugin.getDefault().getInstallURL(), GLOSSARY_NAVIG_XSL_FILE);
            if (url == null) {
                System.out.println("Unable to get glossary xsl template xsl/glossary_navig.xsl");
                return;
            }
            xsl_uri = Platform.resolve((URL)url).getPath();
            f = new File(pubDir, GLOSSARY_NAVIG_HTML_FILE);
            sw = new StringWriter();
            XSLTProcessor.transform((String)xsl_uri, (String)xml.toString(), (Properties)xslParams, (Writer)sw);
            sw.flush();
            FileUtil.writeUTF8File((String)f.getAbsolutePath(), (String)sw.toString());
            sw.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String fixContent(String source) {
        StringBuffer sb = new StringBuffer();
        Matcher m = ResourceHelper.p_link_ref.matcher(source);
        while (m.find()) {
            String urltext = m.group(1);
            String linkedText = m.group(2);
            urltext = this.fixUrlText(urltext);
            String text = "<a " + urltext + ">" + linkedText + "</a>";
            m.appendReplacement(sb, text);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private String fixUrlText(String urltext) {
        MethodElement e;
        String guid = ResourceHelper.getGuidFromUrl((String)urltext);
        if (guid == null) {
            return urltext;
        }
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        MethodElement methodElement = e = manager != null ? manager.getMethodElement(guid) : null;
        if (e == null) {
            return urltext;
        }
        String href = "";
        href = e instanceof TermDefinition ? "#" + e.getName() : "../" + ResourceHelper.getElementPath((MethodElement)e).replace(File.separatorChar, '/') + ResourceHelper.getFileName((MethodElement)e, (String)".html");
        StringBuffer sb = new StringBuffer();
        Matcher m = ResourceHelper.p_link_href_picker.matcher(" " + urltext + " ");
        if (m.find()) {
            m.appendReplacement(sb, " href=\"" + href + "\" ");
            m.appendTail(sb);
            return sb.toString();
        }
        return urltext;
    }
}

