/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.publishing.ui.PublisherElement;
import org.eclipse.epf.publishing.ui.PublishingUIPlugin;
import org.eclipse.epf.publishing.ui.actions.PublishAction;
import org.eclipse.jface.action.Action;
import org.osgi.framework.Bundle;

public class PublisherFactory {
    public static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.epf.publishing.ui";
    public static final String EXTENSION_POINT_NAME = "publishers";
    private static PublisherFactory instance = null;
    private Map publisherMap = new HashMap();
    static /* synthetic */ Class class$0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PublisherFactory getInstance() {
        if (instance != null) return instance;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.publishing.ui.PublisherFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (instance != null) return instance;
            instance = new PublisherFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private PublisherFactory() {
        this.init();
    }

    protected void init() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EXTENSION_POINT_NAMESPACE, EXTENSION_POINT_NAME);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                String pluginId = extension.getNamespaceIdentifier();
                Bundle bundle = Platform.getBundle((String)pluginId);
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement configElement = configElements[j];
                    try {
                        String id = configElement.getAttribute("id");
                        String name = configElement.getAttribute("label");
                        String icon = configElement.getAttribute("icon");
                        String wizardClassName = configElement.getAttribute("wizardClass");
                        String managerClassName = configElement.getAttribute("managerClass");
                        if (id != null && id.trim().length() > 0 && name != null && name.trim().length() > 0 && wizardClassName != null && wizardClassName.trim().length() > 0 && managerClassName != null && managerClassName.trim().length() > 0 && !this.publisherMap.containsKey(name)) {
                            PublisherElement provider = new PublisherElement(bundle, id, name, icon, wizardClassName, managerClassName);
                            this.publisherMap.put(id, provider);
                        }
                    }
                    catch (Exception e) {
                        PublishingUIPlugin.getDefault().getLogger().logError((Throwable)e);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public PublisherElement getPublisherElement(String id) {
        return (PublisherElement)this.publisherMap.get(id);
    }

    public List getPublisherElements() {
        return new ArrayList(this.publisherMap.values());
    }

    public Action[] createPublishActions() {
        ArrayList<PublishAction> items = new ArrayList<PublishAction>();
        Iterator it = this.getPublisherElements().iterator();
        while (it.hasNext()) {
            PublisherElement e = (PublisherElement)it.next();
            PublishAction action = new PublishAction(e.getId(), e.getLabel(), e.getImageDescriptor());
            items.add(action);
        }
        int size = items.size();
        Action[] actions = new Action[size];
        items.toArray(actions);
        return actions;
    }
}

