/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.actions.MethodElementDeleteAction;
import org.eclipse.epf.authoring.ui.editors.IEditorKeeper;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.FeatureValueWrapperItemProvider;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.IMethodLibraryPersister;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;

public class LibraryViewDeleteAction
extends MethodElementDeleteAction {
    public LibraryViewDeleteAction() {
        this(true);
    }

    public LibraryViewDeleteAction(boolean confirm) {
        this.confirm = confirm;
    }

    protected void didDelete(Collection deletedElements) {
        Iterator iter = deletedElements.iterator();
        while (iter.hasNext()) {
            Object element = TngUtil.unwrap(iter.next());
            if (!(element instanceof MethodElement) || ((MethodElement)element).eContainer() != null) continue;
            IEditorKeeper.REFERENCE.getEditorKeeper().closeEditorsOnDeletion((MethodElement)element);
        }
    }

    private static CustomCategory getRootCustomCategory(Object object) {
        while (object instanceof IWrapperItemProvider) {
            object = ((IWrapperItemProvider)object).getOwner();
        }
        return (object = TngUtil.unwrap((Object)object)) instanceof CustomCategory && TngUtil.isRootCustomCategory((CustomCategory)((CustomCategory)object)) ? (CustomCategory)object : null;
    }

    public boolean updateSelection(IStructuredSelection selection) {
        ArrayList<Object> filteredSelection = new ArrayList<Object>();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object e = iter.next();
            if (e instanceof CustomCategory) {
                filteredSelection.add(e);
                continue;
            }
            Object element = TngUtil.unwrap(e);
            if (element instanceof ItemProviderAdapter || element instanceof MethodElement && TngUtil.isPredefined((MethodElement)((MethodElement)element))) continue;
            if (element instanceof CustomCategory) {
                CustomCategory rootCustomCategory = LibraryViewDeleteAction.getRootCustomCategory(e);
                CustomCategory cc = (CustomCategory)element;
                if (rootCustomCategory == null || UmaUtil.getMethodPlugin((EObject)rootCustomCategory) != UmaUtil.getMethodPlugin((EObject)cc)) continue;
                filteredSelection.add(element);
                continue;
            }
            if (e instanceof IWrapperItemProvider) {
                Object owner;
                IWrapperItemProvider wrapper = (IWrapperItemProvider)e;
                if (TngUtil.isUnderCustomCategoryTree((IWrapperItemProvider)wrapper)) continue;
                if ((wrapper.getFeature() == UmaPackage.Literals.DISCIPLINE_GROUPING__DISCIPLINES || wrapper.getFeature() == UmaPackage.Literals.ROLE_SET_GROUPING__ROLE_SETS) && (owner = wrapper.getOwner()) instanceof EObject && element instanceof EObject && UmaUtil.getMethodPlugin((EObject)((EObject)owner)) == UmaUtil.getMethodPlugin((EObject)((EObject)element))) {
                    filteredSelection.add(element);
                    continue;
                }
            }
            filteredSelection.add(e);
        }
        if (filteredSelection.isEmpty()) {
            return false;
        }
        return super.updateSelection((IStructuredSelection)new StructuredSelection(filteredSelection));
    }

    protected void performDelete() {
        IStatus status;
        Iterator iter;
        HashSet<Object> configsToDelete = new HashSet<Object>();
        HashSet<Resource> modifiedResources = new HashSet<Resource>();
        IMethodLibraryPersister persister = ContentDescriptionFactory.getMethodLibraryPersister();
        if (this.selection != null && this.selection.size() > 0) {
            Iterator iter2 = this.selection.iterator();
            while (iter2.hasNext()) {
                EObject container;
                Object object = TngUtil.unwrap(iter2.next());
                if (object instanceof MethodConfiguration) {
                    configsToDelete.add(object);
                }
                if (!(object instanceof EObject) || persister.hasOwnResourceWithoutReferrer(object) || (container = ((EObject)object).eContainer()) == null || container.eResource() == null) continue;
                modifiedResources.add(container.eResource());
            }
        }
        if (!configsToDelete.isEmpty()) {
            HashSet<String> configGUIDsToDelete = new HashSet<String>();
            Iterator iter3 = configsToDelete.iterator();
            while (iter3.hasNext()) {
                MethodConfiguration config = (MethodConfiguration)iter3.next();
                configGUIDsToDelete.add(config.getGuid());
            }
            MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)LibraryService.getInstance().getCurrentMethodLibrary().eResource().getResourceSet();
            resourceSet.loadOppositeFeatures(Collections.singletonList(AssociationHelper.MethodConfiguration_DependentProcesses), configGUIDsToDelete);
            iter = configsToDelete.iterator();
            while (iter.hasNext()) {
                MethodConfiguration config = (MethodConfiguration)iter.next();
                List references = AssociationHelper.getDependentProcesses((MethodConfiguration)config);
                if (references == null || references.size() <= 0) continue;
                String processName = ((Process)references.get(0)).getName();
                AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(AuthoringUIResources.deleteDialog_title, AuthoringUIResources.deleteConfigError_msg, AuthoringUIResources.bind((String)AuthoringUIResources.deleteConfigError_reason, (Object)processName));
                return;
            }
        }
        if (!(status = UserInteractionHelper.checkModify(modifiedResources, (Shell)MsgBox.getDefaultShell())).isOK()) {
            AuthoringUIPlugin.getDefault().getMsgDialog().display(AuthoringUIResources.deleteDialog_title, status);
            return;
        }
        if (this.confirmDelete()) {
            ArrayList refreshList = new ArrayList();
            iter = this.selection.iterator();
            while (iter.hasNext()) {
                Object deletingObject = TngUtil.unwrap(iter.next());
                if (!(deletingObject instanceof MethodElement) || !(deletingObject instanceof VariabilityElement)) continue;
                Iterator iterator = TngUtil.getGeneralizers((VariabilityElement)((VariabilityElement)deletingObject));
                while (iterator.hasNext()) {
                    Object aReference = iterator.next();
                    refreshList.add(aReference);
                }
            }
            this.command.execute();
            if (refreshList.size() > 0) {
                TreeViewer viewer = (TreeViewer)LibraryView.getView().getViewer();
                Iterator iter4 = refreshList.iterator();
                while (iter4.hasNext()) {
                    viewer.refresh(iter4.next());
                }
            }
        }
    }

    public void notifyPropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void filterCustomCategorySelection(Object e, List filteredSelection) {
        if (e instanceof FeatureValueWrapperItemProvider) {
            filteredSelection.add(e);
        } else {
            Object owner = ((DelegatingWrapperItemProvider)e).getOwner();
            while (owner instanceof DelegatingWrapperItemProvider) {
                if (owner instanceof FeatureValueWrapperItemProvider) {
                    if (filteredSelection.contains(owner)) break;
                    filteredSelection.add(e);
                    break;
                }
                if (filteredSelection.contains(owner)) break;
                if ((owner = ((DelegatingWrapperItemProvider)owner).getOwner()) instanceof FeatureValueWrapperItemProvider || filteredSelection.contains(owner)) continue;
                filteredSelection.add(e);
                break;
            }
        }
    }
}

