/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.editors;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.forms.MethodLibraryDescriptionFormPage;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.persistence.MultiFileIOException;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;

public class MethodLibraryEditor
extends MethodElementEditor {
    public void setPartName() {
        String partName = AuthoringUIResources.MethodLibraryEditor_title;
        if (this.elementObj.getName() != null) {
            partName = String.valueOf(partName) + this.elementObj.getName();
        }
        this.setPartName(partName);
    }

    protected void addPages() {
        try {
            this.addPage((IFormPage)new MethodLibraryDescriptionFormPage(this));
            this.createPreviewPage();
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        this.getSite().getPage().closeAllEditors(false);
        LibraryView.getView().setInputForViewer(null);
        try {
            LibraryService.getInstance().closeCurrentMethodLibrary();
        }
        catch (Exception exception) {}
        super.dispose();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSave(IProgressMonitor monitor) {
        if (monitor == null) return;
        monitor.beginTask(AuthoringUIResources.MethodLibraryEditor_savemodellibrary, -1);
        try {
            try {
                LibraryService.getInstance().saveCurrentMethodLibrary();
                this.firePropertyChange(257);
            }
            catch (Exception ex) {
                Object troubleObj;
                ex.printStackTrace();
                String errMsg = AuthoringUIResources.MethodLibraryEditor_err_save;
                String errDetails = "";
                if (ex.getMessage() != null) {
                    errDetails = ex.getMessage();
                }
                if (ex instanceof MultiFileIOException && (troubleObj = ((MultiFileIOException)ex).getTroubleObject()) instanceof MethodElement) {
                    errDetails = String.valueOf(AuthoringUIResources.MethodLibraryEditor_troubleobject) + MultiFileSaveUtil.getPath((MethodElement)((MethodElement)troubleObj));
                }
                String title = AuthoringUIResources.MethodLibraryEditor_error_dialog_title;
                String problem = AuthoringUIResources.MethodLibraryEditor_save_library_problem_msg;
                MsgDialog dialog = AuthoringUIPlugin.getDefault().getMsgDialog();
                dialog.displayError(title, problem, errMsg, errDetails);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        monitor.done();
    }

    public boolean isDirty() {
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        return manager != null ? manager.isMethodLibraryModified() : false;
    }
}

