/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DragAndDropEffect;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TVHITTESTINFO;
import org.eclipse.swt.internal.win32.TVITEM;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

class TreeDragAndDropEffect
extends DragAndDropEffect {
    Tree tree;
    int dropIndex;
    int scrollIndex;
    long scrollBeginTime;
    int expandIndex;
    long expandBeginTime;
    TreeItem insertItem;
    boolean insertBefore;
    static final int SCROLL_HYSTERESIS = 200;
    static final int EXPAND_HYSTERESIS = 300;

    TreeDragAndDropEffect(Tree tree) {
        this.tree = tree;
    }

    int checkEffect(int effect) {
        if ((effect & 1) != 0) {
            effect = effect & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((effect & 2) != 0) {
            effect &= 0xFFFFFFFB;
        }
        return effect;
    }

    Widget getItem(int x, int y) {
        Rectangle area;
        Point coordinates = new Point(x, y);
        TreeItem item = this.tree.getItem(coordinates = this.tree.toControl(coordinates));
        if (item == null && (area = this.tree.getClientArea()).contains(coordinates)) {
            int x1 = area.x;
            while (x1 < area.x + area.width) {
                Point pt = new Point(x1, coordinates.y);
                item = this.tree.getItem(pt);
                if (item != null) break;
                ++x1;
            }
        }
        return item;
    }

    ImageData getDragSourceImage(int x, int y) {
        TreeItem[] selection = this.tree.getSelection();
        if (selection.length == 0) {
            return null;
        }
        int treeImageList = OS.SendMessage(this.tree.handle, 4360, 0, 0);
        if (treeImageList != 0) {
            int count = Math.min(selection.length, 10);
            Rectangle bounds = selection[0].getBounds(0);
            int i = 1;
            while (i < count) {
                bounds = bounds.union(selection[i].getBounds(0));
                ++i;
            }
            int hDC = OS.GetDC(0);
            int hDC1 = OS.CreateCompatibleDC(hDC);
            int bitmap = OS.CreateCompatibleBitmap(hDC, bounds.width, bounds.height);
            int hOldBitmap = OS.SelectObject(hDC1, bitmap);
            RECT rect = new RECT();
            rect.right = bounds.width;
            rect.bottom = bounds.height;
            int hBrush = OS.GetStockObject(0);
            OS.FillRect(hDC1, rect, hBrush);
            int i2 = 0;
            while (i2 < count) {
                TreeItem selected = selection[i2];
                Rectangle cell = selected.getBounds(0);
                int imageList = OS.SendMessage(this.tree.handle, 4370, 0, selected.handle);
                OS.ImageList_Draw(imageList, 0, hDC1, cell.x - bounds.x, cell.y - bounds.y, 4);
                OS.ImageList_Destroy(imageList);
                ++i2;
            }
            OS.SelectObject(hDC1, hOldBitmap);
            OS.DeleteDC(hDC1);
            OS.ReleaseDC(0, hDC);
            Display display = this.tree.getDisplay();
            Image image = Image.win32_new(display, 0, bitmap);
            ImageData imageData = image.getImageData();
            image.dispose();
            return imageData;
        }
        return null;
    }

    void showDropTargetEffect(int effect, int x, int y) {
        effect = this.checkEffect(effect);
        int handle = this.tree.handle;
        Point coordinates = new Point(x, y);
        coordinates = this.tree.toControl(coordinates);
        TVHITTESTINFO lpht = new TVHITTESTINFO();
        lpht.x = coordinates.x;
        lpht.y = coordinates.y;
        OS.SendMessage(handle, 4369, 0, lpht);
        int hItem = lpht.hItem;
        if ((effect & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollIndex = -1;
        } else if (hItem != -1 && this.scrollIndex == hItem && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                int topItem = OS.SendMessage(handle, 4362, 5, 0);
                int nextItem = OS.SendMessage(handle, 4362, hItem == topItem ? 7 : 6, hItem);
                boolean scroll = true;
                if (hItem == topItem) {
                    scroll = nextItem != 0;
                } else {
                    RECT itemRect = new RECT();
                    itemRect.left = nextItem;
                    if (OS.SendMessage(handle, 4356, 1, itemRect) != 0) {
                        RECT rect = new RECT();
                        OS.GetClientRect(handle, rect);
                        POINT pt = new POINT();
                        pt.x = itemRect.left;
                        pt.y = itemRect.top;
                        if (OS.PtInRect(rect, pt)) {
                            pt.y = itemRect.bottom;
                            if (OS.PtInRect(rect, pt)) {
                                scroll = false;
                            }
                        }
                    }
                }
                if (scroll) {
                    OS.SendMessage(handle, 4372, 0, nextItem);
                    this.tree.redraw();
                }
                this.scrollBeginTime = 0L;
                this.scrollIndex = -1;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 200L;
            this.scrollIndex = hItem;
        }
        if ((effect & 0x10) == 0) {
            this.expandBeginTime = 0L;
            this.expandIndex = -1;
        } else if (hItem != -1 && this.expandIndex == hItem && this.expandBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.expandBeginTime) {
                if (OS.SendMessage(handle, 4362, 4, hItem) != 0) {
                    TVITEM tvItem = new TVITEM();
                    tvItem.hItem = hItem;
                    tvItem.mask = 24;
                    OS.SendMessage(handle, OS.TVM_GETITEM, 0, tvItem);
                    if ((tvItem.state & 0x20) == 0) {
                        OS.SendMessage(handle, 4354, 2, hItem);
                        this.tree.redraw();
                    }
                }
                this.expandBeginTime = 0L;
                this.expandIndex = -1;
            }
        } else {
            this.expandBeginTime = System.currentTimeMillis() + 300L;
            this.expandIndex = hItem;
        }
        if (this.dropIndex != -1 && (this.dropIndex != hItem || (effect & 1) == 0)) {
            TVITEM tvItem = new TVITEM();
            tvItem.hItem = this.dropIndex;
            tvItem.mask = 8;
            tvItem.stateMask = 8;
            tvItem.state = 0;
            OS.SendMessage(handle, OS.TVM_SETITEM, 0, tvItem);
            this.dropIndex = -1;
        }
        if (hItem != -1 && hItem != this.dropIndex && (effect & 1) != 0) {
            TVITEM tvItem = new TVITEM();
            tvItem.hItem = hItem;
            tvItem.mask = 8;
            tvItem.stateMask = 8;
            tvItem.state = 8;
            OS.SendMessage(handle, OS.TVM_SETITEM, 0, tvItem);
            this.dropIndex = hItem;
        }
        if ((effect & 2) != 0 || (effect & 4) != 0) {
            boolean before = (effect & 2) != 0;
            TreeItem item = (TreeItem)this.tree.getDisplay().findWidget(this.tree.handle, hItem);
            if (item != null) {
                if (item != this.insertItem || before != this.insertBefore) {
                    this.tree.setInsertMark(item, before);
                }
                this.insertItem = item;
                this.insertBefore = before;
            } else {
                if (this.insertItem != null) {
                    this.tree.setInsertMark(null, false);
                }
                this.insertItem = null;
            }
        } else {
            if (this.insertItem != null) {
                this.tree.setInsertMark(null, false);
            }
            this.insertItem = null;
        }
    }
}

