/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.dataexchange.internal.importing;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.dataexchange.importing.PluginService;
import org.eclipse.epf.library.edit.process.command.WBSDropCommand;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.Checklist;
import org.eclipse.epf.uma.Concept;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.DisciplineGrouping;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.Example;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.Guideline;
import org.eclipse.epf.uma.Iteration;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.Outcome;
import org.eclipse.epf.uma.Phase;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.Report;
import org.eclipse.epf.uma.ReusableAsset;
import org.eclipse.epf.uma.Roadmap;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.RoleSetGrouping;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.Template;
import org.eclipse.epf.uma.TermDefinition;
import org.eclipse.epf.uma.Tool;
import org.eclipse.epf.uma.ToolMentor;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.Whitepaper;
import org.eclipse.epf.uma.WorkProductType;
import org.eclipse.epf.uma.util.UmaUtil;

public class PluginServiceImpl
implements PluginService {
    MethodPlugin plugin;

    public PluginServiceImpl(MethodPlugin element) {
        this.plugin = element;
    }

    public MethodPlugin getPlugin() {
        return this.plugin;
    }

    public ContentPackage getContentPackageRoot() {
        return UmaUtil.findContentPackage((MethodPlugin)this.plugin, (String[])ModelStructure.DEFAULT.coreContentPath);
    }

    public Discipline createDiscipline() {
        Discipline d = UmaFactory.eINSTANCE.createDiscipline();
        ContentPackage pkg = (ContentPackage)UmaUtil.findMethodPackage((MethodPlugin)this.getPlugin(), (String[])ModelStructure.DEFAULT.disciplineDefinitionPath);
        pkg.getContentElements().add(d);
        return d;
    }

    public DisciplineGrouping createDisciplineGrouping() {
        DisciplineGrouping d = UmaFactory.eINSTANCE.createDisciplineGrouping();
        ContentPackage pkg = (ContentPackage)UmaUtil.findMethodPackage((MethodPlugin)this.getPlugin(), (String[])ModelStructure.DEFAULT.disciplineDefinitionPath);
        pkg.getContentElements().add(d);
        return d;
    }

    public Tool createTool() {
        Tool tool = UmaFactory.eINSTANCE.createTool();
        ContentPackage pkg = UmaUtil.findContentPackage((MethodPlugin)this.getPlugin(), (String[])ModelStructure.DEFAULT.toolPath);
        pkg.getContentElements().add(tool);
        return tool;
    }

    public Domain createDomain() {
        Domain d = UmaFactory.eINSTANCE.createDomain();
        ContentPackage pkg = UmaUtil.findContentPackage((MethodPlugin)this.getPlugin(), (String[])ModelStructure.DEFAULT.domainPath);
        pkg.getContentElements().add(d);
        return d;
    }

    public WorkProductType createWorkProductType() {
        WorkProductType w = UmaFactory.eINSTANCE.createWorkProductType();
        ContentPackage pkg = UmaUtil.findContentPackage((MethodPlugin)this.getPlugin(), (String[])ModelStructure.DEFAULT.workProductTypePath);
        pkg.getContentElements().add(w);
        return w;
    }

    public RoleSet createRoleSet() {
        RoleSet r = UmaFactory.eINSTANCE.createRoleSet();
        ContentPackage pkg = UmaUtil.findContentPackage((MethodPlugin)this.getPlugin(), (String[])ModelStructure.DEFAULT.roleSetPath);
        pkg.getContentElements().add(r);
        return r;
    }

    public RoleSetGrouping createRoleSetGrouping() {
        RoleSetGrouping r = UmaFactory.eINSTANCE.createRoleSetGrouping();
        ContentPackage pkg = UmaUtil.findContentPackage((MethodPlugin)this.getPlugin(), (String[])ModelStructure.DEFAULT.roleSetPath);
        pkg.getContentElements().add(r);
        return r;
    }

    public CustomCategory createCustomCategory(CustomCategory parent) {
        ContentPackage pkg = UmaUtil.findContentPackage((MethodPlugin)this.getPlugin(), (String[])ModelStructure.DEFAULT.customCategoryPath);
        CustomCategory c = UmaFactory.eINSTANCE.createCustomCategory();
        pkg.getContentElements().add(c);
        if (parent != null) {
            parent.getCategorizedElements().add(c);
        } else {
            TngUtil.getRootCustomCategory((MethodPlugin)this.getPlugin()).getCategorizedElements().add(c);
        }
        return c;
    }

    public CapabilityPattern createCapabilityPattern(MethodConfiguration defaultConfig) {
        CapabilityPattern cp = UmaFactory.eINSTANCE.createCapabilityPattern();
        cp.setDefaultContext(defaultConfig);
        ProcessPackage capabilityPatternPkgs = (ProcessPackage)UmaUtil.findMethodPackage((MethodPlugin)this.getPlugin(), (String[])ModelStructure.DEFAULT.capabilityPatternPath);
        List items = capabilityPatternPkgs.getChildPackages();
        ProcessComponent pc = UmaFactory.eINSTANCE.createProcessComponent();
        pc.setGuid(EcoreUtil.generateUUID());
        items.add(pc);
        pc.setProcess((Process)cp);
        return cp;
    }

    public DeliveryProcess createDeliveryProcess(MethodConfiguration defaultConfig) {
        DeliveryProcess dp = UmaFactory.eINSTANCE.createDeliveryProcess();
        dp.setDefaultContext(defaultConfig);
        MethodPlugin plugin = this.getPlugin();
        ProcessPackage deliveryProcessPkgs = (ProcessPackage)UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.deliveryProcessPath);
        List items = deliveryProcessPkgs.getChildPackages();
        ProcessComponent pc = UmaFactory.eINSTANCE.createProcessComponent();
        pc.setGuid(EcoreUtil.generateUUID());
        items.add(pc);
        pc.setProcess((Process)dp);
        return dp;
    }

    public ContentPackage createContentPackage(ContentPackage container) {
        ContentPackage pkg = UmaFactory.eINSTANCE.createContentPackage();
        if (container == null) {
            container = UmaUtil.findContentPackage((MethodPlugin)this.getPlugin(), (String[])ModelStructure.DEFAULT.coreContentPath);
        }
        container.getChildPackages().add(pkg);
        return pkg;
    }

    public Artifact createArtifact(ContentPackage container) {
        Artifact e = UmaFactory.eINSTANCE.createArtifact();
        container.getContentElements().add(e);
        return e;
    }

    public Checklist createChecklist(ContentPackage container) {
        Checklist e = UmaFactory.eINSTANCE.createChecklist();
        container.getContentElements().add(e);
        return e;
    }

    public Concept createConcept(ContentPackage container) {
        Concept e = UmaFactory.eINSTANCE.createConcept();
        container.getContentElements().add(e);
        return e;
    }

    public Deliverable createDeliverable(ContentPackage container) {
        Deliverable e = UmaFactory.eINSTANCE.createDeliverable();
        container.getContentElements().add(e);
        return e;
    }

    public Example createExample(ContentPackage container) {
        Example e = UmaFactory.eINSTANCE.createExample();
        container.getContentElements().add(e);
        return e;
    }

    public Guidance createGuidance(ContentPackage container) {
        Guideline e = UmaFactory.eINSTANCE.createGuideline();
        container.getContentElements().add(e);
        return e;
    }

    public Outcome createOutcome(ContentPackage container) {
        Outcome e = UmaFactory.eINSTANCE.createOutcome();
        container.getContentElements().add(e);
        return e;
    }

    public Practice createPractice(ContentPackage container) {
        Practice e = UmaFactory.eINSTANCE.createPractice();
        container.getContentElements().add(e);
        return e;
    }

    public Report createReport(ContentPackage container) {
        Report e = UmaFactory.eINSTANCE.createReport();
        container.getContentElements().add(e);
        return e;
    }

    public ReusableAsset createReusableAsset(ContentPackage container) {
        ReusableAsset e = UmaFactory.eINSTANCE.createReusableAsset();
        container.getContentElements().add(e);
        return e;
    }

    public Roadmap createRoadmap(ContentPackage container) {
        Roadmap e = UmaFactory.eINSTANCE.createRoadmap();
        container.getContentElements().add(e);
        return e;
    }

    public Role createRole(ContentPackage container) {
        Role e = UmaFactory.eINSTANCE.createRole();
        container.getContentElements().add(e);
        return e;
    }

    public SupportingMaterial createSupportingMaterial(ContentPackage container) {
        SupportingMaterial e = UmaFactory.eINSTANCE.createSupportingMaterial();
        container.getContentElements().add(e);
        return e;
    }

    public Task createTask(ContentPackage container) {
        Task e = UmaFactory.eINSTANCE.createTask();
        container.getContentElements().add(e);
        return e;
    }

    public Template createTemplate(ContentPackage container) {
        Template e = UmaFactory.eINSTANCE.createTemplate();
        container.getContentElements().add(e);
        return e;
    }

    public TermDefinition createTermDefinition(ContentPackage container) {
        TermDefinition e = UmaFactory.eINSTANCE.createTermDefinition();
        container.getContentElements().add(e);
        return e;
    }

    public ToolMentor createToolMentor(ContentPackage container) {
        ToolMentor e = UmaFactory.eINSTANCE.createToolMentor();
        container.getContentElements().add(e);
        return e;
    }

    public Whitepaper createWhitepaper(ContentPackage container) {
        Whitepaper e = UmaFactory.eINSTANCE.createWhitepaper();
        container.getContentElements().add(e);
        return e;
    }

    public Activity createActivity(Activity superActivity) {
        Activity e = UmaFactory.eINSTANCE.createActivity();
        superActivity.getBreakdownElements().add(e);
        this.addActivityToContainer(e);
        return e;
    }

    public Phase createPhase(Activity superActivity) {
        Phase e = UmaFactory.eINSTANCE.createPhase();
        superActivity.getBreakdownElements().add(e);
        this.addActivityToContainer((Activity)e);
        return e;
    }

    public Iteration createIteration(Activity superActivity) {
        Iteration e = UmaFactory.eINSTANCE.createIteration();
        superActivity.getBreakdownElements().add(e);
        this.addActivityToContainer((Activity)e);
        return e;
    }

    public Milestone createMilestone(Activity superActivity) {
        Milestone e = UmaFactory.eINSTANCE.createMilestone();
        superActivity.getBreakdownElements().add(e);
        return e;
    }

    public void addTaskToActivity(Activity act, Task task) {
        this.addTasksToActivity(act, Collections.singletonList(task));
    }

    public void addTasksToActivity(final Activity act, final List tasks) {
        Process proc = TngUtil.getOwningProcess((BreakdownElement)act);
        MethodConfiguration config = proc.getDefaultContext();
        if (config != null) {
            Iterator it = tasks.iterator();
            while (it.hasNext()) {
                Task task = (Task)it.next();
                MethodPackage pkg = (MethodPackage)task.eContainer();
                List pkgs = config.getMethodPackageSelection();
                if (pkgs.contains(pkg)) continue;
                pkgs.add(pkg);
            }
        }
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                WBSDropCommand cmd = new WBSDropCommand(act, tasks);
                try {
                    try {
                        cmd.execute();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    cmd.dispose();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                cmd.dispose();
            }
        });
    }

    public static ProcessComponent getProcessComponent(BreakdownElement e) {
        if (e.eContainer() == null) {
            Activity parent = e.getSuperActivities();
            if (parent == null) {
                return null;
            }
            return PluginServiceImpl.getProcessComponent((BreakdownElement)parent);
        }
        EObject container = e.eContainer();
        while (container != null && !(container instanceof ProcessComponent)) {
            container = container.eContainer();
        }
        if (container != null) {
            return (ProcessComponent)container;
        }
        return null;
    }

    private void addActivityToContainer(Activity act) {
        ProcessComponent pc = PluginServiceImpl.getProcessComponent((BreakdownElement)act);
        if (pc != null) {
            ProcessPackage pkg = UmaFactory.eINSTANCE.createProcessPackage();
            pkg.setName(act.getName());
            pkg.setGuid(EcoreUtil.generateUUID());
            pc.getChildPackages().add(pkg);
            pkg.getProcessElements().add(act);
        }
    }
}

