/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.ProcessFamily;

public class LibraryServiceUtil {
    public static String getMethodLibraryPath(MethodLibrary library) {
        URI resourceURI;
        Resource resource = library.eResource();
        if (resource != null && (resourceURI = resource.getURI()) != null) {
            String path = resourceURI.toFileString();
            return new File(path).getParentFile().getAbsolutePath();
        }
        return null;
    }

    public static String getCurrentMethodLibraryPath() {
        return LibraryServiceUtil.getMethodLibraryPath(LibraryService.getInstance().getCurrentMethodLibrary());
    }

    public static MethodLibrary getMethodLibrary(MethodElement element) {
        MethodElement obj = element;
        while (obj != null) {
            if (obj instanceof MethodLibrary) {
                return (MethodLibrary)obj;
            }
            obj = obj.eContainer();
        }
        return null;
    }

    public static MethodConfiguration getMethodConfiguration(MethodLibrary library, String name) {
        if (library != null) {
            List configs = library.getPredefinedConfigurations();
            Iterator it = configs.iterator();
            while (it.hasNext()) {
                MethodConfiguration config = (MethodConfiguration)it.next();
                if (config instanceof ProcessFamily || !config.getName().equals(name)) continue;
                return config;
            }
        }
        return null;
    }

    public static MethodConfiguration[] getMethodConfigurations(MethodLibrary library) {
        ArrayList configs;
        if (library != null) {
            configs = new ArrayList(library.getPredefinedConfigurations());
            Iterator i = configs.iterator();
            while (i.hasNext()) {
                MethodConfiguration config = (MethodConfiguration)i.next();
                if (config != null && !(config instanceof ProcessFamily)) continue;
                i.remove();
            }
        } else {
            configs = Collections.EMPTY_LIST;
        }
        MethodConfiguration[] result = new MethodConfiguration[configs.size()];
        configs.toArray(result);
        return result;
    }

    public static String[] getMethodConfigurationNames(MethodLibrary library) {
        ArrayList<String> configNames = new ArrayList<String>();
        if (library != null) {
            List configs = library.getPredefinedConfigurations();
            Iterator i = configs.iterator();
            while (i.hasNext()) {
                MethodConfiguration config = (MethodConfiguration)i.next();
                if (config instanceof ProcessFamily) continue;
                configNames.add(config.getName());
            }
        }
        String[] result = new String[configNames.size()];
        configNames.toArray(result);
        return result;
    }

    public static String[] getProcessFamilyNames(MethodLibrary library) {
        ArrayList<String> processFamilyNames = new ArrayList<String>();
        if (library != null) {
            List configs = library.getPredefinedConfigurations();
            Iterator i = configs.iterator();
            while (i.hasNext()) {
                MethodConfiguration config = (MethodConfiguration)i.next();
                if (!(config instanceof ProcessFamily)) continue;
                processFamilyNames.add(config.getName());
            }
        }
        String[] result = new String[processFamilyNames.size()];
        processFamilyNames.toArray(result);
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setGUID(MethodElement element) {
        EList children;
        String guid = element.getGuid();
        if (guid == null || guid.length() == 0) {
            guid = EcoreUtil.generateUUID();
            boolean oldNotify = element.eDeliver();
            try {
                element.eSetDeliver(false);
                element.setGuid(guid);
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                element.eSetDeliver(oldNotify);
                throw throwable;
            }
            {
                Object var4_8 = null;
            }
            element.eSetDeliver(oldNotify);
        }
        if ((children = element.eContents()) != null && children.size() > 0) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                Object child = it.next();
                if (!(child instanceof MethodElement)) continue;
                this.setGUID((MethodElement)child);
            }
        }
    }

    public static String getDebugStr(MethodElement element) {
        if (element == null) {
            return "null";
        }
        return String.valueOf(element.getClass().getName()) + "[name: " + element.getName() + ", guid=" + element.getGuid() + "]";
    }

    public static String getQueryString(String process, String path) {
        return "?proc=" + process + "&" + "path" + "=" + path;
    }
}

