/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.configuration.AttributeFeatureValue;
import org.eclipse.epf.library.configuration.DefaultElementRealizer;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.configuration.FeatureValue;
import org.eclipse.epf.library.configuration.OrderedListComparator;
import org.eclipse.epf.library.configuration.ToManyFeatureValue;
import org.eclipse.epf.library.configuration.ToManyOppositeFeatureValue;
import org.eclipse.epf.library.configuration.ToOneFeatureValue;
import org.eclipse.epf.library.configuration.ToOneOppositeFeatureValue;
import org.eclipse.epf.library.edit.util.SectionList;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.util.AssociationHelper;

public class ConfigurationHelper {
    public static final String ATTRIBUTE_VALUE_SEPERATOR = "<p/>";
    private static boolean debug = LibraryPlugin.getDefault().isDebugging();
    static /* synthetic */ Class class$0;

    public static boolean isDescriptionElement(MethodElement element) {
        return element instanceof ContentDescription || element.eContainer() instanceof ContentDescription;
    }

    public static boolean isGlobalPackage(MethodPackage pkg) {
        if (pkg == null) {
            if (debug) {
                System.out.println("ConfigurationHelper.isGlobalPackage: method package is null");
            }
            return false;
        }
        MethodPlugin p = LibraryUtil.getMethodPlugin((EObject)pkg);
        if (p == null) {
            if (debug) {
                System.out.println("ConfigurationHelper.isGlobalPackage: Unable to find method plug-in for " + pkg.getName() + ": " + pkg.getGuid());
            }
            return false;
        }
        return TngUtil.getAllSystemPackages((MethodPlugin)p).contains(pkg);
    }

    public static boolean inConfig(MethodElement element, MethodConfiguration config) {
        VariabilityElement ve;
        if (!ConfigurationHelper.isOwnerSelected(element, config)) {
            return false;
        }
        if (element instanceof VariabilityElement && ConfigurationHelper.isReplacer(ve = (VariabilityElement)element)) {
            VariabilityElement base = ve.getVariabilityBasedOnElement();
            if (ConfigurationHelper.inConfig((MethodElement)base, config)) {
                Iterator it = AssociationHelper.getImmediateVarieties((VariabilityElement)base).iterator();
                while (it.hasNext()) {
                    VariabilityElement e = (VariabilityElement)it.next();
                    if (e == element || e.getVariabilityType() != VariabilityType.REPLACES_LITERAL || !ConfigurationHelper.isOwnerSelected((MethodElement)e, config)) continue;
                    if (debug) {
                        System.out.println("ConfigurationHelper.inConfig: Ignoring replacing element '" + LibraryUtil.getTypeName(element) + "' since its base element has more than one replacer in the configuration");
                    }
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static boolean isOwnerSelected(MethodElement element, MethodConfiguration config) {
        Process owningProc;
        Activity base;
        if (element == null) {
            return false;
        }
        if (config == null || ConfigurationHelper.isDescriptionElement(element)) {
            return true;
        }
        if (element instanceof MethodLibrary || element instanceof MethodConfiguration) {
            return true;
        }
        if (element instanceof MethodPlugin) {
            List plugins = config.getMethodPluginSelection();
            return plugins != null && plugins.contains(element);
        }
        if (element instanceof Activity && (base = (Activity)((Activity)element).getVariabilityBasedOnElement()) != null && base != element && (owningProc = TngUtil.getOwningProcess((BreakdownElement)base)) != null && owningProc != element && !ConfigurationHelper.inConfig((MethodElement)owningProc, config)) {
            return false;
        }
        EObject pkg = LibraryUtil.getSelectable((EObject)element);
        if (pkg instanceof MethodPackage && ConfigurationHelper.isGlobalPackage((MethodPackage)pkg)) {
            MethodPlugin plugin = LibraryUtil.getMethodPlugin(pkg);
            return ConfigurationHelper.inConfig((MethodElement)plugin, config);
        }
        List pkgs = config.getMethodPackageSelection();
        if (pkgs == null) {
            return false;
        }
        if (pkg instanceof ProcessPackage) {
            while (pkg != null && !(pkg instanceof ProcessComponent) && !pkgs.contains(pkg)) {
                pkg = pkg.eContainer();
            }
        }
        return pkg != null && pkgs.contains(pkg);
    }

    public static boolean isContributor(VariabilityElement element) {
        int type;
        if (element == null || element.getVariabilityBasedOnElement() == null) {
            return false;
        }
        VariabilityType vtype = element.getVariabilityType();
        return vtype != null && (type = vtype.getValue()) == 1;
    }

    public static boolean isReplacer(VariabilityElement element) {
        int type;
        if (element == null || element.getVariabilityBasedOnElement() == null) {
            return false;
        }
        VariabilityType vtype = element.getVariabilityType();
        return vtype != null && (type = vtype.getValue()) == 3;
    }

    public static boolean isExtender(VariabilityElement element) {
        int type;
        if (element == null || element.getVariabilityBasedOnElement() == null) {
            return false;
        }
        VariabilityType vtype = element.getVariabilityType();
        return vtype != null && (type = vtype.getValue()) == 2;
    }

    public static VariabilityElement getReplacer(VariabilityElement element, MethodConfiguration config) {
        VariabilityElement ve = null;
        Iterator it = AssociationHelper.getImmediateVarieties((VariabilityElement)element).iterator();
        while (it.hasNext()) {
            VariabilityElement e = (VariabilityElement)it.next();
            if (e == null || e.getVariabilityType() != VariabilityType.REPLACES_LITERAL || !ConfigurationHelper.inConfig((MethodElement)e, config)) continue;
            if (ve != null) {
                if (debug) {
                    System.out.println("ConfigurationHelper.getReplacer: Replacer ignored for element '" + LibraryUtil.getTypeName((MethodElement)element) + "' since it has more than one replacerin the configuration");
                }
                return null;
            }
            ve = e;
        }
        return ve;
    }

    public static List getContributors(VariabilityElement element, MethodConfiguration config) {
        ArrayList<VariabilityElement> items = new ArrayList<VariabilityElement>();
        if (element == null) {
            return items;
        }
        Iterator it = AssociationHelper.getImmediateVarieties((VariabilityElement)element).iterator();
        while (it.hasNext()) {
            VariabilityElement e = (VariabilityElement)it.next();
            if (e == null || e.getVariabilityType() != VariabilityType.CONTRIBUTES_LITERAL || !ConfigurationHelper.inConfig((MethodElement)e, config)) continue;
            VariabilityElement replacer = ConfigurationHelper.getReplacer(e, config);
            if (replacer != null) {
                items.add(replacer);
                continue;
            }
            items.add(e);
        }
        return items;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean canShow(MethodElement element, MethodConfiguration config) {
        block6: {
            if (element == null) {
                return false;
            }
            if (!ConfigurationHelper.inConfig(element, config)) {
                return false;
            }
            supressed = element.getSuppressed();
            if (supressed != null && supressed.booleanValue()) {
                return false;
            }
            if (!(element instanceof VariabilityElement)) break block6;
            e = (VariabilityElement)element;
            if (ConfigurationHelper.isExtender(e)) {
                return true;
            }
            if (ConfigurationHelper.isContributor(e) || ConfigurationHelper.getReplacer(e, config) != null) {
                return false;
            }
            if (!(e instanceof Activity) || !ConfigurationHelper.hasContributor((Activity)e)) ** GOTO lbl18
            return false;
lbl-1000:
            // 1 sources

            {
                if (!ConfigurationHelper.isContributor(e = e.getVariabilityBasedOnElement())) continue;
                return false;
lbl18:
                // 2 sources

                ** while (e != null && ConfigurationHelper.isReplacer((VariabilityElement)e))
            }
        }
        return true;
    }

    public static String getName(MethodElement element, MethodConfiguration config) {
        if (element instanceof VariabilityElement) {
            VariabilityElement e = (VariabilityElement)element;
            if (ConfigurationHelper.isContributor(e)) {
                return ConfigurationHelper.getName((MethodElement)e.getVariabilityBasedOnElement(), config);
            }
            VariabilityElement rep = ConfigurationHelper.getReplacer(e, config);
            if (rep != null) {
                return ConfigurationHelper.getName((MethodElement)rep, config);
            }
        }
        return element.getName();
    }

    public static String getPresentationName(MethodElement element, MethodConfiguration config) {
        String name = (String)ConfigurationHelper.calcAttributeFeatureValue(element, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName(), config);
        if (name == null || name.length() == 0) {
            name = TngUtil.getPresentationName((Object)element);
        }
        return name;
    }

    public static VariabilityElement getVariableOwner(MethodElement e) {
        EObject eObj;
        if (e instanceof VariabilityElement) {
            return (VariabilityElement)e;
        }
        if (e instanceof ContentDescription && (eObj = e.eContainer()) instanceof VariabilityElement) {
            return (VariabilityElement)eObj;
        }
        return null;
    }

    public static boolean isMergableAttribute(EStructuralFeature feature) {
        if (!feature.getEType().getInstanceClassName().equals("java.lang.String")) {
            return false;
        }
        return feature != UmaPackage.eINSTANCE.getMethodElement_Guid() && feature != UmaPackage.eINSTANCE.getNamedElement_Name() && feature != UmaPackage.eINSTANCE.getWorkProductDescription_ExternalId() && feature != UmaPackage.eINSTANCE.getDescribableElement_PresentationName();
    }

    public static boolean isAttributeFeature(EStructuralFeature feature) {
        return feature.getEType() instanceof EAttribute;
    }

    public static boolean is01Feature(EStructuralFeature feature) {
        return feature.getEType() instanceof EClass && !feature.isMany();
    }

    public static boolean is0nFeature(EStructuralFeature feature) {
        return feature.getEType() instanceof EClass && feature.isMany();
    }

    private static void calculateFeature(MethodElement element, MethodElement OwnerElement, EStructuralFeature feature, MethodConfiguration config, FeatureValue values, ElementRealizer realizer) {
        List items;
        List features = element.getInstanceProperties();
        if (!features.contains(feature)) {
            return;
        }
        VariabilityElement ve = ConfigurationHelper.getVariableOwner(OwnerElement == null ? element : OwnerElement);
        Object value = element.eGet(feature);
        values.add(ve, value);
        if (config == null) {
            return;
        }
        if (ve == null) {
            return;
        }
        boolean mergeable = true;
        if (ConfigurationHelper.isAttributeFeature(feature) && !ConfigurationHelper.isMergableAttribute(feature)) {
            mergeable = false;
        }
        if (mergeable && (items = ConfigurationHelper.getContributors(ve, config)) != null && items.size() > 0) {
            Iterator it = items.iterator();
            while (it.hasNext()) {
                MethodElement e;
                MethodElement o = e = (MethodElement)it.next();
                if (element instanceof ContentDescription) {
                    e = ((DescribableElement)e).getPresentation();
                }
                ConfigurationHelper.calculateFeature(e, o, feature, config, values, realizer);
            }
        }
        if (ConfigurationHelper.isExtender(ve)) {
            boolean mergebase = false;
            if (ConfigurationHelper.is0nFeature(feature)) {
                mergebase = true;
            } else if (ConfigurationHelper.is01Feature(feature)) {
                mergebase = values.size() == 0;
            } else {
                boolean bl = mergebase = ConfigurationHelper.isMergableAttribute(feature) && values.size() == 0;
            }
            if (mergebase) {
                MethodElement e;
                MethodElement o = e = ConfigurationHelper.getCalculatedElement((MethodElement)ve.getVariabilityBasedOnElement(), config);
                if (ve != e && ConfigurationHelper.inConfig(e, config)) {
                    if (element instanceof ContentDescription) {
                        try {
                            e = ((DescribableElement)e).getPresentation();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                    ConfigurationHelper.calculateFeature(e, o, feature, config, values, realizer);
                    if (ve instanceof ContentElement && feature == UmaPackage.eINSTANCE.getContentDescription_Sections()) {
                        ConfigurationHelper.orderSections((ContentElement)ve, (List)values.getValue());
                    }
                }
            }
        }
    }

    private static void calculateOppositeFeature(MethodElement element, OppositeFeature feature, ElementRealizer realizer, FeatureValue values) {
        ConfigurationHelper.calculateOppositeFeature(element, feature, true, false, realizer, values);
    }

    private static void calculateOppositeFeature(MethodElement element, OppositeFeature feature, boolean mergeReplacerBase, boolean mergeExtenderBase, ElementRealizer realizer, FeatureValue values) {
        if (!(element instanceof MultiResourceEObject)) {
            return;
        }
        MethodConfiguration config = realizer.getConfiguration();
        VariabilityElement ve = ConfigurationHelper.getVariableOwner(element);
        Object value = ((MultiResourceEObject)element).getOppositeFeatureValue(feature);
        values.add(ve, value);
        if (element instanceof VariabilityElement && config != null) {
            VariabilityElement ce = (VariabilityElement)element;
            List items = ConfigurationHelper.getContributors(ce, config);
            if (items != null && items.size() > 0) {
                Iterator it = items.iterator();
                while (it.hasNext()) {
                    MethodElement e = (MethodElement)it.next();
                    ConfigurationHelper.calculateOppositeFeature(e, feature, mergeReplacerBase, mergeExtenderBase, realizer, values);
                }
            }
            boolean mergebase = false;
            boolean isExtender = ConfigurationHelper.isExtender(ce);
            boolean isReplacer = ConfigurationHelper.isReplacer(ce);
            if (isReplacer) {
                mergebase = mergeReplacerBase && (value instanceof List || values.size() == 0);
            } else if (isExtender) {
                mergebase = mergeExtenderBase;
            }
            if (mergebase) {
                DefaultElementRealizer realizer2 = new DefaultElementRealizer(config, !isReplacer, !isReplacer);
                MethodElement e = ConfigurationHelper.getCalculatedElement((MethodElement)ce.getVariabilityBasedOnElement(), realizer2);
                if (e == null) {
                    e = ce.getVariabilityBasedOnElement();
                }
                if (e != ce && ConfigurationHelper.inConfig(e, config)) {
                    ConfigurationHelper.calculateOppositeFeature(e, feature, mergeReplacerBase, mergeExtenderBase, realizer, values);
                }
            }
        }
    }

    public static List getCalculatedElements(List elements, MethodConfiguration config) {
        ArrayList<MethodElement> values = new ArrayList<MethodElement>();
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            MethodElement e = (MethodElement)it.next();
            if ((e = ConfigurationHelper.getCalculatedElement(e, config)) == null || values.contains(e)) continue;
            values.add(e);
        }
        return values;
    }

    public static MethodElement getCalculatedElement(MethodElement element, MethodConfiguration config) {
        DefaultElementRealizer realizer = new DefaultElementRealizer(config, true, true);
        return ConfigurationHelper.getCalculatedElement(element, realizer);
    }

    public static MethodElement getCalculatedElement(MethodElement element, ElementRealizer realizer) {
        MethodElement e2;
        MethodElement e = element;
        while ((e2 = realizer.realize(e)) != e) {
            e = e2;
        }
        return e;
    }

    public static MethodElement calc01FeatureValue(MethodElement element, EStructuralFeature feature, ElementRealizer realizer) {
        return ConfigurationHelper.calc01FeatureValue(element, null, feature, realizer);
    }

    public static MethodElement calc01FeatureValue(MethodElement element, MethodElement ownerElement, EStructuralFeature feature, ElementRealizer realizer) {
        Object v = element.eGet(feature);
        if (v instanceof ContentDescription) {
            return (MethodElement)v;
        }
        ToOneFeatureValue values = new ToOneFeatureValue(element, ownerElement, feature, realizer);
        ConfigurationHelper.calculateFeature(element, ownerElement, feature, realizer.getConfiguration(), values, realizer);
        return (MethodElement)values.getValue();
    }

    public static boolean isContainmentFeature(EStructuralFeature feature) {
        return feature == UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts() || feature == UmaPackage.eINSTANCE.getPractice_SubPractices();
    }

    public static boolean isContainmentElement(Object element) {
        return element instanceof Artifact || element instanceof Practice;
    }

    private static List getContainers(MethodElement element, MethodConfiguration config) {
        ArrayList<MethodElement> items = new ArrayList<MethodElement>();
        MethodElement o = element;
        while (o != null && (o = o.eContainer()) != null && o.getClass().isInstance(element)) {
            if (o instanceof VariabilityElement) {
                o = ConfigurationHelper.getCalculatedElement((MethodElement)((VariabilityElement)o), config);
            }
            if (o == null || items.contains(o)) continue;
            items.add(o);
        }
        return items;
    }

    public static OppositeFeature get01OppositeFeature(EStructuralFeature feature) {
        if (feature == UmaPackage.eINSTANCE.getDomain_WorkProducts()) {
            return AssociationHelper.WorkProduct_Domain;
        }
        return null;
    }

    public static List calc0nFeatureValue(MethodElement element, EStructuralFeature feature, ElementRealizer realizer) {
        return ConfigurationHelper.calc0nFeatureValue(element, null, feature, realizer);
    }

    public static List calc0nFeatureValue(MethodElement element, MethodElement ownerElement, EStructuralFeature feature, ElementRealizer realizer) {
        OppositeFeature of;
        List v = null;
        MethodConfiguration config = realizer.getConfiguration();
        if (element instanceof Role && feature == UmaPackage.eINSTANCE.getRole_Modifies()) {
            v = ConfigurationHelper.calcModifiedWorkProducts((Role)element, ownerElement, realizer);
        } else if (element instanceof RoleDescriptor && feature == UmaPackage.eINSTANCE.getRoleDescriptor_Modifies()) {
            v = ConfigurationHelper.calcModifiedWorkProductDescriptors((RoleDescriptor)element, ownerElement, realizer);
        } else {
            ToManyFeatureValue fv = new ToManyFeatureValue(element, ownerElement, feature, realizer);
            ConfigurationHelper.calculateFeature(element, ownerElement, feature, config, fv, realizer);
            v = (List)fv.getValue();
        }
        List values = ConfigurationHelper.getCalculatedElements(v, config);
        if (values.contains(element)) {
            values.remove(element);
        }
        if ((of = ConfigurationHelper.get01OppositeFeature(feature)) != null) {
            int i = 0;
            while (i < values.size()) {
                MethodElement o = (MethodElement)values.get(i);
                MethodElement oo = ConfigurationHelper.calc01FeatureValue(o, of, (ElementRealizer)new DefaultElementRealizer(config));
                if (oo != element) {
                    values.remove(i);
                    continue;
                }
                ++i;
            }
        }
        if (ConfigurationHelper.isContainmentFeature(feature)) {
            List containers = ConfigurationHelper.getContainers(element, config);
            int i = 0;
            while (i < values.size()) {
                Object o = values.get(i);
                if (o == element || containers.contains(o)) {
                    values.remove(i);
                    continue;
                }
                ++i;
            }
        }
        return realizer.realize(element, feature, values);
    }

    public static boolean isContainerInList(MethodElement element, List items, MethodConfiguration config) {
        MethodElement o = element;
        while (o != null && (o = o.eContainer()) != null && o.getClass().isInstance(element)) {
            if (items.contains(o)) {
                return true;
            }
            if (o instanceof VariabilityElement) {
                o = ConfigurationHelper.getCalculatedElement((MethodElement)((VariabilityElement)o), config);
            }
            if (o == null || !items.contains(o)) continue;
            return true;
        }
        return false;
    }

    public static Object calcAttributeFeatureValue(MethodElement element, EStructuralFeature feature, MethodConfiguration config) {
        return ConfigurationHelper.calcAttributeFeatureValue(element, null, feature, config);
    }

    public static Object calcAttributeFeatureValue(MethodElement element, MethodElement ownerElement, EStructuralFeature feature, MethodConfiguration config) {
        if (ConfigurationHelper.isMergableAttribute(feature)) {
            DefaultElementRealizer realizer = new DefaultElementRealizer(config);
            AttributeFeatureValue values = new AttributeFeatureValue(element, ownerElement, feature, realizer);
            ConfigurationHelper.calculateFeature(element, ownerElement, feature, config, values, realizer);
            return values.getValue();
        }
        return element.eGet(feature);
    }

    public static List calc0nFeatureValue(MethodElement element, OppositeFeature feature, ElementRealizer realizer) {
        return ConfigurationHelper.calc0nFeatureValue(element, feature, true, false, realizer);
    }

    public static List calc0nFeatureValue(MethodElement element, OppositeFeature feature, boolean mergeReplacerBase, boolean mergeExtenderBase, ElementRealizer realizer) {
        ToManyOppositeFeatureValue values = new ToManyOppositeFeatureValue(element, feature, realizer);
        ConfigurationHelper.calculateOppositeFeature(element, feature, mergeReplacerBase, mergeExtenderBase, realizer, values);
        return (List)values.getValue();
    }

    public static MethodElement calc01FeatureValue(MethodElement element, OppositeFeature feature, ElementRealizer realizer) {
        ToOneOppositeFeatureValue values = new ToOneOppositeFeatureValue(element, feature, realizer);
        ConfigurationHelper.calculateOppositeFeature(element, feature, realizer, values);
        return (MethodElement)values.getValue();
    }

    public static void orderSections(ContentElement element, List values) {
        String orderingGuide = element.getOrderingGuide();
        if (orderingGuide == null || orderingGuide.trim().length() == 0) {
            return;
        }
        SectionList slist = new SectionList(element, 2);
        if (ConfigurationHelper.isSameList(values, (List)slist)) {
            values.clear();
            values.addAll(slist);
            return;
        }
        OrderedListComparator comp = new OrderedListComparator(new ArrayList(values), (List)slist);
        TreeSet s = new TreeSet(comp);
        s.addAll(values);
        values.clear();
        values.addAll(s);
    }

    private static boolean isSameList(List l1, List l2) {
        if (l1.size() != l2.size()) {
            return false;
        }
        Iterator it = l1.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (l2.contains(o)) continue;
            return false;
        }
        return true;
    }

    private static void calculateCopyright(MethodElement element, MethodConfiguration config, List values) {
        MethodElement e;
        VariabilityElement ve;
        SupportingMaterial copyright = (SupportingMaterial)ConfigurationHelper.getCalculatedElement((MethodElement)LibraryUtil.getCopyright(element), config);
        if (copyright != null && !values.contains(copyright)) {
            values.add(copyright);
        }
        if ((ve = ConfigurationHelper.getVariableOwner(element)) == null) {
            return;
        }
        if (config == null) {
            return;
        }
        List items = ConfigurationHelper.getContributors(ve, config);
        if (items != null && items.size() > 0) {
            Iterator it = items.iterator();
            while (it.hasNext()) {
                MethodElement e2 = (MethodElement)it.next();
                ConfigurationHelper.calculateCopyright(e2, config, values);
            }
        }
        if (ConfigurationHelper.isExtender(ve) && ve != (e = ConfigurationHelper.getCalculatedElement((MethodElement)ve.getVariabilityBasedOnElement(), config)) && ConfigurationHelper.inConfig(e, config)) {
            ArrayList baseItems = new ArrayList();
            ConfigurationHelper.calculateCopyright(e, config, baseItems);
            if (baseItems.size() > 0) {
                int i = 0;
                while (i < values.size()) {
                    if (baseItems.contains(values.get(i))) {
                        values.remove(i);
                        continue;
                    }
                    ++i;
                }
                values.addAll(0, baseItems);
            }
        }
    }

    public static String getCopyrightText(MethodElement element, MethodConfiguration config) {
        StringBuffer copyrights = new StringBuffer();
        ArrayList items = new ArrayList();
        ConfigurationHelper.calculateCopyright(element, config, items);
        if (items.size() > 0) {
            Iterator it = items.iterator();
            while (it.hasNext()) {
                SupportingMaterial copyright = (SupportingMaterial)it.next();
                String statement = (String)ConfigurationHelper.calcAttributeFeatureValue((MethodElement)copyright.getPresentation(), (MethodElement)copyright, (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_MainDescription(), config);
                if (statement == null || statement.length() <= 0) continue;
                String contentPath = ResourceHelper.getElementPath((MethodElement)copyright);
                String backPath = ResourceHelper.getBackPath(element);
                statement = ResourceHelper.fixContentUrlPath(statement, contentPath, backPath);
                if (copyrights.length() > 0) {
                    copyrights.append(ATTRIBUTE_VALUE_SEPERATOR);
                }
                copyrights.append(statement);
            }
        }
        return copyrights.toString();
    }

    public static String getActivityStringAttribute(MethodElement e, EAttribute attrib, MethodConfiguration config) {
        Object str;
        boolean isDesc;
        VariabilityElement ve;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(attrib.getEAttributeType().getInstanceClass())) {
            throw new IllegalArgumentException("The specified attribute is not of type String: " + attrib);
        }
        if (e instanceof ContentDescription) {
            ve = (VariabilityElement)e.eContainer();
            isDesc = true;
        } else {
            ve = (VariabilityElement)e;
            isDesc = false;
        }
        if (attrib == UmaPackage.eINSTANCE.getMethodElement_Guid() || attrib == UmaPackage.eINSTANCE.getNamedElement_Name()) {
            return (String)e.eGet((EStructuralFeature)attrib);
        }
        VariabilityElement base = ve.getVariabilityBasedOnElement();
        VariabilityType variabilityType = ve.getVariabilityType();
        if (base != null && variabilityType == VariabilityType.LOCAL_CONTRIBUTION_LITERAL) {
            str = ((DescribableElement)ve).getPresentation().eGet((EStructuralFeature)attrib);
            Object strBase = isDesc ? ConfigurationHelper.calcAttributeFeatureValue((MethodElement)((DescribableElement)base).getPresentation(), (MethodElement)base, (EStructuralFeature)attrib, config) : ConfigurationHelper.calcAttributeFeatureValue((MethodElement)base, null, (EStructuralFeature)attrib, config);
            if (str != null && str.toString().length() > 0 && strBase != null && strBase.toString().length() > 0) {
                str = strBase + ATTRIBUTE_VALUE_SEPERATOR + str;
            }
        } else {
            str = ConfigurationHelper.calcAttributeFeatureValue(e, (MethodElement)ve, (EStructuralFeature)attrib, config);
        }
        return str == null ? "" : str.toString();
    }

    public static List getAllProcesses(MethodConfiguration config) {
        ArrayList<Process> processes = new ArrayList<Process>();
        List plugins = config.getMethodPluginSelection();
        Iterator it = plugins.iterator();
        while (it.hasNext()) {
            List items = TngUtil.getAllProcesses((MethodPlugin)((MethodPlugin)it.next()));
            Iterator itp = items.iterator();
            while (itp.hasNext()) {
                Process p = (Process)itp.next();
                if (!ConfigurationHelper.canShow((MethodElement)p, config) || processes.contains(p)) continue;
                processes.add(p);
            }
        }
        return processes;
    }

    public static List getAllProcesses(MethodPlugin plugin, MethodConfiguration config) {
        ArrayList<Process> processes = new ArrayList<Process>();
        List items = TngUtil.getAllProcesses((MethodPlugin)plugin);
        Iterator itp = items.iterator();
        while (itp.hasNext()) {
            Process p = (Process)itp.next();
            if (!ConfigurationHelper.canShow((MethodElement)p, config) || processes.contains(p)) continue;
            processes.add(p);
        }
        return processes;
    }

    public static List getAllDeliveryProcesses(MethodPlugin plugin, MethodConfiguration config) {
        ArrayList<Process> processes = new ArrayList<Process>();
        List items = TngUtil.getAllProcesses((MethodPlugin)plugin);
        Iterator itp = items.iterator();
        while (itp.hasNext()) {
            Process p = (Process)itp.next();
            if (!(p instanceof DeliveryProcess) || !ConfigurationHelper.canShow((MethodElement)p, config) || processes.contains(p)) continue;
            processes.add(p);
        }
        return processes;
    }

    public static List getAllCapabilityPatterns(MethodPlugin plugin, MethodConfiguration config) {
        ArrayList<Process> processes = new ArrayList<Process>();
        List items = TngUtil.getAllProcesses((MethodPlugin)plugin);
        Iterator itp = items.iterator();
        while (itp.hasNext()) {
            Process p = (Process)itp.next();
            if (!(p instanceof CapabilityPattern) || !ConfigurationHelper.canShow((MethodElement)p, config) || processes.contains(p)) continue;
            processes.add(p);
        }
        return processes;
    }

    public static List calcModifiedWorkProducts(Role element, MethodElement ownerElement, ElementRealizer realizer) {
        List v = new ArrayList();
        OppositeFeature ofeature = AssociationHelper.Role_Primary_Tasks;
        ToManyOppositeFeatureValue fv2 = new ToManyOppositeFeatureValue((MethodElement)element, ofeature, realizer);
        ConfigurationHelper.calculateOppositeFeature((MethodElement)element, ofeature, realizer, fv2);
        if (fv2.size() > 0) {
            List v2 = (List)fv2.getValue();
            EReference feature = UmaPackage.eINSTANCE.getTask_Output();
            Iterator it = v2.iterator();
            while (it.hasNext()) {
                MethodElement e = (MethodElement)it.next();
                ToManyFeatureValue fv = new ToManyFeatureValue((MethodElement)element, ownerElement, feature, realizer);
                ((List)fv.getValue()).addAll(v);
                ConfigurationHelper.calculateFeature(e, ownerElement, (EStructuralFeature)feature, realizer.getConfiguration(), fv, realizer);
                v = (List)fv.getValue();
            }
        }
        return v;
    }

    public static List calcModifiedWorkProductDescriptors(RoleDescriptor element, MethodElement ownerElement, ElementRealizer realizer) {
        List v = new ArrayList();
        OppositeFeature ofeature = AssociationHelper.RoleDescriptor_PrimaryTaskDescriptors;
        ToManyOppositeFeatureValue fv2 = new ToManyOppositeFeatureValue((MethodElement)element, ofeature, realizer);
        ConfigurationHelper.calculateOppositeFeature((MethodElement)element, ofeature, realizer, fv2);
        if (fv2.size() > 0) {
            List v2 = (List)fv2.getValue();
            EReference feature = UmaPackage.eINSTANCE.getTaskDescriptor_Output();
            Iterator it = v2.iterator();
            while (it.hasNext()) {
                MethodElement e = (MethodElement)it.next();
                ToManyFeatureValue fv = new ToManyFeatureValue((MethodElement)element, ownerElement, feature, realizer);
                ((List)fv.getValue()).addAll(v);
                ConfigurationHelper.calculateFeature(e, ownerElement, (EStructuralFeature)feature, realizer.getConfiguration(), fv, realizer);
                v = (List)fv.getValue();
            }
        }
        return v;
    }

    public static List calcModifyRoles(WorkProduct element, ElementRealizer realizer) {
        List tasks = ConfigurationHelper.calc0nFeatureValue((MethodElement)element, AssociationHelper.WorkProduct_OutputFrom_Tasks, realizer);
        ArrayList<Role> modifyRoles = new ArrayList<Role>();
        Iterator it = tasks.iterator();
        while (it.hasNext()) {
            Task t = (Task)it.next();
            Role r = (Role)ConfigurationHelper.calc01FeatureValue((MethodElement)t, (EStructuralFeature)UmaPackage.eINSTANCE.getTask_PerformedBy(), realizer);
            if (r == null || modifyRoles.contains(r)) continue;
            modifyRoles.add(r);
        }
        return modifyRoles;
    }

    public static boolean hasContributor(Activity element) {
        if (ConfigurationHelper.isContributor((VariabilityElement)element)) {
            return true;
        }
        Iterator it = element.getBreakdownElements().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof Activity) || !ConfigurationHelper.hasContributor((Activity)o)) continue;
            return true;
        }
        return false;
    }

    public static List getBaseProcesses(Activity element, MethodConfiguration config) {
        ArrayList value = new ArrayList();
        ConfigurationHelper.getBaseProcesses(element, config, value);
        return value;
    }

    public static void getBaseProcesses(Activity element, MethodConfiguration config, List value) {
        Activity base;
        if (ConfigurationHelper.isExtender((VariabilityElement)element) && (base = (Activity)element.getVariabilityBasedOnElement()) != null && !value.contains(base) && base instanceof Process) {
            if (ConfigurationHelper.canShow((MethodElement)base, config)) {
                value.add(base);
            }
            ConfigurationHelper.getBaseProcesses(base, config, value);
        }
        Iterator it = element.getBreakdownElements().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof Activity)) continue;
            ConfigurationHelper.getBaseProcesses((Activity)o, config, value);
        }
    }
}

