/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.common.xml.XSLTProcessor;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.layout.IContentValidator;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.layout.util.XmlHelper;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.ProcessComponent;

public class LinkInfo {
    public static final String LINK_ATTR_CLASS = "class";
    public static final String LINK_ATTR_GUID = "guid";
    public static final String LINK_ATTR_HREF = "href";
    public static final String LINK_ATTR_KEY = "key";
    public static final String LINK_ATTR_TEXT = "text";
    public static final String LINK_ATTR_NAME = "name";
    private String linkedText = "";
    private MethodElement linkElement = null;
    private MethodElement ownerElement = null;
    private boolean isMissingReference = false;
    private Map attributeMap = new LinkedHashMap();
    private IContentValidator validator;
    private String pubDir;

    public LinkInfo(MethodElement owner, IContentValidator validator, String pubDir) {
        this.ownerElement = owner;
        this.validator = validator;
        this.pubDir = pubDir;
    }

    public boolean isElementLink() {
        return ResourceHelper.isElementLink(this.getElementLinkType());
    }

    public String getElementLinkType() {
        return this.getAttribute(LINK_ATTR_CLASS);
    }

    public String getGuid() {
        return this.getAttribute(LINK_ATTR_GUID);
    }

    public String getUrl() {
        return this.getAttribute(LINK_ATTR_HREF);
    }

    public String getLinkedText() {
        return this.linkedText;
    }

    public MethodElement getLinkedElement() {
        return this.linkElement;
    }

    public StringBuffer getHtml(boolean showBrokenLinks) {
        StringBuffer buffer = new StringBuffer();
        if (this.isMissingReference && this.pubDir != null) {
            String url = "";
            if (!showBrokenLinks) {
                buffer.append(this.linkedText);
                return buffer;
            }
            url = this.getMissingElementUrl();
            buffer.append("<img alt=\"\" src=\"" + ResourceHelper.getBackPath(this.ownerElement) + "images/no_rup.gif\">&#160;");
            this.setUrl(url);
        }
        buffer.append("<a");
        Iterator it = this.attributeMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (LINK_ATTR_HREF.equals(key) && (value == null || value.length() == 0)) continue;
            buffer.append(" ").append(entry.getKey()).append("=").append("\"").append(entry.getValue()).append("\"");
        }
        buffer.append(">").append(this.linkedText).append("</a>");
        return buffer;
    }

    public void validateLink(String attributes, String text, MethodConfiguration config) {
        String url;
        this.linkedText = text;
        Matcher m2 = ResourceHelper.p_tag_attributes.matcher(attributes);
        while (m2.find()) {
            String attrName = m2.group(1).trim().toLowerCase();
            String attrValue = m2.group(3).trim();
            if (attrName.equals(LINK_ATTR_HREF)) {
                try {
                    attrValue = this.decode(attrValue);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.attributeMap.put(attrName, attrValue);
        }
        String guid = this.getGuid();
        if (guid == null && (guid = ResourceHelper.getGuidFromFileName(url = this.getUrl())) != null) {
            this.setGuid(guid);
        }
        this.validateElementUrl(config);
    }

    protected String decode(String str) throws UnsupportedEncodingException {
        return URLDecoder.decode(str, "UTF-8");
    }

    public String getAttribute(String name) {
        return (String)this.attributeMap.get(name);
    }

    public void setGuid(String guid) {
        this.attributeMap.put(LINK_ATTR_GUID, guid);
    }

    private void setUrl(String url) {
        this.attributeMap.put(LINK_ATTR_HREF, url);
    }

    private void validateElementUrl(MethodConfiguration config) {
        String guid = this.getGuid();
        if (guid != null) {
            MethodElement e = null;
            ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
            if (manager != null) {
                e = manager.getMethodElement(guid);
            }
            if (e instanceof ProcessComponent) {
                e = ((ProcessComponent)e).getProcess();
            }
            if (e instanceof MethodPackage || e instanceof MethodConfiguration || e instanceof MethodLibrary) {
                e = null;
                this.setUrl(null);
                return;
            }
            if (e != null) {
                if (config != null) {
                    MethodElement e1 = ConfigurationHelper.getCalculatedElement(e, config);
                    if (e1 != null) {
                        e = e1;
                    } else {
                        this.isMissingReference = true;
                        this.validator.logMissingReference(this.ownerElement, e);
                    }
                }
            } else {
                this.isMissingReference = true;
                this.validator.logMissingReference(this.ownerElement, guid, this.linkedText);
            }
            if (e != null) {
                String text;
                guid = e.getGuid();
                this.setGuid(guid);
                String url = this.getUrl();
                if (url != null && !(url = url.trim()).toLowerCase().startsWith("javascript:")) {
                    url = ResourceHelper.getUrl(e, this.ownerElement, ".html", url);
                    this.setUrl(url);
                }
                if (this.isElementLink() && (text = ResourceHelper.getLinkText(e, this.getElementLinkType())) != null) {
                    this.linkedText = text;
                }
                if (this.validator.isDiscarded(this.ownerElement, null, e)) {
                    this.isMissingReference = true;
                    this.validator.logMissingReference(this.ownerElement, e);
                    e = null;
                }
            }
            this.linkElement = e;
        }
    }

    private String getMissingElementUrl() {
        if (!this.isMissingReference) {
            return "";
        }
        String url = null;
        url = "pages_not_installed/pages_not_installed.html";
        File f = new File(this.pubDir, url);
        File dir = f.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        XmlElement xml = new XmlElement("Element");
        if (this.linkElement == null) {
            xml.setAttribute("invalidLink", "true").setAttribute(LINK_ATTR_GUID, this.getGuid()).setAttribute(LINK_ATTR_NAME, this.linkedText);
        } else {
            xml.setAttribute(LINK_ATTR_GUID, this.getGuid()).setAttribute("type", this.linkElement.getType().getName()).setAttribute(LINK_ATTR_NAME, this.linkElement.getName()).setAttribute("pluginName", LibraryUtil.getMethodPlugin((EObject)this.linkElement).getName());
        }
        String xslPath = LayoutResources.getXslUri("page_not_installed", null);
        this.saveHtml(xml, xslPath, f);
        return String.valueOf(ResourceHelper.getBackPath(this.ownerElement).replace(File.separatorChar, '/')) + url;
    }

    public void saveHtml(XmlElement xmlElement, String xsl_uri, File outputFile) {
        try {
            StringBuffer xml = new StringBuffer();
            xml.append(XmlHelper.XML_HEADER).append(xmlElement.toXml());
            OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "utf-8");
            Properties xslParams = LibraryPlugin.getDefault().getProperties("/layout/xsl/resources.properties");
            XSLTProcessor.transform((String)xsl_uri, (String)xml.toString(), (Properties)xslParams, (Writer)output);
            output.flush();
            output.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

