/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.services;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epf.library.services.ElementReference;
import org.eclipse.epf.library.services.VariabilityElementReference;
import org.eclipse.epf.library.util.LibraryUtil;

public class PackageReference
extends ElementReference {
    private List refList = new ArrayList();

    public PackageReference(Object element, Object refElement) {
        super(element, refElement);
    }

    public void addReference(ElementReference ref) {
        this.refList.add(ref);
    }

    public List getReferences() {
        return this.refList;
    }

    public boolean hasReference(Object element, Object refElement) {
        Iterator it = this.refList.iterator();
        while (it.hasNext()) {
            ElementReference ref = (ElementReference)it.next();
            if (ref.getElement() != element || ref.getRefElement() != refElement) continue;
            return true;
        }
        return false;
    }

    public boolean hasBaseReference() {
        Iterator it = this.refList.iterator();
        while (it.hasNext()) {
            ElementReference ref = (ElementReference)it.next();
            if (!(ref instanceof VariabilityElementReference)) continue;
            return true;
        }
        return false;
    }

    public void removeReference(Object ownerElement) {
        int i = 0;
        while (i < this.refList.size()) {
            ElementReference ref = (ElementReference)this.refList.get(i);
            Object e = ref.getElement();
            if (e != null && e == ownerElement) {
                this.refList.remove(i);
                continue;
            }
            ++i;
        }
    }

    public void print() {
        System.out.println(String.valueOf(LibraryUtil.getName(this.element)) + " --> " + LibraryUtil.getName(this.refElement));
        Iterator it = this.refList.iterator();
        while (it.hasNext()) {
            ((ElementReference)it.next()).print();
        }
        System.out.println();
    }

    public boolean canIgnore() {
        List refs = this.getReferences();
        if (refs.size() == 0) {
            return true;
        }
        Iterator it = refs.iterator();
        while (it.hasNext()) {
            ElementReference ref = (ElementReference)it.next();
            if (ref.canIgnore()) continue;
            return false;
        }
        return true;
    }
}

