/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.actions;

import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextEditor;
import org.eclipse.epf.richtext.RichTextImages;
import org.eclipse.epf.richtext.RichTextPlugin;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.actions.RichTextAction;
import org.eclipse.epf.richtext.dialogs.FindReplaceDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class FindReplaceAction
extends RichTextAction {
    public static final int FIND_TEXT = 1;
    public static final int REPLACE_TEXT = 2;
    public static final int REPLACE_FIND_TEXT = 3;
    public static final int REPLACE_ALL_TEXT = 4;
    public static final int FORWARD_MATCH = 1;
    public static final int BACKWARD_MATCH = -1;
    public static final int WHOLE_WORD_MATCH = 2;
    public static final int CASE_SENSITIVE_MATCH = 4;
    private static final String ENCODED_SINGLE_QUOTE = "%sq%";
    private IRichText richText;
    private StyledText styledText;
    protected boolean foundMatch = false;

    public FindReplaceAction() {
        this.setImage(RichTextImages.IMG_FIND_REPLACE);
        this.setDisabledImage(RichTextImages.DISABLED_IMG_FIND_REPLACE);
        this.setToolTipText(RichTextResources.findReplaceAction_toolTipText);
        this.setEnabled(true);
    }

    public boolean disableInReadOnlyMode() {
        return false;
    }

    public boolean disableInSourceMode() {
        return false;
    }

    public void execute(IRichText richText) {
        this.richText = richText;
        if (richText != null) {
            try {
                if (richText instanceof RichTextEditor && ((RichTextEditor)richText).isHTMLTabSelected()) {
                    this.styledText = ((RichTextEditor)richText).getSourceEdit();
                }
                FindReplaceDialog dialog = new FindReplaceDialog(Display.getCurrent().getActiveShell(), this, !richText.getEditable());
                dialog.open();
            }
            catch (Exception e) {
                RichTextPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
    }

    public boolean getFoundMatch() {
        return this.foundMatch;
    }

    public void run(int subAction, String findText, String replaceText, int matchDir, int matchOptions) {
        if (this.styledText == null) {
            if (findText.indexOf("'") != -1) {
                findText = findText.replaceAll("'", ENCODED_SINGLE_QUOTE);
            }
            if (replaceText.indexOf("'") != -1) {
                replaceText = replaceText.replaceAll("'", ENCODED_SINGLE_QUOTE);
            }
        }
        try {
            this.foundMatch = false;
            int status = 0;
            switch (subAction) {
                case 1: {
                    status = this.findText(findText, matchDir, matchOptions);
                    break;
                }
                case 2: {
                    status = this.replaceText(replaceText, matchDir, matchOptions);
                    break;
                }
                case 3: {
                    status = this.replaceFindText(findText, replaceText, matchDir, matchOptions);
                    break;
                }
                case 4: {
                    this.replaceAll(findText, replaceText, matchOptions);
                }
            }
            if (status > 0) {
                this.foundMatch = true;
            }
        }
        catch (Exception e) {
            RichTextPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    private static String escape(String text) {
        if (text == null || text.length() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int textSize = text.length();
        int i = 0;
        while (i < textSize) {
            char ch = text.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private int findText(String findText, int matchDir, int matchOptions) {
        int status = 0;
        status = this.styledText != null ? this.styledTextFindTextAndSelect(findText, matchDir, matchOptions) : this.richText.executeCommand("findText", new String[]{findText, "" + matchDir, "" + matchOptions});
        return status;
    }

    private int replaceText(String replaceText, int matchDir, int matchOptions) {
        int status = 0;
        status = this.styledText != null ? this.styledTextReplaceTextAndSelect(replaceText) : this.richText.executeCommand("replaceText", new String[]{replaceText, "" + matchDir, "" + matchOptions});
        return status;
    }

    private int replaceFindText(String findText, String replaceText, int matchDir, int matchOptions) {
        int status = 0;
        if (this.styledText != null) {
            this.styledTextReplaceTextAndSelect(replaceText);
            status = this.styledTextFindTextAndSelect(findText, matchDir, matchOptions);
        } else {
            this.richText.executeCommand("replaceText", new String[]{replaceText, "" + matchDir, "" + matchOptions});
            status = this.richText.executeCommand("findText", new String[]{findText, "" + matchDir, "" + matchOptions});
        }
        return status;
    }

    private void replaceAll(String findText, String replaceText, int matchOptions) {
        if (this.styledText != null) {
            this.styledTextReplaceAll(findText, replaceText, matchOptions);
        } else {
            this.richText.executeCommand("replaceAllText", new String[]{FindReplaceAction.escape(findText), FindReplaceAction.escape(replaceText), "" + matchOptions});
        }
    }

    private int styledTextFindTextAndSelect(String findText, int matchDir, int matchOptions) {
        Point selectionOffset = this.styledText.getSelectionRange();
        int firstSelectedOffset = selectionOffset.x;
        int lastSelectedOffset = selectionOffset.x + selectionOffset.y - 1;
        String htmlText = this.styledText.getText();
        int indexOfMatch = -1;
        if ((matchOptions & 4) == 0) {
            htmlText = htmlText.toUpperCase();
            findText = findText.toUpperCase();
        }
        do {
            if (indexOfMatch == -1) continue;
            lastSelectedOffset = indexOfMatch + 1;
            firstSelectedOffset = indexOfMatch - 1;
        } while ((indexOfMatch = matchDir == 1 ? htmlText.indexOf(findText, lastSelectedOffset + 1) : htmlText.lastIndexOf(findText, firstSelectedOffset - 1)) != -1 && (matchOptions & 2) == 2 && this.isPartOfWord(htmlText, indexOfMatch, findText.length()));
        if (indexOfMatch != -1) {
            this.styledText.setSelectionRange(indexOfMatch, findText.length());
            this.styledTextScrollToPosition(indexOfMatch);
        } else {
            String selectedText = this.styledText.getSelectionText();
            if ((matchOptions & 4) == 0) {
                selectedText = selectedText.toUpperCase();
            }
            if (selectedText.equals(findText)) {
                indexOfMatch = this.styledText.getSelectionRange().x;
            }
        }
        return indexOfMatch;
    }

    private int styledTextReplaceTextAndSelect(String replaceText) {
        Point selectionOffset = this.styledText.getSelectionRange();
        this.styledText.replaceTextRange(selectionOffset.x, selectionOffset.y, replaceText);
        this.styledText.setSelectionRange(selectionOffset.x, replaceText.length());
        return 1;
    }

    private void styledTextReplaceAll(String findText, String replaceText, int matchOptions) {
        this.styledText.setSelectionRange(0, 0);
        while (this.styledTextFindTextAndSelect(findText, 1, matchOptions) != -1) {
            this.styledTextReplaceTextAndSelect(replaceText);
        }
    }

    private boolean isWordChar(char c) {
        return Character.isLetterOrDigit(c);
    }

    private boolean isPartOfWord(String text, int index, int length) {
        if (index > 0 && this.isWordChar(text.charAt(index - 1))) {
            return true;
        }
        return text.length() >= index + length && this.isWordChar(text.charAt(index + length));
    }

    private void styledTextScrollToPosition(int index) {
        int selectionStartLine = this.styledText.getLineAtOffset(index);
        int numLinesShown = this.styledText.getLineHeight() != 0 ? this.styledText.getClientArea().height / this.styledText.getLineHeight() : 1;
        this.styledText.setTopIndex(selectionStartLine - numLinesShown / 2);
    }
}

