/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ChangeHistoryDialog
extends Dialog {
    protected Button okButton;
    protected Button cancelButton;
    private MethodElement element;
    private Table table;

    public ChangeHistoryDialog(Shell parent, MethodElement element) {
        super(parent);
        this.element = element;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)dialogArea.getLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 1;
        GridData gd = (GridData)dialogArea.getLayoutData();
        gd.verticalIndent = 10;
        Label label = new Label(dialogArea, 0);
        label.setText(AuthoringUIResources.ChangeHistoryDialog_label);
        this.table = new Table(dialogArea, 2050);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 400;
        gridData.heightHint = 300;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.initChangeHistoryTable();
        super.getShell().setText(AuthoringUIResources.ChangeHistoryDialog_title);
        return dialogArea;
    }

    private void initChangeHistoryTable() {
        String changeDesc = null;
        if (this.element instanceof ContentElement) {
            ContentDescription contentDescription = ((ContentElement)this.element).getPresentation();
            changeDesc = contentDescription.getChangeDescription();
        }
        if (this.element instanceof MethodPlugin) {
            changeDesc = ((MethodPlugin)this.element).getChangeDescription();
        }
        if (changeDesc != null) {
            StringTokenizer tok = new StringTokenizer(changeDesc, AuthoringUIResources.ChangeHistoryDialog_delimiter);
            ArrayList<String> strList = new ArrayList<String>();
            while (tok.hasMoreTokens()) {
                strList.add(tok.nextToken());
            }
            int i = strList.size() - 1;
            while (i >= 0) {
                TableItem item = new TableItem(this.table, 0);
                item.setText((String)strList.get(i));
                --i;
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton = super.getButton(0);
    }

    protected void okPressed() {
        super.okPressed();
    }
}

