/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.filters.CategoryFilter;
import org.eclipse.epf.authoring.ui.filters.CustomCategoryFilter;
import org.eclipse.epf.authoring.ui.forms.AssociationFormPage;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.util.LibraryManager;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;

public class TaskCategoriesPage
extends AssociationFormPage {
    private static final String FORM_PAGE_ID = "taskCategoriesPage";
    private Task task;

    public TaskCategoriesPage(FormEditor editor) {
        super(editor, FORM_PAGE_ID, AuthoringUIText.CATEGORIES_PAGE_TITLE);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.task = (Task)this.contentElement;
        this.setAllowChange1(true);
        this.setAllowChange2(true);
        this.setUseCategory3(false);
    }

    protected void initContentProviderSelected() {
        this.contentProviderSelected = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return AssociationHelper.getDisciplines((Task)((Task)object)).toArray();
            }
        };
        this.viewer_selected.setContentProvider((IContentProvider)this.contentProviderSelected);
    }

    protected void addItemsToModel1(ArrayList addItems) {
        if (!addItems.isEmpty()) {
            Iterator iterator = addItems.iterator();
            while (iterator.hasNext()) {
                Object discipline = iterator.next();
                if (!(discipline instanceof Discipline)) continue;
                LibraryManager.getInstance().addToDiscipline(this.getActionManager(), (Discipline)discipline, this.task);
                if (!this.usedCategories.contains(discipline)) continue;
                this.usedCategories.remove(discipline);
            }
        }
    }

    protected void removeItemsFromModel1(ArrayList rmItems) {
        if (!rmItems.isEmpty()) {
            Iterator it = rmItems.iterator();
            while (it.hasNext()) {
                Discipline discipline = (Discipline)it.next();
                LibraryManager.getInstance().removeFromDiscipline(this.getActionManager(), discipline, this.task);
                if (this.usedCategories.contains(discipline)) continue;
                this.usedCategories.add(discipline);
            }
        }
    }

    protected void initContentProviderSelected2() {
        this.contentProviderSelected2 = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return AssociationHelper.getCustomCategories((DescribableElement)((Task)object)).toArray();
            }
        };
        this.viewer_selected2.setContentProvider((IContentProvider)this.contentProviderSelected2);
    }

    protected void addItemsToModel2(ArrayList addItems) {
        if (!addItems.isEmpty()) {
            Iterator it = addItems.iterator();
            while (it.hasNext()) {
                CustomCategory customCategory = (CustomCategory)it.next();
                LibraryManager.getInstance().addToCustomCategory(this.getActionManager(), customCategory, (MethodElement)this.task);
                if (!this.usedCategories.contains(customCategory)) continue;
                this.usedCategories.remove(customCategory);
            }
        }
    }

    protected void removeItemsFromModel2(ArrayList rmItems) {
        if (!rmItems.isEmpty()) {
            Iterator it = rmItems.iterator();
            while (it.hasNext()) {
                CustomCategory customCategory = (CustomCategory)it.next();
                LibraryManager.getInstance().removeFromCustomCategory(this.getActionManager(), customCategory, (MethodElement)this.task);
                if (this.usedCategories.contains(customCategory)) continue;
                this.usedCategories.add(customCategory);
            }
        }
    }

    protected Object getContentElement() {
        return this.task;
    }

    protected String getTabString() {
        return FilterConstants.DISCIPLINES;
    }

    protected String getTabString2() {
        return FilterConstants.CUSTOM_CATEGORIES;
    }

    protected IFilter getFilter() {
        this.filter = new CategoryFilter(){

            protected boolean childAccept(Object obj) {
                return obj instanceof Discipline;
            }
        };
        return this.filter;
    }

    protected IFilter getFilter2() {
        this.filter2 = new CustomCategoryFilter();
        return this.filter2;
    }

    protected String getSectionDescription() {
        return AuthoringUIResources.taskCategoriesPage_sectionDescription;
    }

    protected String getSectionName() {
        return AuthoringUIResources.taskCategoriesPage_sectionName;
    }

    protected String getSelectedLabel() {
        return AuthoringUIResources.taskCategoriesPage_selectedLabel;
    }

    protected String getSelectedLabel2() {
        return AuthoringUIResources.taskCategoriesPage_selectedLabel2;
    }
}

