/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.epf.library.configuration.ErrorInfo;

public class ElementDependencyError {
    private Object errorElement;
    private Map errorInfoMap = new HashMap();
    private int errorBits = 0;

    public ElementDependencyError(Object element) {
        this.errorElement = element;
    }

    public Object getErrorElement() {
        return this.errorElement;
    }

    public Object[] getCauseElements() {
        return this.errorInfoMap.keySet().toArray();
    }

    public int size() {
        return this.errorInfoMap.size();
    }

    public void addError(ErrorInfo errorInfo) {
        this.errorInfoMap.put(errorInfo.getCauseElement(), errorInfo);
        this.errorBits |= errorInfo.getErrorType();
    }

    public void removeError(Object causeElement) {
        this.errorInfoMap.remove(causeElement);
        this.calculateErrorBits();
    }

    public ErrorInfo getError(Object causeElement) {
        return (ErrorInfo)this.errorInfoMap.get(causeElement);
    }

    public List getAll() {
        return new ArrayList(this.errorInfoMap.values());
    }

    public boolean isError() {
        return (this.errorBits & 1) > 0;
    }

    public boolean isWarning() {
        return (this.errorBits & 2) > 0;
    }

    public boolean isChildError() {
        return (this.errorBits & 4) > 0;
    }

    public boolean isChildWarning() {
        return (this.errorBits & 8) > 0;
    }

    private void calculateErrorBits() {
        this.errorBits = 0;
        Iterator it = this.errorInfoMap.values().iterator();
        while (it.hasNext()) {
            this.errorBits |= ((ErrorInfo)it.next()).getErrorType();
        }
    }
}

