/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search.analysis;

import com.ibm.icu.text.BreakIterator;
import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;

public final class TextTokenizer
extends Tokenizer {
    private static final int BUFFER_SIZE = 4096;
    private String text;
    private BreakIterator iterator;

    public TextTokenizer(Reader reader) {
        super(reader);
        StringBuffer textBuffer = new StringBuffer(4096);
        char[] buffer = new char[4096];
        try {
            int charsRead;
            while ((charsRead = reader.read(buffer, 0, 4096)) > 0) {
                textBuffer.append(buffer, 0, charsRead);
            }
            this.text = textBuffer.toString();
            this.iterator = BreakIterator.getWordInstance();
            this.iterator.setText(this.text);
        }
        catch (IOException iOException) {
            this.iterator = null;
        }
    }

    public final Token next() throws IOException {
        if (this.iterator != null) {
            block3: {
                int end;
                int start;
                String tokenText;
                do {
                    start = this.iterator.current();
                    end = this.iterator.next();
                    if (end == -1) break block3;
                } while ((tokenText = this.text.substring(start, end).toLowerCase()).equals(" "));
                if (tokenText.endsWith("'s")) {
                    tokenText = tokenText.substring(0, tokenText.length() - 2);
                }
                return new Token(tokenText, 0, tokenText.length());
            }
            return null;
        }
        return null;
    }
}

