/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.html;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.epf.common.utils.FileUtil;
import org.w3c.tidy.Tidy;

public class HTMLFormatter {
    private static final String HTML_BODY_START_TAG = "<body>";
    private static final String HTML_BODY_END_TAG = "</body>";
    private static final int HTML_BODY_START_TAG_LENGTH = "<body>".length();
    private static final String HTML_COPY = "&copy;";
    private static final String HTML_EURO = "&euro;";
    private static final String HTML_REG = "&reg;";
    private static final String HTML_TRADEMARK = "&trade;";
    private int lineWidth;
    private boolean indent;
    private int indentSize;
    public static final String PRE_TAG_START = "<pre>";
    public static final String PRE_TAG_END = "</pre>";
    public static final int PRE_TAG_END_LENGTH = "</pre>".length();

    public HTMLFormatter() {
        this(132, true, 4);
    }

    public HTMLFormatter(int lineWidth, boolean indent, int indentSize) {
        this.lineWidth = lineWidth;
        this.indent = indent;
        this.indentSize = indentSize;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public void setIndentSize(int indentSize) {
        this.indentSize = indentSize;
    }

    public String formatHTML(String html) throws Exception {
        if (html == null || html.length() == 0) {
            return html;
        }
        Tidy tidy = new Tidy();
        tidy.setXHTML(true);
        tidy.setDropEmptyParas(false);
        tidy.setDropFontTags(false);
        tidy.setQuiet(true);
        tidy.setShowWarnings(false);
        tidy.setSmartIndent(false);
        tidy.setTidyMark(false);
        tidy.setWraplen(this.lineWidth);
        tidy.setIndentAttributes(false);
        tidy.setIndentContent(this.indent);
        tidy.setSpaces(this.indentSize);
        tidy.setCharEncoding(3);
        ByteArrayInputStream input = new ByteArrayInputStream(html.getBytes("UTF-8"));
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tidy.setErrout(pw);
        tidy.parse((InputStream)input, (OutputStream)output);
        String error = sw.getBuffer().toString();
        if (error != null && error.length() > 0 && error.startsWith("line") && error.indexOf("column") > 0) {
            throw new Exception(error);
        }
        String formattedHTML = new String(output.toByteArray(), "UTF-8");
        formattedHTML = HTMLFormatter.escapeHTML(formattedHTML);
        if (!html.startsWith("<!DOCTYPE") && !html.startsWith("<html")) {
            int start = formattedHTML.indexOf(HTML_BODY_START_TAG);
            int end = formattedHTML.indexOf(HTML_BODY_END_TAG);
            if (start == -1 || end == -1) {
                return "";
            }
            if ((start += HTML_BODY_START_TAG_LENGTH) >= end) {
                return "";
            }
            start += FileUtil.LINE_SEP_LENGTH;
            end -= FileUtil.LINE_SEP_LENGTH;
            if (this.indent && this.indentSize > 0) {
                end -= this.indentSize;
            }
            if (start >= end) {
                return "";
            }
            String result = formattedHTML.substring(start, end);
            if (this.indent && this.indentSize > 0) {
                String indentStr = HTMLFormatter.getIndentStr(this.indentSize * 2);
                result = HTMLFormatter.fixIndentation(result, indentStr);
                return result;
            }
        }
        return formattedHTML;
    }

    private static String getIndentStr(int indentLength) {
        if (indentLength == 0) {
            return "";
        }
        StringBuffer indentStr = new StringBuffer();
        int i = 0;
        while (i < indentLength) {
            indentStr.append(' ');
            ++i;
        }
        return indentStr.toString();
    }

    private static String escapeHTML(String html) {
        if (html == null || html.length() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int len = html.length();
        int i = 0;
        while (i < len) {
            char ch = html.charAt(i);
            switch (ch) {
                case '\u00a9': {
                    sb.append(HTML_COPY);
                    break;
                }
                case '\u00ae': {
                    sb.append(HTML_REG);
                    break;
                }
                case '\u20ac': {
                    sb.append(HTML_EURO);
                    break;
                }
                case '\u2122': {
                    sb.append(HTML_TRADEMARK);
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private static String fixIndentation(String html, String indentStr) {
        if (html.startsWith(indentStr)) {
            html = html.substring(indentStr.length());
        }
        StringBuffer strBuf = new StringBuffer();
        int pre_index = -1;
        int last_pre_end_index = -1;
        while ((pre_index = html.indexOf(PRE_TAG_START, last_pre_end_index)) != -1) {
            strBuf.append(html.substring(last_pre_end_index < 0 ? 0 : last_pre_end_index + PRE_TAG_END_LENGTH, pre_index).replaceAll("\r\n" + indentStr, "\r\n"));
            last_pre_end_index = html.indexOf(PRE_TAG_END, pre_index);
            if (last_pre_end_index != -1) {
                strBuf.append(html.substring(pre_index, last_pre_end_index + PRE_TAG_END_LENGTH));
                continue;
            }
            strBuf.append(html.substring(pre_index));
            return strBuf.toString();
        }
        strBuf.append(html.substring(last_pre_end_index < 0 ? 0 : last_pre_end_index + PRE_TAG_END_LENGTH).replaceAll("\r\n" + indentStr, "\r\n"));
        return strBuf.toString();
    }
}

