/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.services;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.export.ExportPlugin;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.export.services.ConfigurationExportData;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryManagerFactory;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.configuration.ConfigurationClosure;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;

public class ConfigurationExportService {
    public static String excludes = ".copyarea.dat, **/.copyarea.dat, .copyarea.db, **/.copyarea.db";
    private ConfigurationExportData data;

    public ConfigurationExportService(ConfigurationExportData data) {
        this.data = data;
    }

    public void run(IProgressMonitor monitor) {
        try {
            if (this.data.selectedConfigs == null || this.data.selectedConfigs.size() == 0) {
                return;
            }
            monitor.setTaskName(ExportResources.ConfigurationExportService_MSG0);
            String exportLibPath = this.data.llData.getParentFolder();
            File exportLibFolder = new File(exportLibPath);
            if (!exportLibFolder.exists()) {
                exportLibFolder.mkdir();
            }
            MethodConfiguration config = (MethodConfiguration)this.data.selectedConfigs.get(0);
            this.exportConfig(config.getName(), exportLibFolder.getAbsolutePath(), monitor);
        }
        catch (Exception e) {
            ExportPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public void exportConfig(String selectedConfigName, String filePath, IProgressMonitor monitor) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 54->58)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void doEexportConfig(String selectedConfigName, String filePath, IProgressMonitor monitor) throws Exception {
        MethodLibrary currentLib = LibraryService.getInstance().getCurrentMethodLibrary();
        try {
            LibraryUtil.loadAll((MethodLibrary)currentLib);
        }
        catch (Throwable e) {
            ExportPlugin.getDefault().getLogger().logError("Error loading library", e);
            this.data.errorMsg = ExportResources.ConfigurationExportService_MSG2;
            return;
        }
        MethodLibrary newLibrary = null;
        try {
            newLibrary = (MethodLibrary)EcoreUtil.copy((EObject)currentLib);
        }
        catch (Throwable e) {
            ExportPlugin.getDefault().getLogger().logError(e);
            this.data.errorMsg = ExportResources.ConfigurationExportService_MSG4;
            return;
        }
        ConfigurationClosure closure = null;
        ILibraryManager libMgr = null;
        try {
            LibraryUtil.detachFromResource((MethodLibrary)newLibrary);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("library.path", filePath);
            String name = "library.xmi";
            String type = "xmi";
            libMgr = LibraryManagerFactory.getInstance().createLibraryManager(type);
            libMgr.createMethodLibrary(name, params);
            libMgr.setMethodLibrary(newLibrary);
            LibraryService.getInstance().setLibraryManager(libMgr);
            MethodConfiguration config = LibraryServiceUtil.getMethodConfiguration((MethodLibrary)newLibrary, (String)selectedConfigName);
            LibraryUtil.validateMethodConfiguration((MethodConfiguration)config);
            closure = new ConfigurationClosure(config);
            closure.packageLibrary(this.data.removeBrokenReferences);
        }
        catch (Throwable e) {
            ExportPlugin.getDefault().getLogger().logError("Error making library configuration closure", e);
            this.data.errorMsg = ExportResources.ConfigurationExportService_MSG1;
            if (closure != null) {
                closure.dispose();
            }
            if (libMgr != null) {
                LibraryService.getInstance().removeLibraryManager(libMgr);
                libMgr.closeMethodLibrary();
                libMgr.dispose();
            }
            return;
        }
        try {
            LibraryUtil.saveAll((MethodLibrary)newLibrary);
            LibraryUtil.saveAll((MethodLibrary)newLibrary);
        }
        catch (Throwable e) {
            ExportPlugin.getDefault().getLogger().logError("Error saving library", e);
            this.data.errorMsg = ExportResources.ConfigurationExportService_MSG9;
            if (closure != null) {
                closure.dispose();
            }
            if (libMgr != null) {
                LibraryService.getInstance().removeLibraryManager(libMgr);
                libMgr.closeMethodLibrary();
                libMgr.dispose();
            }
            return;
        }
        String includes = "resources/**, **/resources/**";
        File srcDir = LibraryUtil.getLibraryRootPath((MethodLibrary)currentLib);
        File destDir = LibraryUtil.getLibraryRootPath((MethodLibrary)newLibrary);
        LayoutResources.copyDir((File)srcDir, (File)destDir, (String)includes, (String)excludes);
        if (closure != null) {
            closure.dispose();
        }
        if (libMgr != null) {
            LibraryService.getInstance().removeLibraryManager(libMgr);
            libMgr.closeMethodLibrary();
            libMgr.dispose();
        }
    }
}

