/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.common.utils.Timer;
import org.eclipse.epf.library.configuration.ConfigurationFilter;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.layout.HtmlBuilder;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.elements.ActivityLayout;
import org.eclipse.epf.library.layout.elements.ProcessElementItem;
import org.eclipse.epf.library.layout.elements.ProcessLayoutData;
import org.eclipse.epf.library.layout.elements.SummaryPageLayout;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.publishing.PublishingResources;
import org.eclipse.epf.publishing.layout.Bookmark;
import org.eclipse.epf.publishing.services.AbstractViewBuilder;
import org.eclipse.epf.publishing.services.DefaultNodeIconResources;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.util.PublishingUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.Tool;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.util.AssociationHelper;

public class ConfigurationViewBuilder
extends AbstractViewBuilder {
    private static final String PREFIX_Reference_Workflows = "Reference_Workflows";
    private static final String PREFIX_Tasks = "Tasks";
    private static final String PREFIX_ResponsibleFor_Tasks = "Primarily_Performs";
    private static final String PREFIX_ParticipatesIn_Tasks = "Additionally_Performs";
    private static final String PREFIX_Performing_Roles = "Performing_Roles";
    private static final String PREFIX_Input_Work_Products = "Input_Work_Products";
    private static final String PREFIX_Output_Work_Products = "Output_Work_Products";
    private static final String PREFIX_Work_Products_Created = "Responsible_For";
    private static final String PREFIX_Work_Products_Modified = "Modifies";
    private static final String PREFIX_Responsible_Role = "Responsible_Role";
    private static final String PREFIX_Containing_Work_Product = "Containing_Work_Product";
    private static final String PREFIX_Contained_Work_Products = "Contained_Work_Products";
    private static final String PREFIX_Guidances = "Guidance";
    private static final String PREFIX_InputTo_Task = "Input_to";
    private static final String PREFIX_OutputOf_Task = "Output_from";
    private static final String ICON_FOLDER = DefaultNodeIconResources.getIconName("folder");
    private static final String NODE_Reference_Workflows = PublishingResources.referenceWorkflowsNode_text;
    private static final String NODE_Tasks = PublishingResources.taskNode_text;
    private static final String NODE_ResponsibleFor_Tasks = PublishingResources.primarilyPerformsNode_text;
    private static final String NODE_ParticipatesIn_Tasks = PublishingResources.additionallyPerformsNode_text;
    private static final String NODE_Performing_Roles = PublishingResources.performingRolesNode_text;
    private static final String NODE_Input_Work_Products = PublishingResources.inputWorkProductsNode_text;
    private static final String NODE_Output_Work_Products = PublishingResources.outputWorkProductsNode_text;
    private static final String NODE_Work_Products_Created = PublishingResources.responsibleForNode_text;
    private static final String NODE_Work_Products_Modified = PublishingResources.modifiesNode_text;
    private static final String NODE_Responsible_Role = PublishingResources.responsibleRoleNode_text;
    private static final String NODE_Containing_Work_Product = PublishingResources.containingWorkProductNode_text;
    private static final String NODE_Contained_Work_Products = PublishingResources.containedWorkProductsNode_text;
    private static final String NODE_Guidances = PublishingResources.guidanceNode_text;
    private static final String NODE_InputTo_Task = PublishingResources.inputToNode_text;
    private static final String NODE_OutputOf_Task = PublishingResources.outputFromNode_text;
    List bookmarks = new ArrayList();
    AdapterFactory adapterFactory;
    private static final Class ITreeItemContentProviderClass;
    protected IProgressMonitor monitor = null;
    protected EObjectComparator nameComparator = new EObjectComparator();
    protected Set elementUrls = new HashSet();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeItemContentProviderClass = clazz;
    }

    public ConfigurationViewBuilder(HtmlBuilder builder, PublishOptions options) {
        super(builder, options);
    }

    public List buildViews(IProgressMonitor monitor) {
        this.monitor = monitor;
        if (this.config != null) {
            monitor.subTask(PublishingResources.loadLibraryTask_name);
            LibraryUtil.loadAll((MethodLibrary)((MethodLibrary)this.config.eContainer()));
            ConfigurationFilter configFilter = new ConfigurationFilter(this.config, null);
            this.adapterFactory = TngAdapterFactory.INSTANCE.getConfigurationView_AdapterFactory((IFilter)configFilter);
            if (this.options != null && this.options.isPublishProcess()) {
                this.makeProcessClosure();
            }
            List views = this.config.getProcessViews();
            Iterator it = views.iterator();
            while (it.hasNext()) {
                if (monitor.isCanceled()) {
                    return null;
                }
                ContentCategory v = (ContentCategory)it.next();
                if (!ConfigurationHelper.canShow((MethodElement)v, (MethodConfiguration)this.config)) continue;
                Object element = LibraryUtil.unwrap((Object)v);
                Bookmark b = this.createBookmark(this.monitor, element);
                if (v == this.config.getDefaultView()) {
                    this.defaultView = b;
                }
                this.iterate(v, b);
                if (b.getChildCount() <= 0) continue;
                this.bookmarks.add(b);
            }
            if (monitor.isCanceled()) {
                return null;
            }
        }
        this.publishReferenceElements();
        this.copyIconsForNonApplet();
        if (monitor.isCanceled()) {
            return null;
        }
        this.saveElementUrls();
        return this.bookmarks;
    }

    private void makeProcessClosure() {
        MethodElement e;
        this.monitor.subTask(PublishingResources.buildingProcessClosureTask_name);
        List processes = this.options.getDeliverProcessList();
        if (processes != null && processes.size() > 0) {
            Iterator it = processes.iterator();
            while (it.hasNext()) {
                this.makeProcessClosure((Process)it.next());
                if (!this.monitor.isCanceled()) continue;
                return;
            }
        }
        this.getValidator().addClosureElements(this.getValidator().getPublishedElements());
        this.getValidator().addClosureElements(this.getValidator().getReferencedElements());
        ArrayList<MethodElement> refs = new ArrayList<MethodElement>(this.getValidator().getReferencedElements());
        Iterator it = refs.iterator();
        while (it.hasNext()) {
            e = (MethodElement)it.next();
            if (e instanceof ContentCategory) continue;
            super.publish(this.monitor, e);
            if (!LibraryUtil.isProcess((EObject)e)) continue;
            this.publishProcessLayout((Process)e);
        }
        refs.clear();
        it = this.getValidator().getReferencedElements().iterator();
        while (it.hasNext()) {
            e = (MethodElement)it.next();
            if (!(e instanceof Guidance)) continue;
            refs.add(e);
        }
        if (refs.size() > 0) {
            this.getValidator().addClosureElements(refs);
        }
        this.getValidator().makeElementClosure();
    }

    private void makeProcessClosure(Process proc) {
        Process baseProc;
        if (proc == null) {
            return;
        }
        if (ConfigurationHelper.canShow((MethodElement)proc, (MethodConfiguration)this.config)) {
            ActivityLayout l = new ActivityLayout();
            l.init(this.getLayoutMgr(), (MethodElement)proc, proc, null);
            l.findAllLinkedElements();
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        if (ConfigurationHelper.isExtender((VariabilityElement)proc) && ConfigurationHelper.inConfig((MethodElement)(baseProc = (Process)proc.getVariabilityBasedOnElement()), (MethodConfiguration)this.config)) {
            this.makeProcessClosure(baseProc);
        }
    }

    private void publishReferenceElements() {
        while (this.getValidator().getReferencedElements().size() > 0) {
            MethodElement e = (MethodElement)this.getValidator().getReferencedElements().remove(0);
            try {
                if (this.monitor.isCanceled()) {
                    return;
                }
                if (e instanceof MethodPlugin || e instanceof MethodPackage) continue;
                super.publish(this.monitor, e);
                if (!LibraryUtil.isProcess((EObject)e)) continue;
                this.publishProcessLayout((Process)e);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.getValidator().logError(e, "Error publishing element", ex);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void publishProcessLayout(final Process e) {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    ActivityLayout layout = new ActivityLayout();
                    layout.init(ConfigurationViewBuilder.this.getLayoutMgr(), (MethodElement)e, null, null);
                    ProcessLayoutData pd = new ProcessLayoutData(e.getGuid());
                    layout.loadLayoutData(pd);
                    ConfigurationViewBuilder.this.printLayoutScript(pd);
                }
                catch (Exception e1) {
                    ConfigurationViewBuilder.this.getValidator().logError((MethodElement)e, "Error publishing process specific layout data", e1);
                }
            }
        };
        Timer timer = new Timer();
        try {
            try {
                Thread t = new Thread(runnable);
                t.start();
                t.join(600000L);
                if (t.isAlive()) {
                    timer.stop();
                    this.getValidator().logInfo((MethodElement)e, "publishing process specific layout data takes " + timer.getTime() + " mini seconds already and is still not done yet ...");
                    timer.start();
                    t.join();
                }
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            timer.stop();
            this.getValidator().logInfo((MethodElement)e, String.valueOf(timer.getTotalTime()) + " mini seconds publishing process specific layout data");
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        timer.stop();
        this.getValidator().logInfo((MethodElement)e, String.valueOf(timer.getTotalTime()) + " mini seconds publishing process specific layout data");
    }

    /*
     * Exception decompiling
     */
    private void printLayoutScript(ProcessLayoutData data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 74->78)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void iterate(Object obj, Bookmark parent) {
        try {
            if (this.monitor.isCanceled()) {
                return;
            }
            ITreeItemContentProvider treeItemContentProvider = null;
            if (obj instanceof ITreeItemContentProvider) {
                treeItemContentProvider = (ITreeItemContentProvider)obj;
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                treeItemContentProvider = (ITreeItemContentProvider)this.adapterFactory.adapt(obj, (Object)clazz);
            }
            if (treeItemContentProvider != null) {
                Collection items = treeItemContentProvider.getChildren(obj);
                Iterator it = items.iterator();
                while (it.hasNext()) {
                    if (this.monitor.isCanceled()) {
                        return;
                    }
                    Object itorObj = it.next();
                    Object element = LibraryUtil.unwrap(itorObj);
                    if (element instanceof MethodElement) {
                        MethodElement me = (MethodElement)element;
                        try {
                            if (!ConfigurationHelper.canShow((MethodElement)me, (MethodConfiguration)this.config) || (me = ConfigurationHelper.getCalculatedElement((MethodElement)me, (ElementRealizer)this.getLayoutMgr().getElementRealizer())) == null) continue;
                            if (me instanceof Tool) {
                                this.buildToolSubTree((Tool)me, parent);
                                continue;
                            }
                            if (me instanceof Discipline) {
                                this.buildDisciplineSubTree((Discipline)me, parent);
                                continue;
                            }
                            if (me instanceof ContentCategory) {
                                ContentCategory cc = (ContentCategory)me;
                                Bookmark b = this.createBookmark(this.monitor, cc);
                                this.iterate(itorObj, b);
                                if (this.options.includeEmptyCategories || b.getChildCount() > 0) {
                                    parent.addChild(b);
                                    this.discardEmptyCategory(cc, false);
                                    continue;
                                }
                                this.discardEmptyCategory(cc, true);
                                continue;
                            }
                            Bookmark b = this.createBookmark(me, parent);
                            if (this.buildSubTree(itorObj, me, b)) continue;
                            this.iterate(itorObj, b);
                        }
                        catch (Exception e) {
                            String message = "Error building navigation tree for " + LibraryUtil.getTypeName((MethodElement)me);
                            this.builder.getValidator().logError(message, (Throwable)e);
                            e.printStackTrace();
                        }
                        continue;
                    }
                    this.iterate(itorObj, parent);
                }
            }
        }
        catch (Exception e) {
            String message = "Error building navigation tree";
            this.builder.getValidator().logError(message, (Throwable)e);
            e.printStackTrace();
        }
    }

    protected Bookmark createBookmark(Object element, Bookmark parent) {
        Bookmark b = this.createBookmark(this.monitor, element);
        if (parent == null) {
            this.bookmarks.add(b);
        } else {
            parent.addChild(b);
        }
        return b;
    }

    private boolean buildSubTree(Object obj, MethodElement element, Bookmark bm) {
        if (element instanceof Task) {
            this.buildTaskSubTree((Task)element, bm);
        } else if (element instanceof Role) {
            this.buildRoleSubTree((Role)element, bm);
        } else if (element instanceof WorkProduct) {
            this.buildWorkProductSubTree((WorkProduct)element, bm);
        } else if (LibraryUtil.isProcess((EObject)element)) {
            this.buildProcessSubTree(obj, (Process)element, bm);
        } else {
            return false;
        }
        return true;
    }

    private void buildItems(List elements, Bookmark bm) {
        this.buildItems(elements, bm, false);
    }

    private void buildItems(List elements, Bookmark bm, boolean buildSubTree) {
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            if (this.monitor.isCanceled()) {
                return;
            }
            MethodElement element = (MethodElement)it.next();
            if (ConfigurationHelper.isContainmentElement((Object)element) && ConfigurationHelper.isContainerInList((MethodElement)element, (List)elements, (MethodConfiguration)this.config)) continue;
            this.buildItem(element, bm, buildSubTree);
        }
    }

    private Bookmark buildItem(MethodElement element, Bookmark parent, boolean buildSubTree) {
        if (this.monitor.isCanceled()) {
            return null;
        }
        Bookmark b = null;
        MethodElement e = ConfigurationHelper.getCalculatedElement((MethodElement)element, (ElementRealizer)this.getLayoutMgr().getElementRealizer());
        if (this.canShow(e)) {
            b = this.createBookmark(this.monitor, e);
            if (b == null) {
                return b;
            }
            parent.addChild(b);
            if (buildSubTree && e instanceof Artifact) {
                this.buildContainedArtifactsSubTree((Artifact)e, b, true);
            }
        }
        return b;
    }

    private Bookmark createFolderBookmark(MethodElement element, Bookmark bm, String nodeName, List items, boolean createChildren) {
        Bookmark b = null;
        if (items.size() > 0) {
            SummaryPageLayout l = new SummaryPageLayout(this.builder.getLayoutManager(), element, nodeName, items);
            String url = l.getUrl();
            this.builder.generateHtml((IElementLayout)l);
            b = this.createBookmark(nodeName, nodeName, url, ICON_FOLDER, ICON_FOLDER);
            bm.addChild(b);
            if (createChildren) {
                this.buildItems(items, b);
            }
        }
        return b;
    }

    private Bookmark createFolderBookmark(MethodElement element, Bookmark bm, String prefixName, String nodeName, List items, boolean createChildren) {
        Bookmark b = null;
        if (items.size() > 0) {
            SummaryPageLayout l = new SummaryPageLayout(this.builder.getLayoutManager(), element, prefixName, nodeName, items);
            String url = l.getUrl();
            this.builder.generateHtml((IElementLayout)l);
            b = this.createBookmark(nodeName, nodeName, url, ICON_FOLDER, ICON_FOLDER);
            bm.addChild(b);
            if (createChildren) {
                this.buildItems(items, b);
            }
        }
        return b;
    }

    private Bookmark buildDisciplineSubTree(Discipline element, Bookmark parent) {
        ITreeItemContentProvider treeItemContentProvider;
        List items_workflow = this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getDiscipline_ReferenceWorkflows());
        ArrayList<MethodElement> items_task = new ArrayList<MethodElement>();
        ArrayList<MethodElement> item_subDisciplies = new ArrayList<MethodElement>();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((treeItemContentProvider = (ITreeItemContentProvider)this.adapterFactory.adapt((Notifier)element, (Object)clazz)) != null) {
            Collection items = treeItemContentProvider.getChildren((Object)element);
            Iterator it = items.iterator();
            while (it.hasNext()) {
                MethodElement d;
                if (this.monitor.isCanceled()) {
                    return null;
                }
                Object itorObj = it.next();
                Object e = LibraryUtil.unwrap(itorObj);
                if (e instanceof Task) {
                    MethodElement t = ConfigurationHelper.getCalculatedElement((MethodElement)((MethodElement)e), (ElementRealizer)this.getLayoutMgr().getElementRealizer());
                    if (t == null) continue;
                    items_task.add(t);
                    continue;
                }
                if (!(e instanceof Discipline) || (d = ConfigurationHelper.getCalculatedElement((MethodElement)((MethodElement)e), (ElementRealizer)this.getLayoutMgr().getElementRealizer())) == null) continue;
                item_subDisciplies.add(d);
            }
        }
        if (this.monitor.isCanceled()) {
            return null;
        }
        ArrayList items_guidance = new ArrayList();
        items_guidance.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Assets()));
        items_guidance.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Checklists()));
        items_guidance.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_ConceptsAndPapers()));
        items_guidance.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Examples()));
        items_guidance.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Guidelines()));
        items_guidance.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_SupportingMaterials()));
        if (!this.options.includeEmptyCategories && items_workflow.size() + items_task.size() + items_guidance.size() + item_subDisciplies.size() == 0) {
            this.discardEmptyCategory((ContentCategory)element, true);
            return null;
        }
        if (this.monitor.isCanceled()) {
            return null;
        }
        Bookmark bm = this.createBookmark(this.monitor, element);
        if (item_subDisciplies.size() > 0) {
            Iterator it = item_subDisciplies.iterator();
            while (it.hasNext()) {
                Discipline d = (Discipline)it.next();
                this.buildDisciplineSubTree(d, bm);
            }
        }
        if (this.options.generateLightWeightTree) {
            Collections.sort(items_workflow, this.nameComparator);
            Collections.sort(items_task, this.nameComparator);
            Collections.sort(items_guidance, this.nameComparator);
            this.buildItems(items_workflow, bm);
            this.buildItems(items_task, bm);
            this.buildItems(items_guidance, bm);
        } else {
            if (items_workflow.size() > 0) {
                Bookmark wfFolder = this.createFolderBookmark((MethodElement)element, bm, PREFIX_Reference_Workflows, NODE_Reference_Workflows, items_workflow, false);
                Iterator it = items_workflow.iterator();
                while (it.hasNext()) {
                    if (this.monitor.isCanceled()) {
                        return null;
                    }
                    Process proc = (Process)it.next();
                    Bookmark bmWorkflow = this.buildItem((MethodElement)proc, wfFolder, false);
                    this.buildProcessSubTree(proc, proc, bmWorkflow);
                }
            }
            if (this.monitor.isCanceled()) {
                return null;
            }
            if (items_task.size() > 0) {
                this.createFolderBookmark((MethodElement)element, bm, PREFIX_Tasks, NODE_Tasks, items_task, true);
            }
            if (this.monitor.isCanceled()) {
                return null;
            }
            if (items_guidance.size() > 0) {
                this.createFolderBookmark((MethodElement)element, bm, PREFIX_Guidances, NODE_Guidances, items_guidance, true);
            }
        }
        if (this.options.includeEmptyCategories || bm.getChildCount() > 0) {
            parent.addChild(bm);
            this.discardEmptyCategory((ContentCategory)element, false);
        } else {
            this.discardEmptyCategory((ContentCategory)element, true);
        }
        return bm;
    }

    private void buildToolSubTree(Tool element, Bookmark parent) {
        if (this.monitor.isCanceled()) {
            return;
        }
        List items = this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getTool_ToolMentors());
        if (this.options.includeEmptyCategories || items.size() > 0) {
            Bookmark b = this.createBookmark(element, parent);
            this.buildItems(items, b);
            this.discardEmptyCategory((ContentCategory)element, false);
        } else {
            this.discardEmptyCategory((ContentCategory)element, true);
        }
    }

    private void buildTaskSubTree(Task element, Bookmark bm) {
        ArrayList allItems = new ArrayList();
        List items = new ArrayList<Role>();
        Role r = (Role)this.calc01FeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getTask_PerformedBy());
        if (r != null) {
            items.add(r);
        }
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getTask_AdditionallyPerformedBy()));
        if (items.size() > 0) {
            if (this.options.generateLightWeightTree) {
                Collections.sort(items, this.nameComparator);
                allItems.addAll(items);
            } else {
                this.createFolderBookmark((MethodElement)element, bm, PREFIX_Performing_Roles, NODE_Performing_Roles, items, true);
            }
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        if (!this.options.generateLightWeightTree) {
            items = new ArrayList();
            items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getTask_MandatoryInput()));
            items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getTask_OptionalInput()));
            if (items.size() > 0) {
                this.createFolderBookmark((MethodElement)element, bm, PREFIX_Input_Work_Products, NODE_Input_Work_Products, items, true);
            }
            if (this.monitor.isCanceled()) {
                return;
            }
        }
        if ((items = this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getTask_Output())).size() > 0) {
            if (this.options.generateLightWeightTree) {
                Collections.sort(items, this.nameComparator);
                allItems.addAll(items);
            } else {
                this.createFolderBookmark((MethodElement)element, bm, PREFIX_Output_Work_Products, NODE_Output_Work_Products, items, true);
            }
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        items.clear();
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Assets()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Checklists()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_ConceptsAndPapers()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Examples()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Guidelines()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_SupportingMaterials()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getTask_ToolMentors()));
        if (items.size() > 0) {
            if (this.options.generateLightWeightTree) {
                Collections.sort(items, this.nameComparator);
                allItems.addAll(items);
            } else {
                this.createFolderBookmark((MethodElement)element, bm, PREFIX_Guidances, NODE_Guidances, items, true);
            }
        }
        if (this.options.generateLightWeightTree) {
            this.buildItems(allItems, bm);
        }
    }

    private void buildRoleSubTree(Role element, Bookmark bm) {
        Bookmark b;
        if (this.monitor.isCanceled()) {
            return;
        }
        ArrayList allItems = new ArrayList();
        List items = this.calc0nFeatureValue((MethodElement)element, AssociationHelper.Role_Primary_Tasks);
        if (items.size() > 0) {
            if (this.options.generateLightWeightTree) {
                Collections.sort(items, this.nameComparator);
                allItems.addAll(items);
            } else {
                this.createFolderBookmark((MethodElement)element, bm, PREFIX_ResponsibleFor_Tasks, NODE_ResponsibleFor_Tasks, items, true);
            }
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        if (!this.options.generateLightWeightTree && (items = this.calc0nFeatureValue((MethodElement)element, AssociationHelper.Role_Secondary_Tasks)).size() > 0) {
            this.createFolderBookmark((MethodElement)element, bm, PREFIX_ParticipatesIn_Tasks, NODE_ParticipatesIn_Tasks, items, true);
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        items = this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getRole_ResponsibleFor());
        if (items.size() > 0) {
            if (this.options.generateLightWeightTree) {
                Collections.sort(items, this.nameComparator);
                allItems.addAll(items);
            } else {
                b = this.createFolderBookmark((MethodElement)element, bm, PREFIX_Work_Products_Created, NODE_Work_Products_Created, items, false);
                this.buildItems(items, b, true);
            }
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        if (!this.options.generateLightWeightTree) {
            items = this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getRole_Modifies());
            if (items.size() > 0) {
                b = this.createFolderBookmark((MethodElement)element, bm, PREFIX_Work_Products_Modified, NODE_Work_Products_Modified, items, false);
                this.buildItems(items, b, true);
            }
            if (this.monitor.isCanceled()) {
                return;
            }
        }
        items.clear();
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Assets()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Checklists()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_ConceptsAndPapers()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Examples()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Guidelines()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_SupportingMaterials()));
        if (items.size() > 0) {
            if (this.options.generateLightWeightTree) {
                Collections.sort(items, this.nameComparator);
                allItems.addAll(items);
            } else {
                this.createFolderBookmark((MethodElement)element, bm, NODE_Guidances, items, true);
            }
        }
        if (this.options.generateLightWeightTree) {
            this.buildItems(allItems, bm);
        }
    }

    private void buildWorkProductSubTree(WorkProduct element, Bookmark bm) {
        String url = "";
        if (this.monitor.isCanceled()) {
            return;
        }
        ArrayList allItems = new ArrayList();
        List items = this.calc0nFeatureValue((MethodElement)element, AssociationHelper.WorkProduct_ResponsibleRoles);
        if (items.size() > 0) {
            if (this.options.generateLightWeightTree) {
                Collections.sort(items, this.nameComparator);
                allItems.addAll(items);
            } else {
                this.createFolderBookmark((MethodElement)element, bm, PREFIX_Responsible_Role, NODE_Responsible_Role, items, true);
            }
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        if (element instanceof Artifact) {
            if (!this.options.generateLightWeightTree) {
                Artifact wp = ((Artifact)element).getContainerArtifact();
                this.createBookmark(NODE_Containing_Work_Product, NODE_Containing_Work_Product, url, "", "");
                if (wp != null) {
                    items = new ArrayList();
                    items.add(wp);
                    this.createFolderBookmark((MethodElement)element, bm, PREFIX_Containing_Work_Product, NODE_Containing_Work_Product, items, true);
                }
                if (this.monitor.isCanceled()) {
                    return;
                }
            }
            items = this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts());
            items.remove(element);
            if (items.size() > 0) {
                if (this.options.generateLightWeightTree) {
                    Collections.sort(items, this.nameComparator);
                    allItems.addAll(items);
                } else {
                    Bookmark b = this.createFolderBookmark((MethodElement)element, bm, PREFIX_Contained_Work_Products, NODE_Contained_Work_Products, items, false);
                    this.buildItems(items, b, true);
                }
            }
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        if (!this.options.generateLightWeightTree) {
            items = new ArrayList<Artifact>();
            items.addAll(this.calc0nFeatureValue((MethodElement)element, AssociationHelper.WorkProduct_MandatoryInputTo_Tasks));
            items.addAll(this.calc0nFeatureValue((MethodElement)element, AssociationHelper.WorkProduct_OptionalInputTo_Tasks));
            if (items.size() > 0) {
                this.createFolderBookmark((MethodElement)element, bm, PREFIX_InputTo_Task, NODE_InputTo_Task, items, true);
            }
            if (this.monitor.isCanceled()) {
                return;
            }
            items = this.calc0nFeatureValue((MethodElement)element, AssociationHelper.WorkProduct_OutputFrom_Tasks);
            if (items.size() > 0) {
                this.createFolderBookmark((MethodElement)element, bm, PREFIX_OutputOf_Task, NODE_OutputOf_Task, items, true);
            }
            if (this.monitor.isCanceled()) {
                return;
            }
        }
        items = new ArrayList();
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Assets()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Checklists()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_ConceptsAndPapers()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Examples()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Guidelines()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_SupportingMaterials()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProduct_Reports()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProduct_Templates()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProduct_ToolMentors()));
        if (items.size() > 0) {
            if (this.options.generateLightWeightTree) {
                Collections.sort(items, this.nameComparator);
                allItems.addAll(items);
            } else {
                this.createFolderBookmark((MethodElement)element, bm, PREFIX_Guidances, NODE_Guidances, items, true);
            }
        }
        if (this.options.generateLightWeightTree) {
            this.buildItems(allItems, bm);
        }
    }

    private void buildContainedArtifactsSubTree(Artifact element, Bookmark bm, boolean showGuidances) {
        if (this.monitor.isCanceled()) {
            return;
        }
        ArrayList items = this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts());
        items.remove(element);
        if (this.monitor.isCanceled()) {
            return;
        }
        if (items.size() > 0) {
            Iterator it = items.iterator();
            while (it.hasNext()) {
                if (this.monitor.isCanceled()) {
                    return;
                }
                Artifact e = (Artifact)it.next();
                this.buildItem((MethodElement)e, bm, true);
            }
        }
        if (!showGuidances) {
            return;
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        items = new ArrayList();
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Assets()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Checklists()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_ConceptsAndPapers()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Examples()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Guidelines()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_SupportingMaterials()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProduct_Reports()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProduct_Templates()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProduct_ToolMentors()));
        if (items.size() > 0) {
            this.buildItems(items, bm);
        }
    }

    private void iterateActivity(ProcessElementItem parentItem, Bookmark parentBm, ComposedAdapterFactory adapterFactory, Suppression sup) {
        if (this.monitor.isCanceled()) {
            return;
        }
        ITreeItemContentProvider provider = null;
        Object parentObj = parentItem.rawItem;
        if (parentObj instanceof ITreeItemContentProvider) {
            provider = (ITreeItemContentProvider)parentObj;
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            provider = (ITreeItemContentProvider)adapterFactory.adapt(parentObj, (Object)clazz);
        }
        if (provider != null) {
            Collection children = provider.getChildren(parentObj);
            Iterator it = children.iterator();
            while (it.hasNext()) {
                MethodElement item;
                if (this.monitor.isCanceled()) {
                    return;
                }
                Object rawitem = it.next();
                if (sup.isSuppressed(rawitem) || !((item = (MethodElement)LibraryUtil.unwrap(rawitem)) instanceof Activity)) continue;
                ProcessElementItem elementItem = new ProcessElementItem(rawitem, item, parentItem);
                Bookmark child = this.buildItem(elementItem.element, parentBm, false);
                if (child == null) continue;
                child.setQueryString(elementItem.getQueryString());
                IBSItemProvider adapter = null;
                if (rawitem instanceof IBSItemProvider) {
                    adapter = (IBSItemProvider)rawitem;
                } else {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    adapter = (IBSItemProvider)adapterFactory.adapt((Notifier)item, (Object)clazz);
                }
                String displayName = ProcessUtil.getAttribute((Object)item, (String)"presentation_name", (Object)adapter);
                child.setPresentationName(displayName);
                this.iterateActivity(elementItem, child, adapterFactory, sup);
            }
        }
    }

    private void buildProcessSubTree(Object obj, Process element, Bookmark bm) {
        if (this.monitor.isCanceled()) {
            return;
        }
        ArrayList items = new ArrayList();
        ProcessElementItem procItem = new ProcessElementItem(obj, (MethodElement)element, element.getGuid());
        ConfigurableComposedAdapterFactory adapterFactory = super.getLayoutMgr().getWBSAdapterFactory();
        Suppression sup = new Suppression(element);
        this.iterateActivity(procItem, bm, (ComposedAdapterFactory)adapterFactory, sup);
        if (this.monitor.isCanceled()) {
            return;
        }
        items = new ArrayList();
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_Checklists()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_Concepts()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_Examples()));
        items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_Guidelines()));
        if (element instanceof DeliveryProcess) {
            DeliveryProcess cfr_ignored_0 = (DeliveryProcess)element;
            items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getDeliveryProcess_CommunicationsMaterials()));
            items.addAll(this.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)UmaPackage.eINSTANCE.getDeliveryProcess_EducationMaterials()));
        }
        if (items.size() > 0) {
            this.createFolderBookmark((MethodElement)element, bm, PREFIX_Guidances, NODE_Guidances, items, true);
        }
    }

    public void dispose() {
        super.dispose();
        this.elementUrls.clear();
    }

    protected void elementPublished(IElementLayout layout, String htmlfile) {
        if (layout.getElement() instanceof ProcessElement) {
            ElementUrl url = new ElementUrl(layout.getElement().getGuid(), layout.getUrl(), layout.getDisplayName());
            this.elementUrls.add(url);
        }
    }

    private void saveElementUrls() {
        XmlElement xml = new XmlElement("ElementUrls");
        Iterator it = this.elementUrls.iterator();
        while (it.hasNext()) {
            ElementUrl url = (ElementUrl)it.next();
            xml.newChild("elementUrl", url.guid).setAttribute("text", StrUtil.escape((String)url.text)).setAttribute("url", StrUtil.escape((String)url.url));
        }
        String html = PublishingUtil.getHtml(xml, "xsl/elementUrls.xsl");
        File f = new File(this.getLayoutMgr().getPublishDir(), "scripts/elementUrls.js");
        FileUtil.writeUTF8File((String)f.getAbsolutePath(), (String)html, (boolean)true);
    }

    public class ElementUrl {
        String guid;
        String url;
        String text;

        public ElementUrl(String guid, String url, String text) {
            this.guid = guid;
            this.url = url;
            this.text = text;
        }
    }

    class EObjectComparator
    implements Comparator {
        private EStructuralFeature pName = UmaPackage.eINSTANCE.getDescribableElement_PresentationName();
        private EStructuralFeature name = UmaPackage.eINSTANCE.getNamedElement_Name();

        public int compare(Object e1, Object e2) {
            if (e1 instanceof EObject && e2 instanceof EObject) {
                Object v1 = this.getValue(e1);
                Object v2 = this.getValue(e2);
                if (v1 == null && v2 == null) {
                    return e1.toString().compareTo(e2.toString());
                }
                if (v1 == null) {
                    return -1;
                }
                if (v2 == null) {
                    return 1;
                }
                return v1.toString().compareTo(v2.toString());
            }
            return e1.toString().compareTo(e2.toString());
        }

        private Object getValue(Object e) {
            Object v = null;
            try {
                v = ((EObject)e).eGet(this.pName);
            }
            catch (Exception exception) {}
            if (v == null || v.toString().length() == 0) {
                try {
                    v = ((EObject)e).eGet(this.name);
                }
                catch (Exception exception) {}
            }
            return v;
        }
    }
}

