/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.PluginImportData;
import org.eclipse.epf.importing.services.PluginImportingService;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.library.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class SelectPluginsToImport
extends BaseWizardPage
implements ISelectionChangedListener,
ICheckStateListener,
Listener {
    public static final String PAGE_NAME;
    private static final String libraryPluginExists;
    private static final String libraryPluginNotExists;
    private static final String pluginNoSelection;
    private static final String pluginDataLabel;
    private CheckboxTableViewer ctrl_chkboxTableViewer;
    private Text ctrl_authorImport;
    private Text ctrl_versionImport;
    private Text ctrl_briefDescImport;
    private Label importPluginLabel;
    private Text ctrl_authorLibrary;
    private Text ctrl_versionLibrary;
    private Text ctrl_briefDescLibrary;
    private Label libraryPluginLabel;
    private Composite container;
    private int checkedCount = 0;
    private List checkedPluginList = new ArrayList();
    private PluginImportData data;
    private PluginImportingService service;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.importing.wizards.SelectPluginsToImport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PAGE_NAME = clazz.getName();
        libraryPluginExists = ImportResources.SelectPluginsToImport_libraryPluginExists;
        libraryPluginNotExists = ImportResources.SelectPluginsToImport_libraryPluginNotExists;
        pluginNoSelection = ImportResources.SelectPluginsToImport_pluginNoSelection;
        pluginDataLabel = ImportResources.SelectPluginsToImport_pluginDataLabel;
    }

    public SelectPluginsToImport(PluginImportData data, PluginImportingService service) {
        super(PAGE_NAME);
        this.setTitle(ImportResources.selectPluginsWizardPage_title);
        this.setDescription(ImportResources.selectPluginsWizardPage_text);
        this.setImageDescriptor(ImportPlugin.getDefault().getImageDescriptor("full/wizban/ImportMethodPlugins.gif"));
        this.service = service;
        this.data = data;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(2, true));
        Composite tableContainer = new Composite(this.container, 0);
        tableContainer.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        tableContainer.setLayoutData((Object)gridData);
        this.createLabel(tableContainer, ImportResources.SelectPluginsToImport_label_plugins, 2);
        this.ctrl_chkboxTableViewer = this.createCheckboxTableViewer(tableContainer, 2);
        LabelProvider labelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                return LibraryUIImages.IMG_METHOD_PLUGIN;
            }

            public String getText(Object element) {
                if (element instanceof MethodPlugin) {
                    return ((MethodPlugin)element).getName();
                }
                return element.toString();
            }
        };
        this.ctrl_chkboxTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.ctrl_chkboxTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        Composite importContainer = new Composite(this.container, 0);
        importContainer.setLayout((Layout)new GridLayout());
        this.createImportPluginInfo(importContainer);
        Composite libraryContainer = new Composite(this.container, 0);
        libraryContainer.setLayout((Layout)new GridLayout());
        this.createLibraryPluginInfo(libraryContainer);
        this.addListeners();
        this.setControl((Control)this.container);
        this.setPageComplete(false);
    }

    private void createImportPluginInfo(Composite container) {
        this.importPluginLabel = this.createLabel(container, pluginNoSelection, 1);
        this.createLine(container, 1);
        this.createLabel(container, ImportResources.SelectPluginsToImport_label_author, 1);
        this.ctrl_authorImport = this.createTextMulti(container, "", 275, 40, 1);
        this.createLabel(container, ImportResources.SelectPluginsToImport_label_version, 1);
        this.ctrl_versionImport = this.createText(container, "", 275, 1);
        this.createLabel(container, ImportResources.SelectPluginsToImport_label_desc, 1);
        this.ctrl_briefDescImport = this.createTextMulti(container, "", 275, 100, 1);
    }

    private void createLibraryPluginInfo(Composite container) {
        this.libraryPluginLabel = this.createLabel(container, pluginNoSelection, 1);
        this.createLine(container, 1);
        this.createLabel(container, ImportResources.SelectPluginsToImport_label_author, 1);
        this.ctrl_authorLibrary = this.createTextMulti(container, "", 275, 40, 1);
        this.createLabel(container, ImportResources.SelectPluginsToImport_label_version, 1);
        this.ctrl_versionLibrary = this.createText(container, "", 275, 1);
        this.createLabel(container, ImportResources.SelectPluginsToImport_label_desc, 1);
        this.ctrl_briefDescLibrary = this.createTextMulti(container, "", 275, 100, 1);
    }

    private void addListeners() {
        this.ctrl_chkboxTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.ctrl_chkboxTableViewer.addCheckStateListener((ICheckStateListener)this);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        String message;
        Object obj = event.getElement();
        if (obj instanceof PluginImportData.PluginInfo) {
            ((PluginImportData.PluginInfo)obj).selected = event.getChecked();
        }
        if ((message = this.service.validateSelection()) != null && message.length() > 0) {
            super.setErrorMessage(message);
        } else {
            super.setErrorMessage(null);
        }
        if (event.getChecked()) {
            ++this.checkedCount;
            this.checkedPluginList.add(obj);
        } else {
            --this.checkedCount;
            this.checkedPluginList.remove(obj);
        }
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        if (!selection.isEmpty()) {
            Object[] plugin = selection.toArray();
            this.setDisplayAttributes((PluginImportData.PluginInfo)plugin[0]);
        } else {
            this.clearDisplayAttributes();
        }
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    private void setDisplayAttributes(PluginImportData.PluginInfo plugin) {
        this.ctrl_authorImport.setText(plugin.authors == null ? "" : plugin.authors);
        this.ctrl_versionImport.setText(plugin.version == null ? "" : plugin.version);
        this.ctrl_briefDescImport.setText(plugin.brief_desc == null ? "" : plugin.brief_desc);
        this.importPluginLabel.setText(pluginDataLabel);
        if (plugin.existingPlugin != null) {
            this.libraryPluginLabel.setText(libraryPluginExists);
            this.ctrl_authorLibrary.setText(plugin.existingPlugin.getAuthors());
            this.ctrl_versionLibrary.setText(plugin.existingPlugin.getVersion());
            this.ctrl_briefDescLibrary.setText(plugin.existingPlugin.getBriefDescription());
        } else {
            this.libraryPluginLabel.setText(libraryPluginNotExists);
            this.ctrl_authorLibrary.setText("");
            this.ctrl_versionLibrary.setText("");
            this.ctrl_briefDescLibrary.setText("");
        }
    }

    private void clearDisplayAttributes() {
        this.importPluginLabel.setText(pluginNoSelection);
        this.ctrl_authorImport.setText("");
        this.ctrl_versionImport.setText("");
        this.ctrl_briefDescImport.setText("");
        this.libraryPluginLabel.setText(pluginNoSelection);
        this.ctrl_authorLibrary.setText("");
        this.ctrl_versionLibrary.setText("");
        this.ctrl_briefDescLibrary.setText("");
    }

    public boolean isPageComplete() {
        if (this.getErrorMessage() != null) {
            return false;
        }
        return this.checkedCount > 0;
    }

    public void onEnterPage() {
        List plugins = this.data.getPlugins();
        if (plugins != null) {
            this.ctrl_chkboxTableViewer.setInput((Object)plugins.toArray());
            if (!plugins.isEmpty()) {
                StructuredSelection selection = new StructuredSelection(plugins.get(0));
                this.ctrl_chkboxTableViewer.setSelection((ISelection)selection);
            }
        }
    }
}

