/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.preferences;

import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class LibraryUIPreferences {
    public static final String PROMPT_FOR_LIBRARY_AT_STARTUP = "promptForLibraryAtStartup";
    public static final String SAVED_LIBRARY_PATH = "savedLibraryPath";
    public static final String PUBLISH_UNOPEN_ACTIVITY_DD = "publishUnopenActivityDetailDiagram";
    public static final String PREF_SWITCH_CONFIG = "switchConfigurationOnProcessActivate";
    public static final String PUBLISH_AD_FOR_ACTIVITY_EXTENSION = "publishActivityDiagramforActivityExtension";
    public static final String APPLICATION_SHORT_NAME = "appname";

    static {
        IPreferenceStore store = LibraryUIPlugin.getDefault().getPreferenceStore();
        store.setDefault(PROMPT_FOR_LIBRARY_AT_STARTUP, true);
        store.setDefault(SAVED_LIBRARY_PATH, "");
        store.setDefault(PREF_SWITCH_CONFIG, "prompt");
    }

    public static boolean getPromptForMethodLibraryAtStartup() {
        return LibraryUIPlugin.getDefault().getPreferenceStore().getBoolean(PROMPT_FOR_LIBRARY_AT_STARTUP);
    }

    public static void setPromptForMethodLibraryAtStartup(boolean enabled) {
        LibraryUIPlugin.getDefault().getPreferenceStore().setValue(PROMPT_FOR_LIBRARY_AT_STARTUP, enabled);
    }

    public static void setPublishUnopenActivitydd(boolean enabled) {
        LibraryUIPlugin.getDefault().getPreferenceStore().setValue(PUBLISH_UNOPEN_ACTIVITY_DD, enabled);
    }

    public static boolean getPublishUnopenActivitydd() {
        return LibraryUIPlugin.getDefault().getPreferenceStore().getBoolean(PUBLISH_UNOPEN_ACTIVITY_DD);
    }

    public static void setPublishADForActivityExtension(boolean enabled) {
        LibraryUIPlugin.getDefault().getPreferenceStore().setValue(PUBLISH_AD_FOR_ACTIVITY_EXTENSION, enabled);
    }

    public static boolean getPublishADForActivityExtension() {
        return LibraryUIPlugin.getDefault().getPreferenceStore().getBoolean(PUBLISH_AD_FOR_ACTIVITY_EXTENSION);
    }

    public static String getSwitchConfig() {
        return LibraryUIPlugin.getDefault().getPreferenceStore().getString(PREF_SWITCH_CONFIG);
    }

    public static void setSwitchConfig(String value) {
        LibraryUIPlugin.getDefault().getPreferenceStore().setValue(PREF_SWITCH_CONFIG, value);
    }

    public static String getSavedLibraryPath() {
        return LibraryUIPlugin.getDefault().getPreferenceStore().getString(SAVED_LIBRARY_PATH);
    }

    public static void setSavedLibraryPath(String libPath) {
        String path = libPath;
        if (path.endsWith("library.xmi")) {
            path = FileUtil.getParentDirectory((String)path);
        }
        LibraryUIPlugin.getDefault().getPreferenceStore().setValue(SAVED_LIBRARY_PATH, path);
        LibraryUIPlugin.getDefault().savePluginPreferences();
    }

    public static String getDefaultLibraryPath() {
        String userHome = System.getProperty("user.home").replace('\\', '/');
        String libraryPath = LibraryUIPlugin.getDefault().getString("libraryPath");
        if (libraryPath == null || libraryPath.length() == 0 || libraryPath.startsWith("[")) {
            libraryPath = String.valueOf(userHome) + "/Method Libraries/Library";
        } else if (libraryPath.startsWith("<user.home>")) {
            libraryPath = String.valueOf(userHome) + libraryPath.substring(11);
        }
        if (System.getProperty("file.separator").equals("\\")) {
            libraryPath = libraryPath.replace('/', '\\');
        }
        int idx = -1;
        idx = libraryPath.indexOf("<app.name>");
        if (idx >= 0) {
            String appNameProper = LibraryUIPreferences.getApplicationShortName();
            libraryPath = String.valueOf(libraryPath.substring(0, idx)) + appNameProper + libraryPath.substring(idx + 10);
        }
        return libraryPath;
    }

    public static String getApplicationShortName() {
        String appname = LibraryUIPlugin.getDefault().getPreferenceStore().getString(APPLICATION_SHORT_NAME);
        return appname;
    }

    public static void saveAllPreferences() {
        LibraryUIPlugin.getDefault().savePluginPreferences();
    }
}

