/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.NewProjectWizard;
import org.eclipse.ui.internal.ide.dialogs.WizardNewProjectNameAndLocationPage;

public class CreateProjectWizard
extends Wizard {
    private NewProjectWizard wizard;
    private WizardNewProjectNameAndLocationPage page;

    CreateProjectWizard(WizardNewProjectNameAndLocationPage page, NewProjectWizard wizard) {
        this.page = page;
        this.wizard = wizard;
    }

    private IProject createNewProject() {
        IPath newPath;
        final IProject newProjectHandle = this.page.getProjectHandle();
        IPath defaultPath = Platform.getLocation();
        if (defaultPath.equals((Object)(newPath = this.page.getLocationPath()))) {
            newPath = null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocation(newPath);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                CreateProjectWizard.this.createProject(description, newProjectHandle, monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                if (((CoreException)t).getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.CreateProjectWizard_errorTitle, (String)IDEWorkbenchMessages.CreateProjectWizard_caseVariantExistsError);
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.CreateProjectWizard_errorTitle, null, (IStatus)((CoreException)t).getStatus());
                }
            } else {
                IDEWorkbenchPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui", 0, t.toString(), t));
                MessageDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.CreateProjectWizard_errorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.CreateProjectWizard_internalError, (Object)t.getMessage()));
            }
            return null;
        }
        return newProjectHandle;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
    }

    String getProjectName() {
        return this.page.getProjectName();
    }

    public boolean performFinish() {
        if (this.wizard.getNewProject() != null) {
            return true;
        }
        IProject project = this.createNewProject();
        if (project != null) {
            this.wizard.setNewProject(project);
            return true;
        }
        return false;
    }
}

