/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.security;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.core.IVerificationResult;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.wizards.BannerPage;

public class JarVerificationPage
extends BannerPage {
    private IVerificationResult _VerificationResult = null;
    private String _fileName = null;
    private String _strFeatureName = null;
    private String _strId = null;
    private String _strProviderName = null;
    private TitleAreaDialog _Dialog;

    public JarVerificationPage(IVerificationResult verificationResult) {
        super(UpdateUIMessages.JarVerificationDialog_Verification);
        this._fileName = verificationResult.getContentReference().getIdentifier();
        this._VerificationResult = verificationResult;
        this._strId = verificationResult.getFeature().getVersionedIdentifier().toString();
        this._strFeatureName = verificationResult.getFeature().getLabel();
        this._strProviderName = verificationResult.getFeature().getProvider();
    }

    protected Control createContents(Composite compositeParent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)compositeParent, "org.eclipse.update.ui.JarVerificationPage");
        Composite compositeClient = new Composite(compositeParent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        compositeClient.setLayout((Layout)layout);
        compositeClient.setLayoutData((Object)new GridData(1808));
        this.createTextArea(compositeClient);
        this.createCertificateArea(compositeClient);
        this.createInformationArea(compositeClient);
        Dialog.applyDialogFont((Control)compositeParent);
        return compositeClient;
    }

    private void createTextArea(Composite compositeClient) {
        Label labelInformation = new Label(compositeClient, 64);
        labelInformation.setLayoutData((Object)new GridData(770));
        String actionMsg = null;
        actionMsg = this._VerificationResult.isFeatureVerification() ? UpdateUIMessages.JarVerificationDialog_MayChooseToInstall : UpdateUIMessages.JarVerificationDialog_MayChooseToContinue;
        StringBuffer strb = new StringBuffer();
        switch (this._VerificationResult.getVerificationCode()) {
            case 1: {
                String msg = String.valueOf(this._VerificationResult.isFeatureVerification() ? UpdateUIMessages.JarVerificationDialog_AboutToInstall_Feature : UpdateUIMessages.JarVerificationDialog_AboutToInstall_File) + "\r\n" + actionMsg;
                this.setMessage(msg, 2);
                strb.append(this._VerificationResult.isFeatureVerification() ? UpdateUIMessages.JarVerificationDialog_NotDigitallySigned_Feature : UpdateUIMessages.JarVerificationDialog_NotDigitallySigned_File);
                strb.append("\r\n");
                strb.append(this._VerificationResult.isFeatureVerification() ? UpdateUIMessages.JarVerificationDialog_CannotVerifyProvider_Feature : UpdateUIMessages.JarVerificationDialog_CannotVerifyProvider_File);
                labelInformation.setText(strb.toString());
                break;
            }
            case 2: {
                String msg = this._VerificationResult.isFeatureVerification() ? UpdateUIMessages.JarVerificationDialog_CorruptedContent_Feature : UpdateUIMessages.JarVerificationDialog_CorruptedContent_File;
                this.setMessage(msg, 3);
                strb.append(UpdateUIMessages.JarVerificationDialog_ComponentNotInstalled);
                labelInformation.setText(strb.toString());
                break;
            }
            case 5: {
                String msg = String.valueOf(this._VerificationResult.isFeatureVerification() ? UpdateUIMessages.JarVerificationDialog_SignedComponent_Feature : UpdateUIMessages.JarVerificationDialog_SignedComponent_Feature) + "\r\n" + actionMsg;
                this.setMessage(msg, 2);
                strb.append(this._VerificationResult.isFeatureVerification() ? UpdateUIMessages.JarVerificationDialog_UnknownCertificate_Feature : UpdateUIMessages.JarVerificationDialog_UnknownCertificate_File);
                strb.append("\r\n");
                strb.append(this._VerificationResult.isFeatureVerification() ? UpdateUIMessages.JarVerificationDialog_UnableToVerifyProvider_Feature : UpdateUIMessages.JarVerificationDialog_UnableToVerifyProvider_File);
                labelInformation.setText(strb.toString());
                break;
            }
            case 3: {
                String msg = String.valueOf(this._VerificationResult.isFeatureVerification() ? UpdateUIMessages.JarVerificationDialog_SignedComponent_Feature : UpdateUIMessages.JarVerificationDialog_SignedComponent_File) + "\r\n" + actionMsg;
                this.setMessage(msg, 2);
                strb.append(this._VerificationResult.isFeatureVerification() ? UpdateUIMessages.JarVerificationDialog_KnownCertificate_Feature : UpdateUIMessages.JarVerificationDialog_KnownCertificate_File);
                strb.append("\r\n");
                strb.append(this._VerificationResult.isFeatureVerification() ? UpdateUIMessages.JarVerificationDialog_ProviderKnown_Feature : UpdateUIMessages.JarVerificationDialog_ProviderKnown_File);
                strb.append("\r\n");
                labelInformation.setText(strb.toString());
            }
        }
    }

    private void createInformationArea(Composite compositeClient) {
        Composite compositeInformation = new Composite(compositeClient, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        compositeInformation.setLayout((Layout)layout);
        compositeInformation.setLayoutData((Object)new GridData(768));
        FontRegistry fregistry = JFaceResources.getFontRegistry();
        Font boldFont = fregistry.getBold("org.eclipse.jface.dialogfont");
        Label keyLabel = null;
        CLabel valueLabel = null;
        if (this._strFeatureName != null && this._strFeatureName.length() > 0) {
            keyLabel = new Label(compositeInformation, 0);
            keyLabel.setText(UpdateUIMessages.JarVerificationDialog_FeatureName);
            valueLabel = new CLabel(compositeInformation, 0);
            valueLabel.setFont(boldFont);
            valueLabel.setText(this._strFeatureName);
            valueLabel.setLayoutData((Object)new GridData(768));
        }
        if (this._strId != null && this._strId.length() > 0) {
            keyLabel = new Label(compositeInformation, 0);
            keyLabel.setText(UpdateUIMessages.JarVerificationDialog_FeatureIdentifier);
            valueLabel = new CLabel(compositeInformation, 0);
            valueLabel.setFont(boldFont);
            valueLabel.setText(this._strId);
            valueLabel.setLayoutData((Object)new GridData(768));
        }
        if (this._strProviderName != null && this._strProviderName.length() > 0) {
            keyLabel = new Label(compositeInformation, 0);
            keyLabel.setText(UpdateUIMessages.JarVerificationDialog_Provider);
            valueLabel = new CLabel(compositeInformation, 0);
            valueLabel.setFont(boldFont);
            valueLabel.setText(this._strProviderName);
            valueLabel.setLayoutData((Object)new GridData(768));
        }
        keyLabel = new Label(compositeInformation, 0);
        keyLabel.setText(UpdateUIMessages.JarVerificationDialog_FileName);
        valueLabel = new CLabel(compositeInformation, 0);
        valueLabel.setFont(boldFont);
        valueLabel.setText(this._fileName);
        valueLabel.setLayoutData((Object)new GridData(768));
    }

    private void createCertificateArea(Composite compositeClient) {
        if (this._VerificationResult.getVerificationCode() == 5 || this._VerificationResult.getVerificationCode() == 3) {
            Group group = new Group(compositeClient, 16);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            group.setLayout((Layout)layout);
            group.setLayoutData((Object)new GridData(768));
            group.setText(UpdateUIMessages.JarVerificationDialog_CertificateInfo);
            Label keyLabel = null;
            Text valueText = null;
            if (this._VerificationResult.getSignerInfo() != null) {
                keyLabel = new Label((Composite)group, 0);
                keyLabel.setText(UpdateUIMessages.JarVerificationDialog_SubjectCA);
                keyLabel.setLayoutData((Object)new GridData(2));
                valueText = new Text((Composite)group, 2626);
                valueText.setText(this._VerificationResult.getSignerInfo());
                valueText.setEditable(false);
                valueText.setLayoutData((Object)new GridData(768));
            }
            if (this._VerificationResult.getVerifierInfo() != null) {
                keyLabel = new Label((Composite)group, 0);
                keyLabel.setText(UpdateUIMessages.JarVerificationDialog_RootCA);
                keyLabel.setLayoutData((Object)new GridData(2));
                valueText = new Text((Composite)group, 2626);
                valueText.setText(this._VerificationResult.getVerifierInfo());
                valueText.setEditable(false);
                valueText.setLayoutData((Object)new GridData(768));
            }
        }
    }

    public void setTitleAreaDialog(TitleAreaDialog dialog) {
        this._Dialog = dialog;
    }

    public void setMessage(String newMessage, int newType) {
        super.setMessage(newMessage, newType);
        if (this._Dialog != null) {
            this._Dialog.setMessage(newMessage, newType);
        }
    }
}

