/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.sorters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentRegistryReader;
import org.eclipse.ui.internal.navigator.sorters.CommonSorterDescriptor;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;

public class CommonSorterDescriptorManager {
    private static final CommonSorterDescriptorManager INSTANCE = new CommonSorterDescriptorManager();
    private static final CommonSorterDescriptor[] NO_SORTER_DESCRIPTORS = new CommonSorterDescriptor[0];
    private final Map sortersMap = new HashMap();

    public static CommonSorterDescriptorManager getInstance() {
        return INSTANCE;
    }

    private CommonSorterDescriptorManager() {
        new CommonSorterDescriptorRegistry().readRegistry();
    }

    public CommonSorterDescriptor[] findApplicableSorters(NavigatorContentService contentService, Object aParent) {
        NavigatorContentDescriptor sourceOfContribution = contentService.getSourceOfContribution(aParent);
        ArrayList<CommonSorterDescriptor> applicableSorters = new ArrayList<CommonSorterDescriptor>();
        Set sorters = this.getCommonSorters(sourceOfContribution);
        Iterator sortersItr = sorters.iterator();
        while (sortersItr.hasNext()) {
            CommonSorterDescriptor descriptor = (CommonSorterDescriptor)sortersItr.next();
            if (!descriptor.isEnabledForParent(aParent)) continue;
            applicableSorters.add(descriptor);
        }
        if (applicableSorters.size() == 0) {
            return NO_SORTER_DESCRIPTORS;
        }
        return applicableSorters.toArray(new CommonSorterDescriptor[applicableSorters.size()]);
    }

    public CommonSorterDescriptor[] findApplicableSorters(NavigatorContentService aContentService, INavigatorContentDescriptor theSource, Object aParent, Object anLvalue, Object anRvalue) {
        ArrayList<CommonSorterDescriptor> applicableSorters = new ArrayList<CommonSorterDescriptor>();
        Set sorters = this.getCommonSorters(theSource);
        Iterator sortersItr = sorters.iterator();
        while (sortersItr.hasNext()) {
            CommonSorterDescriptor descriptor = (CommonSorterDescriptor)sortersItr.next();
            if (!descriptor.isEnabledForParent(aParent)) continue;
            applicableSorters.add(descriptor);
        }
        if (applicableSorters.size() == 0) {
            return NO_SORTER_DESCRIPTORS;
        }
        return applicableSorters.toArray(new CommonSorterDescriptor[applicableSorters.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getCommonSorters(INavigatorContentDescriptor contentDescriptor) {
        HashSet descriptors = (HashSet)this.sortersMap.get(contentDescriptor);
        if (descriptors != null) {
            return descriptors;
        }
        Map map = this.sortersMap;
        synchronized (map) {
            descriptors = (Set)this.sortersMap.get(contentDescriptor);
            if (descriptors == null) {
                descriptors = new HashSet();
                this.sortersMap.put(contentDescriptor, descriptors);
            }
        }
        return descriptors;
    }

    private class CommonSorterDescriptorRegistry
    extends NavigatorContentRegistryReader {
        private CommonSorterDescriptorRegistry() {
        }

        protected boolean readElement(IConfigurationElement element) {
            if ("navigatorContent".equals(element.getName())) {
                String id = element.getAttribute("id");
                if (id != null) {
                    NavigatorContentDescriptor contentDescriptor = this.CONTENT_DESCRIPTOR_MANAGER.getContentDescriptor(id);
                    if (contentDescriptor != null) {
                        IConfigurationElement[] children = element.getChildren("commonSorter");
                        if (children.length > 0) {
                            Set localSorters = CommonSorterDescriptorManager.this.getCommonSorters(contentDescriptor);
                            int i = 0;
                            while (i < children.length) {
                                localSorters.add(new CommonSorterDescriptor(children[i]));
                                ++i;
                            }
                            return true;
                        }
                    } else {
                        NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.CommonSorterDescriptorManager_A_navigatorContent_extension_does_n_, (Object[])new Object[]{id, element.getDeclaringExtension().getNamespaceIdentifier()}), null);
                    }
                } else {
                    NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.CommonSorterDescriptorManager_A_navigatorContent_extesnion_in_0_, (Object)element.getNamespaceIdentifier()), null);
                }
            }
            return super.readElement(element);
        }
    }
}

