/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;

public class NetUtil {
    public static final String FILE_SCHEME = "file";
    public static final String FILE_URI_PREFIX = "file:/";
    public static final int FILE_URI_PREFIX_LENGTH = "file:/".length();
    public static final String HTTP_SCHEME = "http";
    public static final String HTTP_URI_PREFIX = "http://";
    public static final int HTTP_URI_PREFIX_LENGTH = "http://".length();
    private static final String[] HEX_VALUES = new String[]{"%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07", "%08", "%09", "%0A", "%0B", "%0C", "%0D", "%0E", "%0F", "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17", "%18", "%19", "%1A", "%1B", "%1C", "%1D", "%1E", "%1F", "%20", "%21", "%22", "%23", "%24", "%25", "%26", "%27", "%28", "%29", "%2A", "%2B", "%2C", "%2D", "%2E", "%2F", "%30", "%31", "%32", "%33", "%34", "%35", "%36", "%37", "%38", "%39", "%3A", "%3B", "%3C", "%3D", "%3E", "%3F", "%40", "%41", "%42", "%43", "%44", "%45", "%46", "%47", "%48", "%49", "%4A", "%4B", "%4C", "%4D", "%4E", "%4F", "%50", "%51", "%52", "%53", "%54", "%55", "%56", "%57", "%58", "%59", "%5A", "%5B", "%5C", "%5D", "%5E", "%5F", "%60", "%61", "%62", "%63", "%64", "%65", "%66", "%67", "%68", "%69", "%6A", "%6B", "%6C", "%6D", "%6E", "%6F", "%70", "%71", "%72", "%73", "%74", "%75", "%76", "%77", "%78", "%79", "%7A", "%7B", "%7C", "%7D", "%7E", "%7F", "%80", "%81", "%82", "%83", "%84", "%85", "%86", "%87", "%88", "%89", "%8A", "%8B", "%8C", "%8D", "%8E", "%8F", "%90", "%91", "%92", "%93", "%94", "%95", "%96", "%97", "%98", "%99", "%9A", "%9B", "%9C", "%9D", "%9E", "%9F", "%A0", "%A1", "%A2", "%A3", "%A4", "%A5", "%A6", "%A7", "%A8", "%A9", "%AA", "%AB", "%AC", "%AD", "%AE", "%AF", "%B0", "%B1", "%B2", "%B3", "%B4", "%B5", "%B6", "%B7", "%B8", "%B9", "%BA", "%BB", "%BC", "%BD", "%BE", "%BF", "%C0", "%C1", "%C2", "%C3", "%C4", "%C5", "%C6", "%C7", "%C8", "%C9", "%CA", "%CB", "%CC", "%CD", "%CE", "%CF", "%D0", "%D1", "%D2", "%D3", "%D4", "%D5", "%D6", "%D7", "%D8", "%D9", "%DA", "%DB", "%DC", "%DD", "%DE", "%DF", "%E0", "%E1", "%E2", "%E3", "%E4", "%E5", "%E6", "%E7", "%E8", "%E9", "%EA", "%EB", "%EC", "%ED", "%EE", "%EF", "%F0", "%F1", "%F2", "%F3", "%F4", "%F5", "%F6", "%F7", "%F8", "%F9", "%FA", "%FB", "%FC", "%FD", "%FE", "%FF"};

    private NetUtil() {
    }

    public static String getUri(File file) throws MalformedURLException {
        String url = file.toURL().toExternalForm();
        StringBuffer strBuf = new StringBuffer();
        int urlLength = url.length();
        int i = 0;
        while (i < urlLength) {
            char ch = url.charAt(i);
            switch (ch) {
                case ' ': {
                    strBuf.append("%20");
                    break;
                }
                default: {
                    strBuf.append(ch);
                }
            }
            ++i;
        }
        return strBuf.toString();
    }

    public static String resolveUri(String uri, String baseUri) {
        if (uri == null) {
            return null;
        }
        if (uri.startsWith("../")) {
            if (baseUri.endsWith("/")) {
                baseUri = baseUri.substring(0, baseUri.length() - 1);
            }
            while (uri.startsWith("../")) {
                uri = uri.substring(3);
                int index = baseUri.lastIndexOf(47);
                if (index <= 0) continue;
                baseUri = baseUri.substring(0, index);
            }
            uri = "/" + uri;
        }
        if (uri.startsWith("/")) {
            return baseUri.endsWith("/") ? String.valueOf(baseUri) + uri.substring(1) : String.valueOf(baseUri) + uri;
        }
        if (uri.startsWith(FILE_URI_PREFIX) || uri.startsWith(HTTP_URI_PREFIX)) {
            return uri;
        }
        return baseUri.endsWith("/") ? String.valueOf(baseUri) + uri : String.valueOf(baseUri) + '/' + uri;
    }

    public static InputStream getInputStream(String uri) throws MalformedURLException, IOException {
        if (uri == null) {
            return null;
        }
        if (uri.startsWith(HTTP_URI_PREFIX)) {
            URL url = new URL(uri);
            return url.openStream();
        }
        if (uri.startsWith(FILE_URI_PREFIX)) {
            uri = uri.substring(FILE_URI_PREFIX_LENGTH);
        }
        return new FileInputStream(NetUtil.decodeUrl(uri, null));
    }

    public static String decodeUrl(String url, String encoding) {
        if (url == null) {
            return url;
        }
        int len = url.length();
        if (len == 0) {
            return url;
        }
        StringBuffer strBuf = new StringBuffer();
        int i = 0;
        while (i < len) {
            char ch = url.charAt(i);
            switch (ch) {
                case '+': {
                    strBuf.append(' ');
                    break;
                }
                case '%': {
                    try {
                        strBuf.append((char)Integer.parseInt(url.substring(i + 1, i + 3), 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    i += 2;
                    break;
                }
                default: {
                    strBuf.append(ch);
                }
            }
            ++i;
        }
        String result = strBuf.toString();
        if (encoding != null) {
            try {
                byte[] bytes = result.getBytes("8859_1");
                result = new String(bytes, encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return result;
    }

    public static String encodeUrl(String url, String encoding) throws UnsupportedEncodingException {
        if (url == null) {
            return url;
        }
        int len = url.length();
        if (len == 0) {
            return url;
        }
        StringBuffer result = new StringBuffer();
        byte[] bytes = url.getBytes(encoding);
        int i = 0;
        while (i < bytes.length) {
            char ch = (char)bytes[i];
            if (ch >= 'a' && ch <= 'z') {
                result.append(ch);
            } else if (ch >= 'A' && ch <= 'Z') {
                result.append(ch);
            } else if (ch >= '0' && ch <= '9') {
                result.append(ch);
            } else {
                switch (ch) {
                    case '!': 
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '-': 
                    case '.': 
                    case '_': 
                    case '~': {
                        result.append(ch);
                        break;
                    }
                    default: {
                        result.append(HEX_VALUES[ch & 0xFF]);
                    }
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static String encodeFileURL(String fileURL) {
        String url = fileURL;
        StringBuffer strBuf = new StringBuffer();
        int urlLength = url.length();
        int i = 0;
        while (i < urlLength) {
            char ch = url.charAt(i);
            switch (ch) {
                case ' ': {
                    strBuf.append("%20");
                    break;
                }
                default: {
                    strBuf.append(ch);
                }
            }
            ++i;
        }
        return strBuf.toString();
    }

    public static String decodedFileUrl(String fileURL) {
        String url = fileURL;
        StringBuffer strBuf = new StringBuffer();
        int urlLength = url.length();
        int i = 0;
        while (i < urlLength) {
            char ch = url.charAt(i);
            switch (ch) {
                case '%': {
                    try {
                        strBuf.append((char)Integer.parseInt(url.substring(i + 1, i + 3), 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    i += 2;
                    break;
                }
                default: {
                    strBuf.append(ch);
                }
            }
            ++i;
        }
        return strBuf.toString();
    }

    public static String decodeURL(String url) throws UnsupportedEncodingException {
        url = URLDecoder.decode(url, "UTF-8");
        return url;
    }
}

