/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.epf.common.CommonPlugin;

public class XSLTProcessor {
    private static boolean cacheXSL;
    private static Map transformerCache;
    static /* synthetic */ Class class$0;

    static {
        String cacheXSLProperty = CommonPlugin.getDefault().getString("cacheXSL");
        cacheXSL = cacheXSLProperty != null && !cacheXSLProperty.startsWith("[") ? Boolean.getBoolean(cacheXSLProperty) : true;
        if (cacheXSL) {
            transformerCache = new HashMap();
        }
    }

    private XSLTProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transform(Source xslSource, Source xmlSource, Writer output, Properties params, String encoding) throws Exception {
        if (xslSource != null && xmlSource != null) {
            Transformer transformer = null;
            String xslFile = xslSource.getSystemId();
            if (cacheXSL && xslFile != null) {
                Map map = transformerCache;
                synchronized (map) {
                    transformer = (Transformer)transformerCache.get(xslFile);
                    if (transformer == null) {
                        TransformerFactory factory = TransformerFactory.newInstance();
                        transformer = factory.newTransformer(xslSource);
                        transformerCache.put(xslFile, transformer);
                    }
                }
            } else {
                TransformerFactory factory = TransformerFactory.newInstance();
                transformer = factory.newTransformer(xslSource);
            }
            if (params != null && params.size() > 0) {
                Iterator<Object> i = params.keySet().iterator();
                while (i.hasNext()) {
                    String paramName = (String)i.next();
                    String paramValue = params.getProperty(paramName);
                    transformer.setParameter(paramName, paramValue);
                }
            }
            if (encoding != null && encoding.length() > 0) {
                transformer.setOutputProperty("encoding", encoding);
            } else {
                transformer.setOutputProperty("encoding", "utf-8");
            }
            transformer.transform(xmlSource, new StreamResult(output));
        }
    }

    public static void transform(Source xslSource, Source xmlSource, Writer output, String encoding) throws Exception {
        XSLTProcessor.transform(xslSource, xmlSource, output, null, encoding);
    }

    public static void transform(String xslUri, Source xmlSource, Writer output, Properties params, String encoding) throws Exception {
        InputStream xslInput = XSLTProcessor.getXslInputStream(xslUri);
        if (xslInput != null) {
            StreamSource xslSource = new StreamSource(xslInput);
            xslSource.setSystemId(new File(xslUri));
            XSLTProcessor.transform(xslSource, xmlSource, output, params, encoding);
            try {
                xslInput.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void transform(String xslUri, Source xmlSource, Writer output, String encoding) throws Exception {
        XSLTProcessor.transform(xslUri, xmlSource, output, null, encoding);
    }

    public static void transform(String xslUri, String xmlStr, Writer output, Properties params, String encoding) throws Exception {
        InputStream xslInput = XSLTProcessor.getXslInputStream(xslUri);
        if (xslInput != null) {
            StreamSource xslSource = new StreamSource(xslInput);
            xslSource.setSystemId(new File(xslUri));
            byte[] xml = xmlStr.getBytes("utf-8");
            ByteArrayInputStream xmlInput = new ByteArrayInputStream(xml);
            StreamSource xmlSource = new StreamSource(xmlInput);
            XSLTProcessor.transform(xslSource, (Source)xmlSource, output, params, encoding);
            try {
                xslInput.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void transform(String xslUri, String xmlStr, Writer output, String encoding) throws Exception {
        XSLTProcessor.transform(xslUri, xmlStr, output, null, encoding);
    }

    public static void transform(String xslUri, String xmlStr, File file, Properties params, String encoding) throws Exception {
        FileWriter output = new FileWriter(file);
        if (output != null) {
            XSLTProcessor.transform(xslUri, xmlStr, (Writer)output, params, encoding);
            try {
                output.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void transform(String xslUri, String xmlStr, File file, String encoding) throws Exception {
        XSLTProcessor.transform(xslUri, xmlStr, file, null, encoding);
    }

    public static void transform(String xslUri, Source xmlSource, Properties params, Writer output) throws Exception {
        XSLTProcessor.transform(xslUri, xmlSource, output, params, null);
    }

    public static void transform(String xslUri, Source xmlSource, Writer output) throws Exception {
        XSLTProcessor.transform(xslUri, xmlSource, output, null, null);
    }

    public static void transform(String xslUri, String xmlStr, Properties params, Writer output) throws Exception {
        XSLTProcessor.transform(xslUri, xmlStr, output, params, null);
    }

    public static void transform(String xslUri, String xmlStr, Writer output) throws Exception {
        XSLTProcessor.transform(xslUri, xmlStr, output, null, null);
    }

    public static void transform(String xslUri, String xmlStr, Properties params, File file) throws Exception {
        XSLTProcessor.transform(xslUri, xmlStr, file, params, null);
    }

    public static void transform(String xslUri, String xmlStr, File file) throws Exception {
        XSLTProcessor.transform(xslUri, xmlStr, file, null, null);
    }

    private static InputStream getXslInputStream(String xslUri) {
        InputStream xslInput;
        block5: {
            xslInput = null;
            try {
                xslInput = new FileInputStream(xslUri);
            }
            catch (Exception exception) {
                if (xslInput != null) break block5;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.epf.common.xml.XSLTProcessor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                xslInput = clazz.getClassLoader().getResourceAsStream(xslUri);
            }
        }
        return xslInput;
    }
}

