/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.msp.ui.wizards;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.epf.export.msp.ExportMSPPlugin;
import org.eclipse.epf.export.msp.ExportMSPResources;
import org.eclipse.epf.export.msp.ExportMSPService;
import org.eclipse.epf.export.msp.ExportMSPServiceException;
import org.eclipse.epf.export.msp.ExportOptions;
import org.eclipse.epf.export.msp.IExportMSPService;
import org.eclipse.epf.export.msp.ui.internal.ExportMSPWizardExtensionManager;
import org.eclipse.epf.export.msp.ui.wizards.IExportMSPWizardExtender;
import org.eclipse.epf.export.msp.ui.wizards.SelectExportDirectoryPage;
import org.eclipse.epf.export.msp.ui.wizards.SelectProcessPage;
import org.eclipse.epf.export.msp.ui.wizards.SelectPublishOptionsPage;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.ui.preferences.PublishingUIPreferences;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.Process;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class ExportMSPWizard
extends Wizard
implements IExportWizard {
    protected IWorkbench workbench;
    protected IStructuredSelection selection;
    protected SelectProcessPage selectProcessPage;
    protected SelectPublishOptionsPage selectPublishOptionsPage;
    protected SelectExportDirectoryPage selectExportDirPage;
    protected ExportOptions exportOptions = new ExportOptions();
    protected PublishOptions publishingOptions = new PublishOptions();
    protected IExportMSPWizardExtender wizardExtender;

    public ExportMSPWizard() {
        this.setWindowTitle(ExportMSPResources.exportMSPWizard_title);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.wizardExtender = ExportMSPWizardExtensionManager.getInstance().getWizardExtender();
    }

    public void addPages() {
        this.selectProcessPage = new SelectProcessPage(this.exportOptions);
        this.selectPublishOptionsPage = new SelectPublishOptionsPage(false, this.publishingOptions);
        this.selectExportDirPage = new SelectExportDirectoryPage();
        super.addPage((IWizardPage)this.selectProcessPage);
        super.addPage((IWizardPage)this.selectPublishOptionsPage);
        super.addPage((IWizardPage)this.selectExportDirPage);
        if (this.wizardExtender != null) {
            List pages = this.wizardExtender.getPageContributions();
            int i = 0;
            while (i < pages.size()) {
                IWizardPage page = (IWizardPage)pages.get(i);
                super.addPage(page);
                ++i;
            }
        }
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        pageContainer.getShell().setImage(ExportMSPPlugin.getDefault().getSharedImage("full/obj16/MSProject.gif"));
    }

    public boolean canFinish() {
        if (this.wizardExtender != null && !this.wizardExtender.canFinish()) {
            return false;
        }
        return this.getContainer().getCurrentPage() == this.selectExportDirPage && this.selectExportDirPage.isPageComplete();
    }

    public boolean performFinish() {
        boolean ok;
        Process process = this.selectProcessPage.getProcess();
        String processContextName = this.selectProcessPage.getProcessContextName();
        MethodConfiguration config = LibraryServiceUtil.getMethodConfiguration((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (String)processContextName);
        boolean publishConfiguration = this.selectProcessPage.getPublishedConfiguration();
        if (publishConfiguration) {
            if (this.wizardExtender != null) {
                PublishOptions publishOptions = this.wizardExtender.getPublishOptions();
                if (publishOptions != null) {
                    this.publishingOptions = publishOptions;
                }
            } else {
                this.publishingOptions = this.selectPublishOptionsPage.getPublishingOptions();
            }
            this.publishingOptions.setSelectedConfig(processContextName);
            PublishingUIPreferences.setTitle((String)this.publishingOptions.getTitle());
            PublishingUIPreferences.setBannerImage((String)this.publishingOptions.getBannerImage());
            PublishingUIPreferences.setAboutHTML((String)this.publishingOptions.getAboutHTML());
            PublishingUIPreferences.setFeedbackURL((String)this.publishingOptions.getFeedbackURL());
            PublishingUIPreferences.setIncludeGlossary((boolean)this.publishingOptions.isGenerateGlossary());
            PublishingUIPreferences.setIncludeIndex((boolean)this.publishingOptions.isGenerateIndex());
            PublishingUIPreferences.setCheckExternalLinks((boolean)this.publishingOptions.isCheckExtLinks());
            LibraryUIPreferences.setPublishUnopenActivitydd((boolean)this.publishingOptions.isAutoGenerateActivityDiagrams());
            LibraryUIPreferences.setPublishADForActivityExtension((boolean)this.publishingOptions.isUnopenExtendedActivityDiagram());
        } else {
            this.publishingOptions = null;
        }
        String templateName = this.selectExportDirPage.getTemplateName();
        String targetDir = this.selectExportDirPage.getTargetDirectory();
        String templateFileName = String.valueOf(templateName) + ".xml";
        File templateFile = new File(targetDir, templateFileName);
        if (templateFile.exists() && !(ok = ExportMSPPlugin.getDefault().getMsgDialog().displayPrompt(ExportMSPResources.exportMSPWizard_title, NLS.bind((String)ExportMSPResources.overwriteText_msg, (Object[])new String[]{templateFileName, targetDir})))) {
            return false;
        }
        try {
            boolean success;
            Map options;
            ExportOptions exportOptions = new ExportOptions();
            exportOptions.put("publishConfig", new Boolean(this.publishingOptions != null));
            exportOptions.put("exportOnlyPlannedElements", new Boolean(this.selectProcessPage.getExportOnlyPlannedElements()));
            if (this.wizardExtender != null && (options = this.wizardExtender.getExportOptions()) != null) {
                Iterator it = options.keySet().iterator();
                while (it.hasNext()) {
                    String name = (String)it.next();
                    Object value = options.get(name);
                    exportOptions.put(name, value);
                }
            }
            IExportMSPService service = null;
            if (this.wizardExtender != null) {
                service = this.wizardExtender.getExportMSPService();
            }
            if (service == null) {
                service = ExportMSPService.getInstance();
            }
            if (success = service.exportMSPXML(process, config, templateName, new File(targetDir), exportOptions, this.publishingOptions)) {
                ExportMSPPlugin.getDefault().getMsgDialog().displayInfo(ExportMSPResources.exportMSPWizard_title, NLS.bind((String)ExportMSPResources.completedText_msg, (Object[])new String[]{process.getName(), templateFile.getAbsolutePath()}));
            }
        }
        catch (ExportMSPServiceException e) {
            ExportMSPPlugin.getDefault().getMsgDialog().displayError(ExportMSPResources.exportMSPWizard_title, NLS.bind((String)ExportMSPResources.exportMSPError_msg, (Object[])new String[]{process.getName(), templateFile.getAbsolutePath()}), ExportMSPResources.exportMSPError_reason, (Throwable)e);
        }
        ExportMSPPlugin plugin = ExportMSPPlugin.getDefault();
        IPreferenceStore prefStore = plugin.getPreferenceStore();
        if (process != null) {
            if (process instanceof DeliveryProcess) {
                prefStore.setValue("processType", "DeliveryProcess");
            } else {
                prefStore.setValue("processType", "CapabilityPattern");
            }
            prefStore.setValue("processName", process.getName());
        }
        prefStore.setValue("context", processContextName);
        prefStore.setValue("templateNames", templateName);
        prefStore.setValue("targetDirs", targetDir);
        plugin.savePluginPreferences();
        return true;
    }

    public IExportMSPWizardExtender getWizardExtender() {
        return this.wizardExtender;
    }

    public SelectProcessPage getSelectProcessPage() {
        return this.selectProcessPage;
    }

    public SelectPublishOptionsPage selectPublishOptionsPage() {
        return this.selectPublishOptionsPage;
    }

    public SelectExportDirectoryPage getSelectExportDirectoryPage() {
        return this.selectExportDirPage;
    }

    public ExportOptions getExportOptions() {
        return this.exportOptions;
    }
}

