/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.wizards;

import java.util.Iterator;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.ConfigSpecs;
import org.eclipse.epf.importing.services.ConfigurationImportData;
import org.eclipse.epf.importing.wizards.ImportConfigurationWizard;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.library.ui.wizards.BaseWizardPage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectConfigSpecsToImportPage
extends BaseWizardPage
implements ISelectionChangedListener,
ICheckStateListener {
    public static final String PAGE_NAME;
    private static final String libraryConfigSpecExists;
    private static final String libraryConfigSpecNotExists;
    private static final String configSpecNoSelection;
    private static final String configSpecDataLabel;
    private CheckboxTableViewer ctrl_chkboxTableViewer;
    private Text ctrl_briefDescImport;
    private Label importConfigSpecLabel;
    private Text ctrl_briefDescLibrary;
    private Label libraryConfigSpecLabel;
    private Composite container;
    private ConfigurationImportData data;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.importing.wizards.SelectConfigSpecsToImportPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PAGE_NAME = clazz.getName();
        libraryConfigSpecExists = ImportResources.SelectConfigSpecsToImportPage_libraryConfigSpecExists;
        libraryConfigSpecNotExists = ImportResources.SelectConfigSpecsToImportPage_libraryConfigSpecNotExists;
        configSpecNoSelection = ImportResources.SelectConfigSpecsToImportPage_configSpecNoSelection;
        configSpecDataLabel = ImportResources.SelectConfigSpecsToImportPage_configSpecDataLabel;
    }

    public SelectConfigSpecsToImportPage(ConfigurationImportData data) {
        super(PAGE_NAME);
        this.setTitle(ImportResources.selectConfigSpecsWizardPage_title);
        this.setDescription(ImportResources.selectConfigSpecsWizardPage_text);
        this.setImageDescriptor(ImportPlugin.getDefault().getImageDescriptor("full/wizban/ImportLibraryConfiguration.gif"));
        this.data = data;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(2, true));
        Composite tableContainer = new Composite(this.container, 0);
        tableContainer.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        tableContainer.setLayoutData((Object)gridData);
        this.createLabel(tableContainer, ImportResources.SelectConfigSpecsToImportPage_label_configs, 2);
        this.ctrl_chkboxTableViewer = this.createCheckboxTableViewer(tableContainer, 1);
        LabelProvider labelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                return LibraryUIImages.IMG_METHOD_CONFIGURATON;
            }

            public String getText(Object element) {
                return super.getText(element);
            }
        };
        this.ctrl_chkboxTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.ctrl_chkboxTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        Composite importContainer = new Composite(this.container, 0);
        importContainer.setLayout((Layout)new GridLayout());
        importContainer.setLayoutData((Object)new GridData(768));
        this.createImportConfigSpecInfo(importContainer);
        Composite libraryContainer = new Composite(this.container, 0);
        libraryContainer.setLayout((Layout)new GridLayout());
        libraryContainer.setLayoutData((Object)new GridData(768));
        this.createLibraryConfigSpecInfo(libraryContainer);
        this.addListeners();
        this.setControl((Control)this.container);
        this.setPageComplete(false);
    }

    private void createImportConfigSpecInfo(Composite container) {
        this.importConfigSpecLabel = this.createLabel(container, configSpecNoSelection, 1);
        this.createLine(container, 1);
        this.createLabel(container, ImportResources.SelectConfigSpecsToImportPage_label_desc, 1);
        this.ctrl_briefDescImport = this.createTextMulti(container, "", 275, 100, 1);
    }

    private void createLibraryConfigSpecInfo(Composite container) {
        this.libraryConfigSpecLabel = this.createLabel(container, configSpecNoSelection, 1);
        this.createLine(container, 1);
        this.createLabel(container, ImportResources.SelectConfigSpecsToImportPage_label_desc, 1);
        this.ctrl_briefDescLibrary = this.createTextMulti(container, "", 275, 100, 1);
    }

    private void addListeners() {
        this.ctrl_chkboxTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.ctrl_chkboxTableViewer.addCheckStateListener((ICheckStateListener)this);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        if (!selection.isEmpty()) {
            Object[] configs = selection.toArray();
            this.setDisplayAttributes((ConfigSpecs.Entry)configs[0]);
        } else {
            this.clearDisplayAttributes();
        }
    }

    private void setDisplayAttributes(ConfigSpecs.Entry spec) {
        this.ctrl_briefDescImport.setText(spec.configSpec.brief_desc == null ? "" : spec.configSpec.brief_desc);
        this.importConfigSpecLabel.setText(configSpecDataLabel);
        if (spec.existingConfig != null) {
            this.ctrl_briefDescLibrary.setText(spec.existingConfig.getBriefDescription());
            this.libraryConfigSpecLabel.setText(libraryConfigSpecExists);
        } else {
            this.libraryConfigSpecLabel.setText(libraryConfigSpecNotExists);
            this.ctrl_briefDescLibrary.setText("");
        }
    }

    private void clearDisplayAttributes() {
        this.ctrl_briefDescImport.setText("");
        this.ctrl_briefDescLibrary.setText("");
        this.libraryConfigSpecLabel.setText(configSpecNoSelection);
        this.importConfigSpecLabel.setText(configSpecNoSelection);
    }

    public boolean isPageComplete() {
        if (this.getErrorMessage() != null) {
            return false;
        }
        if (this.ctrl_chkboxTableViewer.getCheckedElements().length > 0) {
            Iterator iter = this.data.specs.configs.iterator();
            while (iter.hasNext()) {
                ConfigSpecs.Entry e = (ConfigSpecs.Entry)iter.next();
                e.selected = this.ctrl_chkboxTableViewer.getChecked((Object)e);
            }
            ((ImportConfigurationWizard)this.getWizard()).okToComplete = true;
        } else {
            ((ImportConfigurationWizard)this.getWizard()).okToComplete = false;
        }
        return false;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public void onEnterPage() {
        this.ctrl_chkboxTableViewer.setInput((Object)this.data.specs.configs);
        if (this.data.specs.configs.size() > 0) {
            StructuredSelection sel = new StructuredSelection(this.data.specs.configs.get(0));
            this.ctrl_chkboxTableViewer.setSelection((ISelection)sel);
        }
    }
}

