/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.util.Comparators;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.diagram.MethodElementDiagram;
import org.eclipse.epf.library.layout.diagram.RoleDiagramPublisher;
import org.eclipse.epf.library.layout.elements.AbstractElementLayout;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.util.AssociationHelper;

public class RoleLayout
extends AbstractElementLayout {
    protected Map referenceMap = new HashMap();

    public void init(ElementLayoutManager layoutManager, MethodElement element) {
        super.__init(layoutManager, element);
    }

    public XmlElement getXmlElement(boolean includeReferences) {
        XmlElement elementXml = super.getXmlElement(includeReferences);
        if (includeReferences) {
            List performs = ConfigurationHelper.calc0nFeatureValue(this.element, AssociationHelper.Role_Primary_Tasks, this.layoutManager.getElementRealizer());
            this.referenceMap.put("performs", performs);
            List additionallyPerforms = ConfigurationHelper.calc0nFeatureValue(this.element, AssociationHelper.Role_Secondary_Tasks, this.layoutManager.getElementRealizer());
            this.addReferences(AssociationHelper.Role_Secondary_Tasks, elementXml, "additionallyPerforms", additionallyPerforms);
            RoleDiagramPublisher diagramPublisher = new RoleDiagramPublisher();
            MethodElementDiagram diagram = diagramPublisher.publish(this, new File(this.layoutManager.getPublishDir()));
            if (diagram != null) {
                elementXml.setContent("diagram", diagram.getHTML());
            }
            List roleSets = ConfigurationHelper.calc0nFeatureValue(this.element, AssociationHelper.Role_RoleSets, this.layoutManager.getElementRealizer());
            this.addReferences(AssociationHelper.Role_RoleSets, elementXml, "roleSets", roleSets);
        }
        return elementXml;
    }

    public List getPerforms() {
        List list = (List)this.referenceMap.get("performs");
        Collections.sort(list, Comparators.PRESENTATION_NAME_COMPARATOR);
        return list;
    }

    public List getAdditionallyPerforms() {
        List list = (List)this.referenceMap.get("additionallyPerforms");
        Collections.sort(list, Comparators.PRESENTATION_NAME_COMPARATOR);
        return list;
    }

    public List getResponsibleFor() {
        List list = (List)this.referenceMap.get("responsibleFor");
        Collections.sort(list, Comparators.PRESENTATION_NAME_COMPARATOR);
        return list;
    }

    public List getModifies() {
        List list = (List)this.referenceMap.get("modifies");
        Collections.sort(list, Comparators.PRESENTATION_NAME_COMPARATOR);
        return list;
    }

    protected void notifyFeatureValue(String name, Object value) {
        this.referenceMap.put(name, value);
    }

    protected boolean acceptFeatureValue(EStructuralFeature feature, Object value) {
        if (feature == UmaPackage.eINSTANCE.getRole_ResponsibleFor()) {
            this.referenceMap.put("responsibleFor", value);
        }
        return super.acceptFeatureValue(feature, value);
    }

    protected boolean acceptFeatureValue(OppositeFeature feature, Object value) {
        return super.acceptFeatureValue(feature, value);
    }
}

