/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.services;

import java.io.File;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epf.export.services.LibraryDocument;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class BaseExportService {
    protected static final String exportFile = "export.xmi";
    protected static final String libraryFile = "library.xmi";
    protected List selectedIds = new ArrayList();
    protected List selectedPluginNames = new ArrayList();

    protected boolean isIdSelected(String uri) {
        Iterator it = this.selectedIds.iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            if (uri.indexOf(id) < 0) continue;
            return true;
        }
        return false;
    }

    protected boolean isSelectedPluginResource(String uri) {
        Iterator it = this.selectedPluginNames.iterator();
        while (it.hasNext()) {
            String plugin_name = (String)it.next();
            if (!uri.startsWith(String.valueOf(plugin_name) + "/")) continue;
            return true;
        }
        return false;
    }

    protected boolean isResourceSelected(String uri) {
        if (this.isIdSelected(uri)) {
            return true;
        }
        return this.isSelectedPluginResource(uri);
    }

    protected LibraryDocument processLibraryFile(File source, File target) {
        try {
            String uri;
            Element node;
            LibraryDocument document = new LibraryDocument(source);
            NodeList nodes = document.getPlugins();
            int i = 0;
            while (i < nodes.getLength()) {
                node = (Element)nodes.item(i);
                uri = node.getAttribute("href");
                if (!this.isIdSelected(uri)) {
                    document.removePlugin(node);
                    continue;
                }
                ++i;
            }
            nodes = document.getConfigurations();
            i = 0;
            while (i < nodes.getLength()) {
                node = (Element)nodes.item(i);
                uri = node.getAttribute("href");
                if (!this.isIdSelected(uri)) {
                    document.removeConfiguration(node);
                    continue;
                }
                ++i;
            }
            nodes = document.getResourceDescriptors();
            i = 0;
            while (i < nodes.getLength()) {
                node = (Element)nodes.item(i);
                String id = node.getAttribute("id");
                String uri2 = node.getAttribute("uri");
                if (!this.isIdSelected(id) && !this.isResourceSelected(URLDecoder.decode(uri2, "UTF-8"))) {
                    document.removeResourceDescriptor(node);
                    continue;
                }
                ++i;
            }
            nodes = document.getResourceSubManagers();
            i = 0;
            while (i < nodes.getLength()) {
                node = (Element)nodes.item(i);
                uri = node.getAttribute("href");
                if (!this.isResourceSelected(uri)) {
                    document.removeResourceDescriptor(node);
                    continue;
                }
                ++i;
            }
            document.saveAs(target.getAbsolutePath());
            return document;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

