/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.publishing.services.PublishingContentValidator;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.Roadmap;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.TermDefinition;

public class ProcessPublishingContentValidator
extends PublishingContentValidator {
    public static final String CLOSURE_LOG_FILENAME = "processClosure.html";
    List closureElements = null;
    private boolean isFinalClosure = false;
    private boolean debug = PublishingPlugin.getDefault().isDebugging();
    protected PrintStream closureLog = this.getStream("processClosure.html");

    public ProcessPublishingContentValidator(String pubDir, boolean validateExternalLinks) {
        super(pubDir, validateExternalLinks);
        this.beginClosureLog();
    }

    public void addClosureElements(List items) {
        if (this.closureElements == null) {
            this.closureElements = new ArrayList();
        }
        this.closureElements.addAll(items);
    }

    public void makeElementClosure() {
        this.isFinalClosure = true;
        this.endClosureLog();
        if (this.debug) {
            System.out.println("====================== Closure elements =======================");
            Iterator it = this.closureElements.iterator();
            while (it.hasNext()) {
                System.out.println(LibraryUtil.getTypeName((MethodElement)((MethodElement)it.next())));
            }
            System.out.println("====================== Closure elements end =======================");
        }
    }

    public boolean hasClosure() {
        return this.closureElements != null && this.closureElements.size() > 0;
    }

    public boolean inClosure(MethodElement e) {
        if (e == null) {
            return false;
        }
        if (!this.hasClosure()) {
            return true;
        }
        if (e instanceof ContentCategory) {
            return true;
        }
        if (ConfigurationHelper.isDescriptionElement((MethodElement)e)) {
            return true;
        }
        if (this.closureElements.contains(e)) {
            return true;
        }
        if (!(e instanceof Guidance)) {
            return false;
        }
        return e instanceof Practice || e instanceof Roadmap || e instanceof SupportingMaterial || e instanceof TermDefinition;
    }

    public boolean isDiscarded(MethodElement owner, Object feature, MethodElement e) {
        if (owner == null) {
            owner = this.defaultTarget;
        } else if (this.defaultTarget != null && owner != this.defaultTarget) {
            super.logWarning("Target mismatch" + LibraryUtil.getTypeName((MethodElement)owner) + "<--->" + LibraryUtil.getTypeName((MethodElement)this.defaultTarget));
        }
        if (super.isDiscarded(owner, feature, e)) {
            return true;
        }
        boolean inCls = this.inClosure(e);
        if (!inCls && !this.isFinalClosure) {
            boolean bl = inCls = this.inClosure(owner) && e instanceof Guidance;
        }
        return !inCls;
    }

    public void dispose() {
        if (this.closureElements != null) {
            this.closureElements.clear();
        }
        if (this.closureLog != null) {
            this.closureLog.close();
            this.closureLog = null;
        }
        super.dispose();
    }

    private void beginClosureLog() {
        this.closureLog.println("<table>");
        this.addLogEntry("<b>Element</b>", "<b>Referenced By</b>");
    }

    private void endClosureLog() {
        this.closureLog.println("</table>");
    }

    private void addLogEntry(String str1, String str2) {
        StringBuffer b = new StringBuffer();
        b.append("<tr><td>").append(str1).append("</td><td>").append(str2).append("</td></tr>");
        this.closureLog.println(b);
    }

    public void logReference(MethodElement owner, MethodElement e) {
        super.logReference(owner, e);
        if (e instanceof Descriptor) {
            return;
        }
        if (!this.isFinalClosure && this.closureLog != null) {
            StringBuffer b = new StringBuffer();
            if (owner instanceof BreakdownElement) {
                b.append(this.getBreakdownElementLabel((BreakdownElement)owner));
            } else if (owner != null) {
                b.append(LibraryUtil.getTypeName((MethodElement)owner));
            }
            this.addLogEntry(LibraryUtil.getTypeName((MethodElement)e), b.toString());
        }
    }

    private StringBuffer getBreakdownElementLabel(BreakdownElement e) {
        StringBuffer b = new StringBuffer();
        b.append(LibraryUtil.getTypeName((MethodElement)e));
        while ((e = e.getSuperActivities()) != null) {
            b.insert(0, String.valueOf(LibraryUtil.getTypeName((MethodElement)e)) + "/");
        }
        return b;
    }
}

