/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services.index;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.epf.publishing.services.index.Def;
import org.eclipse.epf.publishing.services.index.FontObject;
import org.eclipse.epf.publishing.services.index.HelpMessages;
import org.eclipse.epf.publishing.services.index.KeyWordIndexHelper;
import org.eclipse.epf.publishing.services.index.MiscStatic;

public class DefinitionObject {
    private String indextitle = "Index - Basic Unified Process";
    private String see = ", See ";
    private String seealso = ", See also ";
    private String characterset = "utf-8";
    public String keyWordSeparator = "|";
    public String levelSeparatorReplace = ":";
    String wwwRoot = null;
    int stipLength = 0;
    String relativepath = null;
    String target = null;
    String specKeyWordFile = null;
    String mainResultFile = null;
    String indexResultFile = null;
    String indexTarget = null;
    String indexHeight = null;
    String keywordTarget = null;
    String keywordResultFile = null;
    String headerFile = null;
    String footerFile = null;
    String keyWordPrefix = Def.DefaultKeyWordPrefix;
    String keyWordLevelSeparator = Def.DefaultKeyWordLevelSeparator;
    boolean multidocumentkeyword = false;
    boolean showdocumenttitle = false;
    Vector stopDirsV = null;
    Hashtable fontDefinitions = null;
    Hashtable styleDefinitions = null;
    private File defFileRoot;

    public DefinitionObject(String pubDir, String deffile, String charSet) {
        this.setwwwRoot(pubDir);
        this.defFileRoot = new File(deffile).getParentFile();
        String infile = MiscStatic.loadFile(deffile, charSet);
        StringTokenizer parser = new StringTokenizer(infile, "\t\n");
        this.stopDirsV = new Vector();
        this.fontDefinitions = new Hashtable(10);
        this.styleDefinitions = new Hashtable(10);
        while (parser.hasMoreTokens()) {
            String param = parser.nextToken().trim();
            if (param.equalsIgnoreCase(Def.LevelFont)) {
                this.asignFont(parser);
                continue;
            }
            if (param.equalsIgnoreCase(Def.LevelStyle)) {
                this.asignStyle(parser);
                continue;
            }
            String value = parser.nextToken().trim();
            if (value == null) {
                System.err.println("DefinitionObject:addValue\n" + HelpMessages.PARAMETER_MISSING_VALUE + param);
                return;
            }
            this.asignValue(param, value);
        }
    }

    public boolean enoughInput() {
        boolean enough = true;
        StringBuffer buff = new StringBuffer();
        buff.append("\n");
        if (this.wwwRoot == null) {
            buff.append(String.valueOf(HelpMessages.PARAMETER_MISSING) + Def.WWWRootParam);
            enough = false;
        }
        if (this.keywordResultFile == null) {
            buff.append(String.valueOf(HelpMessages.PARAMETER_MISSING) + Def.KeyWordResultFile);
            enough = false;
        }
        if (this.indexResultFile != null && this.mainResultFile == null) {
            buff.append(String.valueOf(HelpMessages.PARAMETER_MISSING) + Def.MainResultFile);
            enough = false;
        }
        if (this.indexResultFile != null && this.indexTarget == null) {
            buff.append(String.valueOf(HelpMessages.PARAMETER_MISSING) + Def.IndexTarget);
            enough = false;
        }
        if (this.indexResultFile != null && this.keywordTarget == null) {
            buff.append(String.valueOf(HelpMessages.PARAMETER_MISSING) + Def.KeyWordTarget);
            enough = false;
        }
        if (this.indexResultFile != null && this.indexHeight == null) {
            buff.append(String.valueOf(HelpMessages.PARAMETER_MISSING) + Def.IndexHeight);
            enough = false;
        }
        if (this.relativepath == null) {
            buff.append(String.valueOf(HelpMessages.PARAMETER_MISSING) + Def.RelPath);
            enough = false;
        }
        if (this.headerFile == null) {
            buff.append(String.valueOf(HelpMessages.PARAMETER_MISSING) + Def.HeaderFile);
            enough = false;
        }
        if (this.footerFile == null) {
            buff.append(String.valueOf(HelpMessages.PARAMETER_MISSING) + Def.FooterFile);
            enough = false;
        }
        FontObject f = (FontObject)this.fontDefinitions.get(Def.DefaultFont);
        FontObject fs = (FontObject)this.styleDefinitions.get(Def.DefaultStyle);
        if (f == null && fs == null) {
            buff.append(String.valueOf(HelpMessages.FONT_AND_STYLE_MISSING) + Def.DefaultFont + " " + Def.DefaultStyle);
            enough = false;
        }
        if (!enough) {
            buff.append("\n");
            System.err.println(buff);
        }
        return enough;
    }

    private void asignValue(String param, String value) {
        if (param.equalsIgnoreCase(Def.MainResultFile)) {
            this.mainResultFile = value;
        } else if (param.equalsIgnoreCase(Def.CharacterSet)) {
            this.characterset = value;
        } else if (param.equalsIgnoreCase(Def.See)) {
            this.see = value;
        } else if (param.equalsIgnoreCase(Def.SeeAlso)) {
            this.seealso = value;
        } else if (param.equalsIgnoreCase(Def.IndexResultFile)) {
            this.indexResultFile = value;
        } else if (param.equalsIgnoreCase(Def.KeyWordResultFile)) {
            this.keywordResultFile = value;
        } else if (param.equalsIgnoreCase(Def.HeaderFile)) {
            this.headerFile = new File(this.defFileRoot, value).getAbsolutePath();
        } else if (param.equalsIgnoreCase(Def.FooterFile)) {
            this.footerFile = new File(this.defFileRoot, value).getAbsolutePath();
        } else if (param.equalsIgnoreCase(Def.RelPath)) {
            this.relativepath = value;
        } else if (param.equalsIgnoreCase(Def.DefaultTargetParam)) {
            this.target = value;
        } else if (param.equalsIgnoreCase(Def.KeyWordFile)) {
            this.specKeyWordFile = new File(this.defFileRoot, value).getAbsolutePath();
        } else if (param.equalsIgnoreCase(Def.IndexTitle)) {
            this.indextitle = value;
        } else if (param.equalsIgnoreCase(Def.KeyWordTarget)) {
            this.keywordTarget = value;
        } else if (param.equalsIgnoreCase(Def.IndexTarget)) {
            this.indexTarget = value;
        } else if (param.equalsIgnoreCase(Def.IndexHeight)) {
            this.indexHeight = value;
        } else if (param.equalsIgnoreCase(Def.MultiDocKeyWord)) {
            this.multidocumentkeyword = value.equalsIgnoreCase(Def.True);
        } else if (param.equalsIgnoreCase(Def.ShowDocTitle)) {
            this.showdocumenttitle = value.equalsIgnoreCase(Def.True);
        } else if (param.equalsIgnoreCase(Def.LeaveDir)) {
            this.stopDirsV.addElement(value);
        } else if (param.equalsIgnoreCase(Def.KeyWordPrefix)) {
            this.keyWordPrefix = value;
        } else if (param.equalsIgnoreCase(Def.KeyWordLevelSeparator)) {
            this.keyWordLevelSeparator = value;
        } else {
            System.err.println(String.valueOf(HelpMessages.INVALID_PARAMETER_NAME) + param);
        }
    }

    private void asignFont(StringTokenizer parser) {
        String stringLevel = parser.nextToken().trim();
        Object key = stringLevel;
        if (!stringLevel.equalsIgnoreCase(Def.DefaultFont) && !stringLevel.equalsIgnoreCase(Def.HeadLineFont)) {
            key = new Integer(stringLevel);
        }
        String name = parser.nextToken().trim();
        String style = parser.nextToken().trim();
        String size = parser.nextToken().trim();
        this.fontDefinitions.put(key, new FontObject(name, style, size));
    }

    private void asignStyle(StringTokenizer parser) {
        String stringLevel = parser.nextToken().trim();
        Object key = stringLevel;
        if (!stringLevel.equalsIgnoreCase(Def.DefaultStyle) && !stringLevel.equalsIgnoreCase(Def.HeadLineStyle)) {
            key = new Integer(stringLevel);
        }
        String style = parser.nextToken().trim();
        this.styleDefinitions.put(key, new FontObject(style));
    }

    public boolean isInStopdir(String str) {
        int i = 0;
        while (i < this.stopDirsV.size()) {
            String tmpStr = (String)this.stopDirsV.elementAt(i);
            if (str.substring(KeyWordIndexHelper.defObj.getWwwRoot().length() + 1).compareTo(tmpStr) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getIndexTitle() {
        return this.indextitle;
    }

    public String getSee() {
        return this.see;
    }

    public String getSeeAlso() {
        return this.seealso;
    }

    public String getCharacterSet() {
        return this.characterset;
    }

    public boolean getMulitDocumentKeyword() {
        return this.multidocumentkeyword;
    }

    public boolean getShowDocumentTitle() {
        return this.showdocumenttitle;
    }

    public String getKeyWordTarget() {
        return this.keywordTarget;
    }

    public String getIndexTarget() {
        return this.indexTarget;
    }

    public String getIndexHeight() {
        return this.indexHeight;
    }

    public String getWwwRoot() {
        return this.wwwRoot;
    }

    public int getWwwRootLength() {
        return this.stipLength;
    }

    public String getTarget() {
        return this.target;
    }

    public String getKeyWordFile() {
        return this.specKeyWordFile;
    }

    public String getMainResultFile() {
        return this.mainResultFile;
    }

    public String getIndexResultFile() {
        return this.indexResultFile;
    }

    public String getKeywordResultFile() {
        return this.keywordResultFile;
    }

    public String getRelativePath() {
        return this.relativepath;
    }

    public String getHeaderFile() {
        return this.headerFile;
    }

    public String getFooterFile() {
        return this.footerFile;
    }

    public String getKeyWordPrefix() {
        return this.keyWordPrefix;
    }

    public String getKeyWordLevelSeparator() {
        return this.keyWordLevelSeparator;
    }

    public FontObject getFont(int level) {
        FontObject f = (FontObject)this.fontDefinitions.get(new Integer(level));
        if (f == null) {
            f = (FontObject)this.fontDefinitions.get(Def.DefaultFont);
        }
        return f;
    }

    public FontObject getFont(Object key) {
        return (FontObject)this.fontDefinitions.get(key);
    }

    public FontObject getStyleSheet(int level) {
        FontObject f = (FontObject)this.styleDefinitions.get(new Integer(level));
        if (f == null) {
            f = (FontObject)this.styleDefinitions.get(Def.DefaultStyle);
        }
        return f;
    }

    public FontObject getStyleSheet(Object key) {
        return (FontObject)this.styleDefinitions.get(key);
    }

    public void printStart(OutputStreamWriter outP, int level) {
        if (this.getStyleSheet(Def.DefaultStyle) == null) {
            FontObject f = this.getFont(level);
            if (f == null) {
                f = this.getFont(Def.DefaultFont);
            }
            this.printStart(outP, f);
        } else {
            FontObject f = this.getStyleSheet(level);
            if (f == null) {
                f = this.getStyleSheet(Def.DefaultStyle);
            }
            this.printStart(outP, f);
        }
    }

    public void printStart(OutputStreamWriter outP, FontObject f) {
        if (outP == null) {
            System.out.println("DefinitionObject:printStart\n" + HelpMessages.BAD_OUTPUT_STREAM);
            return;
        }
        if (f != null && f.getStyleSheet() == null) {
            MiscStatic.print(outP, "<FONT FACE=\"" + f.getName() + "\" SIZE=\"" + f.getSize() + "\" >\n");
            if (f.isItalic()) {
                MiscStatic.print(outP, "<I>");
            }
            if (f.isBold()) {
                MiscStatic.print(outP, "<B>");
            }
        } else {
            MiscStatic.print(outP, "<P CLASS=\"" + f.getStyleSheet() + "\">\n");
        }
    }

    public void printEnd(OutputStreamWriter outP, int level) {
        if (outP == null) {
            System.out.println("DefinitionObject:printEnd\n" + HelpMessages.BAD_OUTPUT_STREAM);
            return;
        }
        if (this.getStyleSheet(Def.DefaultStyle) == null) {
            FontObject f = this.getFont(level);
            if (f == null) {
                f = this.getFont(Def.DefaultFont);
            }
            this.printEnd(outP, f);
        } else {
            this.printEnd(outP, null);
        }
    }

    public void printEnd(OutputStreamWriter outP, FontObject f) {
        if (outP == null) {
            System.out.println("DefinitionObject:printEnd\n" + HelpMessages.BAD_OUTPUT_STREAM);
            return;
        }
        if (f != null && f.getStyleSheet() == null) {
            if (f.isBold()) {
                MiscStatic.print(outP, "</B>");
            }
            if (f.isItalic()) {
                MiscStatic.print(outP, "</I>");
            }
            MiscStatic.print(outP, "</FONT>\n");
        } else {
            MiscStatic.print(outP, "</P>\n");
        }
    }

    public void setwwwRoot(String newRoot) {
        try {
            File wwwDir = new File(newRoot);
            this.wwwRoot = String.valueOf(wwwDir.getCanonicalPath()) + "/";
            this.wwwRoot = this.wwwRoot.replace('\\', '/');
            this.stipLength = this.wwwRoot.length() - 1;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setRelativePath(String newPath) {
        this.relativepath = newPath;
    }

    public void setIndexTitle(String title) {
        this.indextitle = title;
    }
}

