/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.commands;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.epf.authoring.gef.util.Validation;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.gef.commands.Command;

public class ReconnectLinkCommand
extends Command {
    private boolean isSource;
    private Link link;
    private Node newNode;
    private Node oldNode;
    private int viewIndex;
    private Point endPoint;
    private static final String LABEL = AuthoringUIResources.gef_reconnectLinkCommand_label;

    public ReconnectLinkCommand(Link link, Node newNode, boolean isSource) {
        super(LABEL);
        this.link = link;
        this.newNode = newNode;
        this.isSource = isSource;
    }

    public void setEndPoint(Point p) {
        this.endPoint = p.getCopy();
    }

    public boolean canExecute() {
        boolean result;
        boolean bl = result = this.link != null && this.newNode != null;
        if (!result) {
            return false;
        }
        if (this.isSource) {
            return Validation.checkReconnect(this.newNode, this.link.getTarget(), this.link) == null;
        }
        return Validation.checkReconnect(this.link.getSource(), this.newNode, this.link) == null;
    }

    public void execute() {
        if (this.isSource) {
            this.oldNode = this.link.getSource();
            if (this.oldNode != null) {
                this.viewIndex = this.oldNode.getOutgoingConnections().indexOf((Object)this.link);
            }
            this.link.setSource(this.newNode);
            this.link.setSourceEndPoint(this.endPoint);
        } else {
            this.oldNode = this.link.getTarget();
            if (this.oldNode != null) {
                this.viewIndex = this.oldNode.getIncomingConnections().indexOf((Object)this.link);
            }
            this.link.setTarget(this.newNode);
            this.link.setTargetEndPoint(this.endPoint);
        }
    }

    public void undo() {
        if (this.isSource) {
            this.newNode.getOutgoingConnections().remove((Object)this.link);
            this.oldNode.getOutgoingConnections().add(this.viewIndex, (Object)this.link);
        } else {
            this.newNode.getIncomingConnections().remove((Object)this.link);
            this.oldNode.getIncomingConnections().add(this.viewIndex, (Object)this.link);
        }
        this.oldNode = null;
    }
}

