/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence.migration;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.epf.persistence.migration.IMigrator;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.osgi.framework.Bundle;

public final class MappingUtil {
    private static Map migrators;

    public static final IMigrator getMigrator(String libNsURI) {
        Migrator migrator;
        if (migrators == null) {
            migrators = new HashMap();
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("org.eclipse.epf.library.persistence", "migrators");
            if (extensionPoint != null) {
                IExtension[] extensions = extensionPoint.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IExtension extension = extensions[i];
                    String pluginId = extension.getNamespaceIdentifier();
                    Bundle bundle = Platform.getBundle((String)pluginId);
                    IConfigurationElement[] configElements = extension.getConfigurationElements();
                    int j = 0;
                    while (j < configElements.length) {
                        IConfigurationElement configElement = configElements[j];
                        try {
                            String className = configElement.getAttribute("class");
                            String nsURI = configElement.getAttribute("libNsURI");
                            if (className != null && className.trim().length() > 0 && nsURI != null && nsURI.trim().length() > 0) {
                                migrators.put(nsURI, new Migrator(bundle, className, nsURI));
                            }
                        }
                        catch (Exception e) {
                            CommonPlugin.INSTANCE.log((Object)e);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        if ((migrator = (Migrator)migrators.get(libNsURI)) != null) {
            if (migrator.instance == null) {
                try {
                    migrator.instance = (IMigrator)migrator.bundle.loadClass(migrator.className).newInstance();
                }
                catch (Exception e) {
                    CommonPlugin.INSTANCE.log((Object)e);
                }
            }
            return migrator.instance;
        }
        return null;
    }

    public static final boolean conversionRequired(String libPath) {
        String libNsURI;
        String currentNsURI = PersistenceUtil.getUMANsURI();
        if (currentNsURI.equals(libNsURI = PersistenceUtil.getUMANsURI(libPath))) {
            return false;
        }
        return MappingUtil.getMigrator(libNsURI) != null;
    }

    public static void migrate(String libPath, IProgressMonitor monitor) throws Exception {
        String nsURI = PersistenceUtil.getUMANsURI(libPath);
        IMigrator migrator = MappingUtil.getMigrator(nsURI);
        if (migrator != null) {
            migrator.migrate(libPath, monitor);
        }
    }

    public static void main(String[] args) {
        String libPath = args[0];
        System.out.println("Start migrating method library at '" + libPath + "'...");
        try {
            MappingUtil.migrate(libPath, null);
            System.out.println();
            System.out.println("Migration successfull.");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println();
            System.err.println("Migration failed.");
        }
    }

    private static class Migrator {
        Bundle bundle;
        String className;
        String libNsURI;
        IMigrator instance;

        public Migrator(Bundle bundle, String className, String libNsURI) {
            this.bundle = bundle;
            this.className = className;
            this.libNsURI = libNsURI;
        }
    }
}

