/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.actions;

import java.io.File;
import java.net.URL;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.epf.common.serviceability.Logger;
import org.eclipse.epf.common.utils.ClipboardUtil;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextEditor;
import org.eclipse.epf.richtext.RichTextImages;
import org.eclipse.epf.richtext.RichTextPlugin;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.actions.RichTextAction;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class PasteAction
extends RichTextAction {
    private static final String SOURCE_URL = "SourceURL:";
    private static final String HTM_EXT = ".htm";
    private static final String HTML_EXT = ".html";
    private static final Pattern HREF_REFERENCES = Pattern.compile("href\\s*=\\s*\"(.*?)\"", 34);
    protected static final Pattern p_image_ref = Pattern.compile("(<(img|iframe).*?src\\s*=\\s*\")(.*?)(\")", 34);
    protected static String sourceURLStr = "";
    private Logger logger;
    private static String RESOURCES = "resources";

    public PasteAction() {
        this.setImage(RichTextImages.IMG_PASTE);
        this.setDisabledImage(RichTextImages.DISABLED_IMG_PASTE);
        this.setToolTipText(RichTextResources.pasteAction_toolTipText);
        this.setEnabled(true);
        this.logger = RichTextPlugin.getDefault().getLogger();
    }

    public boolean disableInSourceMode() {
        return false;
    }

    public void execute(IRichText richText) {
        if (richText != null) {
            this.copyLinkResources(richText);
            if (richText instanceof RichTextEditor && ((RichTextEditor)richText).isHTMLTabSelected()) {
                StyledText styledText = ((RichTextEditor)richText).getSourceEdit();
                styledText.paste();
            } else {
                richText.executeCommand("paste", sourceURLStr);
            }
        }
    }

    protected void copyLinkResources(IRichText richText) {
        try {
            sourceURLStr = ClipboardUtil.getHTMLSourceURL();
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            String html = (String)clipboard.getContents((Transfer)HTMLTransfer.getInstance());
            if (html != null && html.length() > 0) {
                String resPath;
                File tgtDir;
                File tgtFile;
                String scheme;
                String basePath = richText.getBasePath();
                URL sourceURL = null;
                sourceURL = sourceURLStr == null || sourceURLStr.length() == 0 || sourceURLStr.equals("about:blank") ? richText.getCopyURL() : new URL(sourceURLStr);
                Matcher matcher = HREF_REFERENCES.matcher(html);
                while (matcher.find()) {
                    String href = NetUtil.decodeURL((String)matcher.group(1));
                    try {
                        URL hrefURL = new URL(sourceURL, href);
                        scheme = hrefURL.getProtocol();
                        if (scheme == null || !scheme.equalsIgnoreCase("file")) continue;
                        String url = hrefURL.getPath();
                        File srcFile = new File(url);
                        tgtFile = null;
                        tgtDir = null;
                        if (href.startsWith(RESOURCES) || href.startsWith("./" + RESOURCES)) {
                            tgtFile = new File(basePath, href);
                            tgtDir = tgtFile.getParentFile();
                        } else {
                            resPath = this.getSubdirectoryOfResources(href);
                            tgtDir = tgtFile = new File(String.valueOf(basePath) + RESOURCES, resPath);
                        }
                        tgtDir.mkdirs();
                        FileUtil.copyFile((File)srcFile, (File)tgtDir);
                    }
                    catch (Exception e) {
                        this.logger.logError((Throwable)e);
                    }
                }
                matcher = p_image_ref.matcher(html);
                while (matcher.find()) {
                    String src = NetUtil.decodeURL((String)matcher.group(3));
                    try {
                        URL srcURL = new URL(sourceURL, src);
                        scheme = srcURL.getProtocol();
                        if (scheme == null || !scheme.equalsIgnoreCase("file")) continue;
                        File srcFile = null;
                        String authority = srcURL.getAuthority();
                        srcFile = authority != null ? new File(String.valueOf(authority) + srcURL.getPath()) : new File(srcURL.getPath());
                        tgtFile = null;
                        tgtDir = null;
                        if (src.startsWith(RESOURCES) || src.startsWith("./" + RESOURCES)) {
                            tgtFile = new File(basePath, src);
                            tgtDir = tgtFile.getParentFile();
                        } else {
                            resPath = this.getSubdirectoryOfResources(src);
                            tgtDir = tgtFile = new File(String.valueOf(basePath) + RESOURCES, resPath);
                        }
                        tgtDir.mkdirs();
                        FileUtil.copyFile((File)srcFile, (File)tgtDir);
                    }
                    catch (Exception e) {
                        this.logger.logError((Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.logError((Throwable)e);
        }
    }

    protected String getSourceURL(String htmlContent) {
        String sourceURL = null;
        int sourceURLIndex = htmlContent.indexOf(SOURCE_URL);
        if (sourceURLIndex > 0) {
            sourceURL = htmlContent.substring(sourceURLIndex + SOURCE_URL.length());
            if ((sourceURL = sourceURL.substring(0, sourceURL.indexOf(FileUtil.LINE_SEP))).toLowerCase().endsWith(HTM_EXT) || sourceURL.toLowerCase().endsWith(HTML_EXT)) {
                sourceURL = sourceURL.substring(0, sourceURL.indexOf(FileUtil.getFileName((String)sourceURL)) - 1);
                sourceURL = sourceURL.replace('\\', '/');
            }
            sourceURL = FileUtil.appendSeparator((String)sourceURL, (String)"/");
        }
        return sourceURL;
    }

    protected String getSubdirectoryOfResources(String path) {
        String result = "";
        int res_idx = path.indexOf(RESOURCES);
        if (res_idx != -1) {
            Stack<String> stack = new Stack<String>();
            File relative = new File(path).getParentFile();
            while (!relative.getName().equals(RESOURCES)) {
                stack.push(relative.getName());
                relative = relative.getParentFile();
            }
            while (!stack.isEmpty()) {
                result = String.valueOf(result) + (String)stack.pop() + File.separator;
            }
        }
        return result;
    }
}

