/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.export.wizards.DestinationCommonPage;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.ConfigurationImportData;
import org.eclipse.epf.importing.services.ConfigurationImportService;
import org.eclipse.epf.importing.wizards.ImportConfigurationWizard;
import org.eclipse.epf.importing.wizards.PluginModifyInfo;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.wizards.BaseWizardPage;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Text;

public class SelectImportConfigurationSource
extends DestinationCommonPage {
    public static final String PAGE_NAME;
    private static final Status okStatus;
    private ConfigurationImportData data;
    private ConfigurationImportService service;
    private Status status = okStatus;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.importing.wizards.SelectImportConfigurationSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PAGE_NAME = clazz.getName();
        okStatus = new Status(0, ImportResources.SelectImportConfigurationSource_not_used, 0, "", null);
    }

    public SelectImportConfigurationSource(ConfigurationImportData data, ConfigurationImportService service) {
        super(PAGE_NAME, data.llData);
        this.setTitle(ImportResources.selectConfigDirWizardPage_title);
        this.setDescription(ImportResources.selectConfigDirWizardPage_text);
        this.setImageDescriptor(ImportPlugin.getDefault().getImageDescriptor("full/wizban/ImportLibraryConfiguration.gif"));
        this.service = service;
        this.data = data;
    }

    public boolean isPageComplete() {
        boolean returnValue = false;
        this.status = okStatus;
        if (SelectImportConfigurationSource.isTextNonEmpty((Text)this.ctrl_name) && SelectImportConfigurationSource.isTextNonEmpty((Text)this.ctrl_exportPath)) {
            this.saveToDataModel();
            File libDir = new File(this.ctrl_exportPath.getText());
            if (!libDir.exists()) {
                this.status = new Status(4, ImportResources.SelectImportConfigurationSource_not_used, 0, ImportResources.SelectImportConfigurationSource_no_path, null);
            } else {
                returnValue = true;
            }
        }
        this.applyToStatusLine();
        return returnValue;
    }

    protected void saveToDataModel() {
        super.saveToDataModel();
        this.data.llData.setLibName(this.ctrl_name.getText());
        this.data.llData.setParentFolder(this.ctrl_exportPath.getText());
    }

    public IWizardPage getNextPage() {
        this.saveToDataModel();
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(ImportResources.SelectImportConfigurationSource_MSG1, -1);
                SelectImportConfigurationSource.this.service.analyze(monitor);
                monitor.done();
            }
        };
        try {
            this.getWizard().getContainer().run(true, false, operation);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String error = this.data.getErrorInfo().getError();
        if (error != null && error.length() > 0) {
            this.status = new Status(4, ImportResources.SelectImportConfigurationSource_not_used, 0, error, null);
            this.applyToStatusLine();
            return this;
        }
        BaseWizardPage page = null;
        if (this.data.specs != null) {
            page = ((ImportConfigurationWizard)this.getWizard()).specsPage;
        } else {
            PluginModifyInfo modifyInfo = this.checkModify();
            if (modifyInfo.readonlyPlugins.size() > 0) {
                error = modifyInfo.getReadonlyMessage().toString();
                ImportPlugin.getDefault().getMsgDialog().displayError(ImportResources.ImportConfigurationWizard_error, error);
                this.status = new Status(4, ImportResources.SelectImportConfigurationSource_not_used, 0, ImportResources.SelectImportConfigurationSource_error_not_updatable, null);
                this.applyToStatusLine();
                return this;
            }
            if (modifyInfo.lockedPlugins.size() > 0) {
                String WIZARD_TITLE = ImportResources.importConfigWizard_title;
                String message = String.valueOf(modifyInfo.getLockedMessage().toString()) + ImportResources.ImportPluginWizard_confirm_continue;
                boolean yes = ImportPlugin.getDefault().getMsgDialog().displayConfirmation(WIZARD_TITLE, message);
                if (!yes) {
                    this.status = new Status(4, ImportResources.SelectImportConfigurationSource_not_used, 0, ImportResources.SelectImportConfigurationSource_error_not_updatable, null);
                    this.applyToStatusLine();
                    return this;
                }
            }
            page = ((ImportConfigurationWizard)this.getWizard()).configPage;
        }
        page.onEnterPage();
        return page;
    }

    public PluginModifyInfo checkModify() {
        PluginModifyInfo modifyInfo = new PluginModifyInfo();
        List guids = LibraryUtil.getMethodPluginGuids((MethodLibrary)this.service.getImportingLibrary());
        List plugins = LibraryService.getInstance().getCurrentMethodLibrary().getMethodPlugins();
        Iterator it = plugins.iterator();
        while (it.hasNext()) {
            MethodPlugin plugin = (MethodPlugin)it.next();
            if (!guids.contains(plugin.getGuid())) continue;
            if (!plugin.getUserChangeable().booleanValue()) {
                modifyInfo.lockedPlugins.add(plugin);
                continue;
            }
            IStatus status = TngUtil.checkEdit((EObject)plugin, (Object)this.getShell());
            if (status.isOK()) continue;
            modifyInfo.readonlyPlugins.add(plugin);
        }
        return modifyInfo;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    private void applyToStatusLine() {
        if (this.status != okStatus) {
            this.setErrorMessage(this.status.getMessage());
        } else {
            this.setErrorMessage(null);
        }
    }
}

