/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.wizards;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.library.ui.wizards.BaseWizardPage;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.ui.PublishingUIResources;
import org.eclipse.epf.publishing.ui.preferences.PublishingUIPreferences;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PublishConfigPublishOptionsPage
extends BaseWizardPage {
    private Text destinationPathText;
    private Text titleText;
    private Text bannerImageText;
    private Text aboutHTMLText;
    private Text feedbackURLText;
    private Button browseButton;
    private Button defaultPathCheckbox;
    private Button selectImageButton;
    private Button selectHTMLButton;
    private Button includeGlossary;
    private Button includeIndex;
    private Button checkExternalLinks;
    private Button convertBrokenLinks;
    private Button autoGenerateActivityDiagrams;
    private boolean displayDestinationGroup = true;
    private Button extraDescriptorInfoCtr;
    private Button lightWeightTreeCtr;
    protected PublishOptions dataModel = null;
    private Button publishUnOpenExtendActivityDiagram;

    public PublishConfigPublishOptionsPage(String pageName, boolean displayDestinationGroup, PublishOptions dataModel) {
        super(pageName);
        this.setTitle(PublishingUIResources.publishConfigWizard_selectOptionsPage_title);
        this.setDescription(PublishingUIResources.publishConfigWizard_selectOptionsPage_text);
        this.displayDestinationGroup = displayDestinationGroup;
        this.dataModel = dataModel;
    }

    public PublishConfigPublishOptionsPage(String pageName, PublishOptions dataModel) {
        this(pageName, true, dataModel);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, AuthoringUIHelpContexts.CONFIGURATION_PUBLISH_WIZARD_ALL_PAGES_CONTEXT);
        this.createDestinationGroupUI(composite);
        this.createPublishingOptionsUI(composite);
        this.createPublishingMiscOptionsUI(composite);
        this.initializeControls();
        this.addListeners(composite);
        this.setControl((Control)composite);
    }

    protected void createDestinationGroupUI(Composite composite) {
        if (this.displayDestinationGroup) {
            Group destinationGroup = new Group(composite, 0);
            destinationGroup.setLayout((Layout)new GridLayout(3, false));
            destinationGroup.setLayoutData((Object)new GridData(768));
            destinationGroup.setText(PublishingUIResources.publishConfigWizard_destinationGroup_text);
            this.createLabel((Composite)destinationGroup, PublishingUIResources.publishConfigWizard_directory_text);
            this.destinationPathText = this.createEditableText((Composite)destinationGroup, "", 360, 1);
            String initPath = PublishingUIPreferences.getPublishPath();
            if (initPath == null || initPath.length() <= 0) {
                initPath = PublishingUIPreferences.getDefaultPublishPath();
            }
            this.destinationPathText.setText(initPath);
            this.browseButton = new Button((Composite)destinationGroup, 0);
            this.browseButton.setText(AuthoringUIText.BROWSE_BUTTON_TEXT);
            this.browseButton.setEnabled(false);
            this.createLabel((Composite)destinationGroup, "");
            this.defaultPathCheckbox = this.createCheckbox((Composite)destinationGroup, PublishingUIResources.publishConfigWizard_useDefaultPath_text, 2);
            this.defaultPathCheckbox.setSelection(this.destinationPathText.getText().equals(PublishingUIPreferences.getDefaultPublishPath()));
            this.destinationPathText.setEnabled(!this.defaultPathCheckbox.getSelection());
            if (!this.defaultPathCheckbox.getSelection()) {
                this.browseButton.setEnabled(true);
            }
        }
    }

    protected void createPublishingOptionsUI(Composite composite) {
        Group webSiteGroup = new Group(composite, 0);
        webSiteGroup.setLayout((Layout)new GridLayout(3, false));
        webSiteGroup.setLayoutData((Object)new GridData(768));
        webSiteGroup.setText(PublishingUIResources.publishConfigWizard_webSite_text);
        this.createLabel((Composite)webSiteGroup, PublishingUIResources.publishConfigWizard_title_text);
        this.titleText = this.createEditableText((Composite)webSiteGroup, "", 360, 1);
        this.titleText.setText(PublishingUIPreferences.getTitle());
        this.createLabel((Composite)webSiteGroup, "");
        this.createLabel((Composite)webSiteGroup, PublishingUIResources.publishConfigWizard_bannerImage_text);
        this.bannerImageText = this.createEditableText((Composite)webSiteGroup, "", 360, 1);
        this.bannerImageText.setText(PublishingUIPreferences.getBannerImage());
        this.selectImageButton = new Button((Composite)webSiteGroup, 0);
        this.selectImageButton.setText(AuthoringUIText.SELECT_BUTTON_TEXT);
        this.createLabel((Composite)webSiteGroup, PublishingUIResources.publishConfigWizard_aboutHTML_text);
        this.aboutHTMLText = this.createEditableText((Composite)webSiteGroup, "", 360, 1);
        this.aboutHTMLText.setText(PublishingUIPreferences.getAboutHTML());
        this.selectHTMLButton = new Button((Composite)webSiteGroup, 0);
        this.selectHTMLButton.setText(AuthoringUIText.SELECT_BUTTON_TEXT);
        this.createLabel((Composite)webSiteGroup, PublishingUIResources.publishConfigWizard_feedbackURL_text);
        this.feedbackURLText = this.createEditableText((Composite)webSiteGroup, "", 360, 1);
        String feedbackURL = PublishingUIPreferences.getFeedbackURL();
        if (feedbackURL == null || feedbackURL.length() <= 0) {
            feedbackURL = PublishingUIPreferences.getDefaultFeedbackURL();
        }
        this.feedbackURLText.setText(feedbackURL);
        this.createLabel((Composite)webSiteGroup, "");
        this.includeGlossary = this.createCheckbox((Composite)webSiteGroup, PublishingUIResources.publishConfigWizard_includeGlossary_text, 3);
        this.includeIndex = this.createCheckbox((Composite)webSiteGroup, PublishingUIResources.publishConfigWizard_includeIndex_text, 3);
        this.includeAdditionalPublishingOptions((Composite)webSiteGroup);
    }

    protected void includeAdditionalPublishingOptions(Composite container) {
    }

    protected void createPublishingMiscOptionsUI(Composite composite) {
        Group validationGroup = new Group(composite, 0);
        validationGroup.setLayout((Layout)new GridLayout(1, false));
        validationGroup.setLayoutData((Object)new GridData(768));
        validationGroup.setText(PublishingUIResources.publishConfigWizard_validationGroup_text);
        this.checkExternalLinks = this.createCheckbox((Composite)validationGroup, PublishingUIResources.publishConfigWizard_checkHyperlinks_text);
        this.convertBrokenLinks = this.createCheckbox((Composite)validationGroup, PublishingUIResources.publishConfigWizard_convertBrokenLinks_text);
        Group diagramGroup = new Group(composite, 0);
        diagramGroup.setLayout((Layout)new GridLayout(1, false));
        diagramGroup.setLayoutData((Object)new GridData(768));
        diagramGroup.setText(PublishingUIResources.publishConfigWizard_diagramGroup_text);
        this.autoGenerateActivityDiagrams = this.createCheckbox((Composite)diagramGroup, PublishingUIResources.publishConfigWizard_publish_unopen_activity_dd_text);
        this.publishUnOpenExtendActivityDiagram = this.createCheckbox((Composite)diagramGroup, PublishingUIResources.publishConfigWizard_publish_extend_activity_diagram);
        Group layoutGroup = new Group(composite, 0);
        layoutGroup.setLayout((Layout)new GridLayout());
        layoutGroup.setLayoutData((Object)new GridData(768));
        layoutGroup.setText(PublishingUIResources.publishConfigWizard_layout_text);
        this.lightWeightTreeCtr = this.createCheckbox((Composite)layoutGroup, PublishingUIResources.publishConfigWizard_lightWeightTree_text);
        this.extraDescriptorInfoCtr = this.createCheckbox((Composite)layoutGroup, PublishingUIResources.publishConfigWizard_extraDescriptorInfo_text);
        this.extraDescriptorInfoCtr.setSelection(PublishingUIPreferences.getBooleanValue("org.eclipse.epf.publishing.ui.preferences.extraDescriptorInfo"));
    }

    protected void initializeControls() {
        this.includeGlossary.setSelection(PublishingUIPreferences.getIncludeGlossary());
        this.includeIndex.setSelection(PublishingUIPreferences.getIncludeIndex());
        this.checkExternalLinks.setSelection(PublishingUIPreferences.getCheckExternalLinks());
        this.convertBrokenLinks.setSelection(PublishingUIPreferences.getConvertBrokenLinks());
        this.autoGenerateActivityDiagrams.setSelection(LibraryUIPreferences.getPublishUnopenActivitydd());
        this.publishUnOpenExtendActivityDiagram.setSelection(LibraryUIPreferences.getPublishADForActivityExtension());
        this.lightWeightTreeCtr.setSelection(PublishingUIPreferences.getLightWeightTree());
        this.extraDescriptorInfoCtr.setSelection(PublishingUIPreferences.getExtraDescriptorInfo());
    }

    public boolean isPageComplete() {
        if (!this.displayDestinationGroup) {
            return true;
        }
        if (!PublishConfigPublishOptionsPage.isTextNonEmpty((Text)this.destinationPathText)) {
            this.setErrorMessage(PublishingUIResources.invalidPathError_msg);
            return false;
        }
        String path = this.destinationPathText.getText();
        IPath ecPath = Path.fromOSString((String)path);
        boolean isValid = ecPath.isValidPath(path);
        if (!isValid) {
            this.setErrorMessage(PublishingUIResources.invalidPathError_msg);
        } else if (!StrUtil.isValidPublishPath((String)path)) {
            this.setErrorMessage(PublishingUIResources.invalidPathCharsError_msg);
        } else {
            this.setErrorMessage(null);
            return true;
        }
        return false;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    private void addListeners(final Composite composite) {
        if (this.displayDestinationGroup) {
            this.destinationPathText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PublishConfigPublishOptionsPage.this.setPageComplete(PublishConfigPublishOptionsPage.this.isPageComplete());
                }
            });
            this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    try {
                        DirectoryDialog dd = new DirectoryDialog(composite.getShell(), 0);
                        String destination = dd.open();
                        if (destination != null) {
                            PublishConfigPublishOptionsPage.this.destinationPathText.setText(destination);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            this.defaultPathCheckbox.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (PublishConfigPublishOptionsPage.this.defaultPathCheckbox.getSelection()) {
                        PublishConfigPublishOptionsPage.this.destinationPathText.setText(PublishingUIPreferences.getDefaultPublishPath());
                        PublishConfigPublishOptionsPage.this.destinationPathText.setEnabled(false);
                        PublishConfigPublishOptionsPage.this.browseButton.setEnabled(false);
                    } else {
                        String initPath = PublishingUIPreferences.getPublishPath();
                        if (initPath == null || initPath.length() <= 0) {
                            initPath = PublishingUIPreferences.getDefaultPublishPath();
                        }
                        PublishConfigPublishOptionsPage.this.destinationPathText.setText(initPath);
                        PublishConfigPublishOptionsPage.this.destinationPathText.setEnabled(true);
                        PublishConfigPublishOptionsPage.this.browseButton.setEnabled(true);
                    }
                }
            });
        }
        this.selectImageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    FileDialog dialog = new FileDialog(composite.getShell(), 4096);
                    dialog.setFilterExtensions(new String[]{"*.gif", "*.jpg", "*.bmp"});
                    String imageFile = dialog.open();
                    if (imageFile != null) {
                        PublishConfigPublishOptionsPage.this.bannerImageText.setText(imageFile);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.selectHTMLButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    FileDialog dialog = new FileDialog(composite.getShell(), 4096);
                    dialog.setFilterExtensions(new String[]{"*.htm", "*.html"});
                    String htmlFile = dialog.open();
                    if (htmlFile != null) {
                        PublishConfigPublishOptionsPage.this.aboutHTMLText.setText(htmlFile);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void setVisible(boolean visible) {
        Display display;
        super.setVisible(visible);
        if (visible && (display = this.titleText.getDisplay()) != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    PublishConfigPublishOptionsPage.this.titleText.setFocus();
                }
            });
        }
    }

    public PublishOptions getPublishingOptions() {
        if (this.displayDestinationGroup) {
            this.dataModel.setPublicationPath(this.destinationPathText.getText().trim());
        }
        this.dataModel.setTitle(this.titleText.getText().trim());
        this.dataModel.setBannerImage(this.bannerImageText.getText().trim());
        this.dataModel.aboutHTML = this.aboutHTMLText.getText().trim();
        this.dataModel.feedbackURL = this.feedbackURLText.getText().trim();
        this.dataModel.generateGlossary = this.includeGlossary.getSelection();
        this.dataModel.generateIndex = this.includeIndex.getSelection();
        this.dataModel.checkExtLinks = this.checkExternalLinks.getSelection();
        this.dataModel.autoGenerateActivityDiagrams = this.autoGenerateActivityDiagrams.getSelection();
        this.dataModel.setUnopenExtendedActivityDiagram(this.publishUnOpenExtendActivityDiagram.getSelection());
        this.dataModel.convertBrokenLinks = this.convertBrokenLinks.getSelection();
        this.dataModel.showExtraDescriptorInfo = this.extraDescriptorInfoCtr.getSelection();
        this.dataModel.generateLightWeightTree = this.lightWeightTreeCtr.getSelection();
        return this.dataModel;
    }
}

