/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration;

import org.eclipse.epf.library.configuration.ConfigurationFilter;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.jface.viewers.Viewer;

public class ProcessConfigurator
extends ConfigurationFilter {
    private boolean checkOwningProcess;

    public ProcessConfigurator(MethodConfiguration methodConfig, Viewer viewer) {
        super(methodConfig, viewer);
    }

    public ProcessConfigurator(MethodConfiguration methodConfig, Viewer viewer, boolean checkOwningProcess) {
        this(methodConfig, viewer);
        this.checkOwningProcess = checkOwningProcess;
    }

    public void setMethodConfiguration(MethodConfiguration newConfig) {
        this.methodConfig = newConfig;
    }

    public boolean accept(Object obj) {
        if (this.methodConfig == null) {
            return true;
        }
        if (obj instanceof BreakdownElement) {
            return this.accept((BreakdownElement)obj);
        }
        return super.accept(obj);
    }

    protected boolean accept(BreakdownElement e) {
        if (e instanceof Milestone || e instanceof TeamProfile) {
            return true;
        }
        if (e instanceof Activity) {
            Activity act = (Activity)e;
            Activity base = (Activity)act.getVariabilityBasedOnElement();
            VariabilityType type = act.getVariabilityType();
            if (base == null) {
                if (this.checkOwningProcess) {
                    return ConfigurationHelper.inConfig((MethodElement)TngUtil.getOwningProcess((BreakdownElement)act), this.methodConfig);
                }
                return true;
            }
            if (type == VariabilityType.EXTENDS_LITERAL || type == VariabilityType.LOCAL_CONTRIBUTION_LITERAL || type == VariabilityType.LOCAL_REPLACEMENT_LITERAL) {
                return ConfigurationHelper.inConfig((MethodElement)TngUtil.getOwningProcess((BreakdownElement)base), this.methodConfig);
            }
            return true;
        }
        if (e instanceof Descriptor) {
            MethodElement linked_obj = ProcessUtil.getAssociatedElement((Descriptor)((Descriptor)e));
            if (linked_obj == null || linked_obj.eIsProxy()) {
                return true;
            }
            linked_obj = ConfigurationHelper.getCalculatedElement(linked_obj, this.methodConfig);
            return ConfigurationHelper.inConfig(linked_obj, this.methodConfig);
        }
        return super.accept(e);
    }
}

