/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.preferences;

import org.eclipse.epf.richtext.RichTextPlugin;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class RichTextPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener,
ModifyListener {
    private IPreferenceStore store;
    private Text lineWidthText;
    private Button indentCheckbox;
    private Text indentSizeText;

    public void init(IWorkbench workbench) {
        this.store = RichTextPlugin.getDefault().getPreferenceStore();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(768));
        Composite widthComposite = new Composite(composite, 0);
        widthComposite.setLayout((Layout)new GridLayout(2, false));
        widthComposite.setLayoutData((Object)new GridData(768));
        Label lineWidthLabel = new Label(widthComposite, 0);
        lineWidthLabel.setText(RichTextResources.maxCharsPerLineLabel_text);
        this.lineWidthText = new Text(widthComposite, 2048);
        this.lineWidthText.setText(this.store.getString("htmlEditor.lineWidth"));
        this.lineWidthText.setTextLimit(3);
        GridData gridData = new GridData();
        gridData.widthHint = 25;
        this.lineWidthText.setLayoutData((Object)gridData);
        this.lineWidthText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        Composite indentComposite = new Composite(composite, 0);
        indentComposite.setLayout((Layout)new GridLayout(2, false));
        indentComposite.setLayoutData((Object)new GridData(768));
        this.indentCheckbox = new Button(indentComposite, 32);
        this.indentCheckbox.setText(RichTextResources.indentHTMLCheckbox_text);
        this.indentCheckbox.setSelection(this.store.getBoolean("htmlEditor.indent"));
        new Label(indentComposite, 0);
        Label indentSizeLabel = new Label(indentComposite, 0);
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        indentSizeLabel.setLayoutData((Object)gridData);
        indentSizeLabel.setText(RichTextResources.indentSizeLabel_text);
        this.indentSizeText = new Text(indentComposite, 2048);
        this.indentSizeText.setText(this.store.getString("htmlEditor.indentSize"));
        this.indentSizeText.setTextLimit(1);
        gridData = new GridData();
        gridData.widthHint = 10;
        this.indentSizeText.setLayoutData((Object)gridData);
        this.indentSizeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        return composite;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.lineWidthText.setText(this.store.getDefaultString("htmlEditor.lineWidth"));
        this.indentCheckbox.setSelection(this.store.getDefaultBoolean("htmlEditor.indent"));
        this.indentSizeText.setText(this.store.getDefaultString("htmlEditor.indentSize"));
    }

    public boolean performOk() {
        String lineWidthValue = this.lineWidthText.getText();
        if (lineWidthValue != null && lineWidthValue.length() > 0) {
            try {
                int lineWidth = Integer.parseInt(lineWidthValue);
                this.store.setValue("htmlEditor.lineWidth", lineWidth);
            }
            catch (Exception exception) {}
        }
        boolean indentValue = this.indentCheckbox.getSelection();
        this.store.setValue("htmlEditor.indent", indentValue);
        String indentSizeValue = this.indentSizeText.getText();
        if (indentSizeValue != null && indentSizeValue.length() > 0) {
            try {
                int indentSize = Integer.parseInt(indentSizeValue);
                this.store.setValue("htmlEditor.indentSize", indentSize);
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void modifyText(ModifyEvent e) {
    }
}

