<?xml version="1.0" encoding="UTF-8"?>
<!-- 
    Copyright (c) 2005, 2006 IBM Corporation and others.
    All rights reserved. This program and the accompanying materials
    are made available under the terms of the Eclipse Public License v1.0
    which accompanies this distribution, and is available at
    http://www.eclipse.org/legal/epl-v10.html
    Contributors:
    IBM Corporation - initial implementation
-->

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

	<xsl:include href="helper.xsl"/>
	
	
	<xsl:template match="/Element">
		<xsl:variable name="elementType" select="@Type"/>
		<xsl:variable name="elementTypeName" select="@TypeName"/>
		<xsl:variable name="elementName" select="@Name"/>
		<xsl:variable name="elementPresentationName" select="@DisplayName"/>
		<xsl:variable name="backPath" select="@BackPath"/>
		<xsl:variable name="imagePath" select="concat($backPath, 'images/')"/>
	    <xsl:variable name="shapeImage" select="concat($backPath,@ShapeiconUrl)"/>
		<xsl:variable name="presentation" select="reference[@name='presentation']"/>
		<xsl:variable name="descriptorDescription" select="$presentation/Element[@Type='DescriptorDescription']"/>		
		<xsl:variable name="copyright" select="copyright"/>
		<xsl:variable name="showTreeBrowser" select="@showTreeBrowser"/>
		<xsl:variable name="performingRole" select="reference[@name='performedPrimarilyBy']/Element[@Type='RoleDescriptor']"/>
		<xsl:variable name="queryString" select="@queryString"/>
		<xsl:variable name="relProcessPath" select="@relProcessPath"/>
		
		<html>
			<head>
				<title><xsl:value-of select="$elementTypeName"/>: <xsl:value-of select="$elementPresentationName"/></title>
				<xsl:call-template name="umaMetaTags">
					<xsl:with-param name="elementType" select="$elementType"/>
					<xsl:with-param name="elementName" select="$elementName"/>
					<xsl:with-param name="elementPresentationName" select="$elementPresentationName"/>
				</xsl:call-template>
				<meta name="element_type" content="{$elementType}"/>
				<meta name="filetype" content="description"/>
				<meta name="role">
					<xsl:attribute name="content"><xsl:value-of select="$performingRole/@DisplayName"/></xsl:attribute>
				</meta>
				<link rel="StyleSheet" href="{$backPath}css/default.css" type="text/css"/>
				<script language="JavaScript" type="text/javascript" src="{$backPath}scripts/elementUrls.js"></script>
				<script language="JavaScript" type="text/javascript" src="{$backPath}scripts/contentpage.js"></script>
				<script language="JavaScript" type="text/javascript" src="{$backPath}scripts/steps.js"></script>
				<script language="JavaScript" type="text/javascript" src="{$backPath}scripts/activitylayout.js"/>
				<script  language="JavaScript" type="text/javascript" >
					backPath = '<xsl:value-of select="$backPath"/>';
					imgPath = '<xsl:value-of select="$imagePath"/>';
					// get url parameters here
					// query string from url take precedence, if not, use the one passed in form xml
					// this handles both published site, and browsing, where user click in a node, there is no url parameter
					var defaultQueryStr = '<xsl:value-of select="$queryString"/>';
					var queryStr = location.search;
					if ( queryStr == null || queryStr == "" )
					{
						queryStr = defaultQueryStr;
					}
					var parameters = getUrlParameters(queryStr.substring(1));
					var par_proc = parameters["proc"];
					var par_path = parameters["path"];
				</script>
			</head>
			<body onload="createSectionLinks('div', 'sectionHeading', '{$imagePath}'); createStepLinks('div', 'stepHeading');">
				<script language="JavaScript" type="text/javascript">buildProcessElementBreadCrumb(backPath);</script>
				<table border="0" cellpadding="0" cellspacing="0" width="100%">
					<tr>
						<td valign="top">
							<xsl:call-template name="overview">
								<xsl:with-param name="elementType" select="$elementType"/>
								<xsl:with-param name="elementTypeName" select="$elementTypeName"/>
								<xsl:with-param name="elementPresentationName" select="$elementPresentationName"/>
								<xsl:with-param name="elementIcon" select="$shapeImage"/>
								<xsl:with-param name="backPath" select="$backPath"/>
								<xsl:with-param name="showTreeBrowser" select="$showTreeBrowser"/>
							</xsl:call-template>		
							
								<xsl:call-template name="purposeSection">
								<xsl:with-param name="description" select="$descriptorDescription"/>
							</xsl:call-template>
				
							<xsl:call-template name="relationshipsSection"/>
							<xsl:call-template name="refinedDescriptionSection">
								<xsl:with-param name="description" select="$descriptorDescription"/>
							</xsl:call-template>
							<xsl:call-template name="stepsSection"/>
							<xsl:call-template name="propertiesSection"/>
							<xsl:call-template name="usageSection">
								<xsl:with-param name="description" select="$descriptorDescription"/>
							</xsl:call-template>
							<xsl:call-template name="illustrationsSection"/>
							<xsl:call-template name="keyConsiderationsSection">
								<xsl:with-param name="description" select="$descriptorDescription"/>
							</xsl:call-template>
							<xsl:call-template name="alternativesSection">
								<xsl:with-param name="description" select="$descriptorDescription"/>
							</xsl:call-template>
							<xsl:call-template name="moreInfoSection"/>

							<xsl:call-template name="copyright">
								<xsl:with-param name="copyright" select="$copyright"/>
							</xsl:call-template>
						</td>						
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template name="propertiesSection">
		<xsl:param name="contentDescription"/>
		<div class="sectionHeading"><xsl:value-of select="$propertiesText"/></div>
		<div class="sectionContent">
			<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
			    <xsl:if test="referenceList[@name='linkToPredecessor']/Element">
					<xsl:call-template name="addReferences">
						<xsl:with-param name="refName" select="$predecessorText"/>
						<xsl:with-param name="refElement" select="referenceList[@name='linkToPredecessor']/Element"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="attribute[@name='PlanningData']">
					<xsl:call-template name="property">
						<xsl:with-param name="fieldLabel" select="$planningDataText"/>
						<xsl:with-param name="fieldText" select="attribute[@name='PlanningData']"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:call-template name="property">
					<xsl:with-param name="fieldLabel" select="$multipleOccurrencesText"/>
					<xsl:with-param name="fieldText" select="attribute[@name='hasMultipleOccurrences']"/>
				</xsl:call-template>
				<xsl:call-template name="property">
					<xsl:with-param name="fieldLabel" select="$eventDrivenText"/>
					<xsl:with-param name="fieldText" select="attribute[@name='isEventDriven']"/>
				</xsl:call-template>
				<xsl:if test="attribute[@name='isOngoing']">
					<xsl:call-template name="property">
						<xsl:with-param name="fieldLabel" select="$ongoingText"/>
						<xsl:with-param name="fieldText" select="attribute[@name='isOngoing']"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="attribute[@name='isOptional']">
					<xsl:call-template name="property">
						<xsl:with-param name="fieldLabel" select="$optionalText"/>
						<xsl:with-param name="fieldText" select="attribute[@name='isOptional']"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="attribute[@name='isPlanned']">
					<xsl:call-template name="property">
						<xsl:with-param name="fieldLabel" select="$plannedText"/>
						<xsl:with-param name="fieldText" select="attribute[@name='isPlanned']"/>
					</xsl:call-template>
				</xsl:if>				
				<xsl:if test="attribute[@name='isRepeatable']">
					<xsl:call-template name="property">
						<xsl:with-param name="fieldLabel" select="$repeatableText"/>
						<xsl:with-param name="fieldText" select="attribute[@name='isRepeatable']"/>
					</xsl:call-template>
				</xsl:if>				
			</table>
		</div>
	</xsl:template>
	
	<!--
	<xsl:template name="usageSection">
		<xsl:param name="contentDescription"/>
		<xsl:if test="$contentDescription/attribute[@name='usageGuidance'] != ''">
			<div class="sectionHeading"><xsl:value-of select="$usageText"/></div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<xsl:call-template name="property">
						<xsl:with-param name="fieldLabel" select="'Usage Guidance'"/>
						<xsl:with-param name="fieldText" select="$contentDescription/attribute[@name='usageGuidance']"/>
					</xsl:call-template>
				</table>
			</div>
		</xsl:if>
	</xsl:template>
	-->
	
	<xsl:template name="usageSection">
		<xsl:param name="description"/>
		<xsl:variable name="usageGuidance" select="$description/attribute[@name='usageGuidance']"/>
		<xsl:if test="$usageGuidance != ''">
			<div class="sectionHeading"><xsl:value-of select="$usageGuidanceText"/></div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<tr valign="top">
						<td class="sectionTableCell">
							<xsl:value-of disable-output-escaping="yes" select="$usageGuidance"/>
						</td>
					</tr>
				</table>
			</div>
		</xsl:if>
	</xsl:template>	
	
	<xsl:template name="relationshipsSection">
		<xsl:variable name="performingRole" select="reference[@name='performedPrimarilyBy']/Element[@Type='RoleDescriptor']"/>
		<xsl:variable name="additionallyPerformedBy" select="referenceList[@name='additionallyPerformedBy']/Element"/>
		<xsl:variable name="assistedBy" select="referenceList[@name='assistedBy']/Element"/>
		<xsl:variable name="mandatoryInputs" select="referenceList[@name='mandatoryInput']/Element"/>
		<xsl:variable name="optionalInputs" select="referenceList[@name='optionalInput']/Element"/>
		<xsl:variable name="externalInput" select="referenceList[@name='externalInput']/Element"/>
		<xsl:variable name="outputs" select="referenceList[@name='output']/Element"/>
		<xsl:variable name="imagePath" select="concat(/Element/@BackPath, 'images/')"/>

		<xsl:if test="count($performingRole) + count($additionallyPerformedBy) + count($mandatoryInputs) + count($optionalInputs) + count($outputs) > 0">
			<div class="sectionHeading"><xsl:value-of select="$relationshipsText"/></div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">					
					<tr valign="top">
						<th class="sectionTableHeading" scope="row"><xsl:value-of select="$rolesText"/></th>
						<td class="sectionTableCell" width="30%">
							<xsl:value-of select="$mainText"/>:
							<xsl:if test="count($performingRole) > 0">
								<ul>
									<li>
										<a><xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="$performingRole/@Url"/></xsl:attribute><xsl:value-of select="$performingRole/@DisplayName"/></a>
									</li>
								</ul>
							</xsl:if>
						</td>
						<td class="sectionTableCell" width="30%">								
							<xsl:value-of select="$additionalText"/>:
							<xsl:if test="count($additionallyPerformedBy) > 0">
							<ul>
								<xsl:for-each select="$additionallyPerformedBy">
								<xsl:sort select="@DisplayName"/>
									<li>
										<a><xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute><xsl:value-of select="@DisplayName"/></a>
									</li>
								</xsl:for-each>
							</ul>
							</xsl:if>
						</td>
						<td class="sectionTableCell">								
							<xsl:value-of select="$assistingText"/>:
							<xsl:if test="count($assistedBy) > 0">									
							<ul>
								<xsl:for-each select="$assistedBy">
								<xsl:sort select="@DisplayName"/>
									<li>
										<a><xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute><xsl:value-of select="@DisplayName"/></a>
									</li>
								</xsl:for-each>
							</ul>
							</xsl:if>
						</td>
					</tr>					
					<xsl:if test="count($mandatoryInputs) + count($optionalInputs) > 0">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$inputsText"/></th>
							<td class="sectionTableCell" width="30%">
								<xsl:value-of select="$mandatoryText"/>:
								<xsl:choose>
									<xsl:when test="count($mandatoryInputs) > 0">
									<ul>
										<xsl:for-each select="$mandatoryInputs">
										<xsl:sort select="@DisplayName"/>
											<li>
												<a><xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute><xsl:value-of select="@DisplayName"/></a>
											</li>
										</xsl:for-each>							
									</ul>
									</xsl:when>				
									<xsl:otherwise>
									<ul>
										<li>
											<xsl:value-of select="$noneText"/>
										</li>
									</ul>									
									</xsl:otherwise>									
								</xsl:choose>
							</td>
							<td class="sectionTableCell" width="30%">
								<xsl:value-of select="$optionalText"/>:
								<xsl:choose>
									<xsl:when test="count($optionalInputs) > 0">
									<ul>
										<xsl:for-each select="$optionalInputs">
										<xsl:sort select="@DisplayName"/>
											<li>
												<a><xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute><xsl:value-of select="@DisplayName"/></a>
											</li>
										</xsl:for-each>							
									</ul>
									</xsl:when>				
									<xsl:otherwise>
									<ul>
										<li>
											<xsl:value-of select="$noneText"/>
										</li>
									</ul>									
									</xsl:otherwise>									
								</xsl:choose>
							</td>
							<td class="sectionTableCell">
								<xsl:value-of select="$externalText"/>:
								<xsl:choose>
									<xsl:when test="count($externalInput) > 0">
									<ul>
										<xsl:for-each select="$externalInput">
										<xsl:sort select="@DisplayName"/>
											<li>
												<a><xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="@Url"/></xsl:attribute><xsl:value-of select="@DisplayName"/></a>
											</li>
										</xsl:for-each>							
									</ul>
									</xsl:when>				
									<xsl:otherwise>
									<ul>
										<li>
											<xsl:value-of select="$noneText"/>
										</li>
									</ul>									
									</xsl:otherwise>									
								</xsl:choose>
							</td>					
						</tr>
					</xsl:if>
					<xsl:if test="count($outputs) > 0">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row"><xsl:value-of select="$outputsText"/></th>
							<td class="sectionTableCell" colspan="3">
								<ul>
								<xsl:for-each select="$outputs">
								<xsl:sort select="@DisplayName"/>
									<li>
										<a>
											<xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/>
												<xsl:value-of select="@Url"/></xsl:attribute><xsl:value-of select="@DisplayName"/>
										</a>
									</li>
								</xsl:for-each>
								</ul>
							</td>
						</tr>
					</xsl:if>
				</table>
			</div>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="stepsSection">
		<xsl:variable name="sections" select="referenceList[@name='selectedSteps']/Element[@Type='Section']"/>
		<xsl:if test="count($sections) > 0">
			<div class="sectionHeading"><xsl:value-of select="$stepsText"/></div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<tr>
						<td class="sectionTableCell">
							<xsl:for-each select="$sections">
								<div class="stepHeading"><xsl:value-of select="attribute[@name='name']"/></div>
								<div class="stepContent">
									<table class="stepTable" border="0" cellspacing="0" cellpadding="0">
										<tr valign="top">
											<td>
												<xsl:value-of disable-output-escaping="yes" select="attribute[@name='sectionDescription']"/>
											</td>
										</tr>
									</table>
								</div>						
							</xsl:for-each>
						</td>
					</tr>
				</table>
			</div>
		</xsl:if>
	</xsl:template>
	
	
		<xsl:template name="moreInfoSection">
		<xsl:variable name="checklists" select="referenceList/Element[@Type='Checklist']"/>
		<xsl:variable name="concepts" select="referenceList/Element[@Type='Concept']"/>	
		<xsl:variable name="guidelines" select="referenceList/Element[@Type='Guideline']"/>
		<xsl:variable name="supportingMaterials" select="referenceList/Element[@Type='SupportingMaterial']"/>
		<xsl:variable name="toolMentors" select="referenceList/Element[@Type='ToolMentor']"/>
		<xsl:variable name="whitePapers" select="referenceList/Element[@Type='Whitepaper']"/>		
		<xsl:variable name="imagePath" select="concat(/Element/@BackPath, 'images/')"/>
		
		<xsl:if test="count($checklists) + count($concepts) + count($guidelines) + count($supportingMaterials) + count($toolMentors) + count($whitePapers) > 0">
			<div class="sectionHeading"><xsl:value-of select="$moreInfoText"/></div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<xsl:call-template name="addChecklists">
						<xsl:with-param name="checklists" select="$checklists"/>
					</xsl:call-template>
					<xsl:call-template name="addConcepts">
						<xsl:with-param name="concepts" select="$concepts"/>
					</xsl:call-template>
					<xsl:call-template name="addGuidelines">
						<xsl:with-param name="guidelines" select="$guidelines"/>
					</xsl:call-template>
					<xsl:call-template name="addSupportingMaterials">
						<xsl:with-param name="supportingMaterials" select="$supportingMaterials"/>
					</xsl:call-template>
					<xsl:call-template name="addToolMentors">
						<xsl:with-param name="toolMentors" select="$toolMentors"/>
					</xsl:call-template>
					<xsl:call-template name="addWhitePapers">
						<xsl:with-param name="whitePapers" select="$whitePapers"/>
					</xsl:call-template>
				</table>
			</div>
		</xsl:if>
	</xsl:template>
	
		<xsl:template name="alternativesSection">
		<xsl:param name="description"/>
		<xsl:variable name="alternatives" select="$description/attribute[@name='alternatives']"/>
		<xsl:if test="$alternatives != '' ">
			<div class="sectionHeading"><xsl:value-of select="$alternativesText"/></div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<tr valign="top">
						<td class="sectionTableCell">
							<xsl:value-of disable-output-escaping="yes" select="$alternatives"/>
						</td>
					</tr>
				</table>
			</div>
		</xsl:if>
	</xsl:template>
	
</xsl:stylesheet>