/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.xml;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.epf.common.serviceability.Logger;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.common.utils.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractSAXParser
extends DefaultHandler {
    protected Logger logger;
    protected String xmlFile;
    protected StringBuffer strBuf;
    private boolean validating;

    public AbstractSAXParser(Logger logger, boolean validating) {
        this.logger = logger;
        this.validating = validating;
    }

    public void parse(String xmlPath) {
        File[] files;
        File[] fileArray;
        String pathName = StrUtil.replace(xmlPath, "%20", " ");
        File path = new File(pathName);
        if (path.isFile()) {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = path;
        } else {
            fileArray = files = path.listFiles();
        }
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                block7: {
                    if (!files[i].isDirectory()) {
                        try {
                            this.parseFile(files[i].getAbsoluteFile());
                        }
                        catch (Exception e) {
                            if (this.logger == null) break block7;
                            this.logger.logError("Failed to parse \"" + files[i].getAbsolutePath() + '\"', e);
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected void parseFile(File xmlFile) throws ParserConfigurationException, IOException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setValidating(this.validating);
        SAXParser saxParser = spf.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader.setContentHandler(this);
        xmlReader.setErrorHandler(this);
        this.xmlFile = xmlFile.getAbsolutePath();
        xmlReader.parse(NetUtil.getUri(xmlFile));
    }

    public void startDocument() {
        this.strBuf = new StringBuffer();
    }

    public void characters(char[] buffer, int start, int length) {
        this.strBuf.append(buffer, start, length);
    }

    public abstract void startElement(String var1, String var2, String var3, Attributes var4);

    public abstract void endElement(String var1, String var2, String var3);

    public void endDocument() {
    }

    public void warning(SAXParseException e) {
        if (this.logger != null) {
            this.logger.logWarning("SAX parsing warning encountered at " + XMLUtil.getLocationOfException(e) + ": " + e.getMessage());
        }
    }

    public void error(SAXParseException e) {
        if (this.logger != null) {
            this.logger.logError("SAX parsing error encountered at " + XMLUtil.getLocationOfException(e) + ": " + e.getMessage());
        }
    }

    public void fatalError(SAXParseException e) throws SAXException {
        if (this.logger != null) {
            this.logger.logError("SAX parsing fatal error encountered at " + XMLUtil.getLocationOfException(e) + ": " + e.getMessage());
            this.logger.logError(e);
        }
    }

    public String getXMLFile() {
        return this.xmlFile;
    }
}

