/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.wizards;

import java.util.Iterator;
import java.util.List;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.export.ExportPlugin;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.export.services.PluginExportData;
import org.eclipse.epf.library.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ExportPluginSummaryPage
extends BaseWizardPage {
    public static final String PAGE_NAME;
    private TextViewer textViewer;
    private TextPresentation style;
    private PluginExportData data;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.export.wizards.ExportPluginSummaryPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PAGE_NAME = clazz.getName();
    }

    public ExportPluginSummaryPage(PluginExportData data) {
        super(PAGE_NAME);
        this.setTitle(ExportResources.exportPluginSummaryPage_title);
        this.setDescription(ExportResources.exportPluginSummaryPage_desc);
        this.setImageDescriptor(ExportPlugin.getDefault().getImageDescriptor("full/wizban/ExportMethodPlugins.gif"));
        this.data = data;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.textViewer = this.createTextViewer(container, 360, 160, 1);
        Document doc = new Document("");
        this.textViewer.setDocument((IDocument)doc);
        this.setControl((Control)container);
        this.setPageComplete(true);
    }

    private void displaySummary() {
        this.style = new TextPresentation();
        Document doc = this.getSummaryText();
        this.textViewer.setDocument((IDocument)doc);
        this.textViewer.changeTextPresentation(this.style, true);
    }

    public void onEnterPage() {
        this.displaySummary();
    }

    public Document getSummaryText() {
        StringBuffer textBuf = new StringBuffer();
        if (this.data.selectedPlugins == null || this.data.selectedPlugins.isEmpty()) {
            return new Document(ExportResources.exportPluginSummaryPage_noPlugin_text);
        }
        int start = 0;
        int offset = 0;
        int i = 0;
        while (i < this.data.selectedPlugins.size()) {
            MethodPlugin plugin = (MethodPlugin)this.data.selectedPlugins.get(i);
            start = textBuf.length();
            offset = plugin.getName().length();
            this.style.addStyleRange(new StyleRange(start, offset, null, null, 1));
            textBuf.append(plugin.getName()).append("\n");
            start = textBuf.length();
            offset = AuthoringUIText.AUTHORS_TEXT.length();
            this.style.addStyleRange(new StyleRange(start, offset, null, null, 3));
            textBuf.append("\t").append(AuthoringUIText.AUTHORS_TEXT).append("\n");
            textBuf.append("\t\t").append(plugin.getAuthors()).append("\n");
            start = textBuf.length();
            offset = AuthoringUIText.VERSION_TEXT.length();
            this.style.addStyleRange(new StyleRange(start, offset, null, null, 3));
            textBuf.append("\t").append(AuthoringUIText.VERSION_TEXT).append("\n");
            textBuf.append("\t\t").append(plugin.getVersion()).append("\n");
            start = textBuf.length();
            offset = AuthoringUIText.BRIEF_DESCRIPTION_TEXT.length();
            this.style.addStyleRange(new StyleRange(start, offset, null, null, 3));
            textBuf.append("\t").append(AuthoringUIText.BRIEF_DESCRIPTION_TEXT).append("\n");
            textBuf.append("\t\t").append(plugin.getBriefDescription()).append("\n");
            start = textBuf.length();
            offset = ExportResources.reviewPluginsPage_dependentPluginsLabel_text.length();
            this.style.addStyleRange(new StyleRange(start, offset, null, null, 3));
            textBuf.append("\t").append(ExportResources.reviewPluginsPage_dependentPluginsLabel_text).append("\n");
            List dependentPluginList = plugin.getBases();
            boolean addLinefeed = true;
            Iterator iter = dependentPluginList.iterator();
            while (iter.hasNext()) {
                MethodPlugin element = (MethodPlugin)iter.next();
                textBuf.append("\t\t").append(element.getName()).append("\n");
                addLinefeed = false;
            }
            if (addLinefeed) {
                textBuf.append("\n");
            }
            start = textBuf.length();
            offset = ExportResources.reviewPluginsPage_associatedConfigsLabel_text.length();
            this.style.addStyleRange(new StyleRange(start, offset, null, null, 3));
            textBuf.append("\t").append(ExportResources.reviewPluginsPage_associatedConfigsLabel_text).append("\n");
            List associatedConfigList = (List)this.data.associatedConfigMap.get(plugin);
            Iterator iter2 = associatedConfigList.iterator();
            while (iter2.hasNext()) {
                MethodConfiguration element = (MethodConfiguration)iter2.next();
                textBuf.append("\t\t").append(element.getName()).append("\n");
            }
            textBuf.append("\n");
            ++i;
        }
        Document doc = new Document(textBuf.toString());
        return doc;
    }
}

